/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.methods.DepthSupport;
import org.apache.webdav.lib.methods.HttpRequestBodyMethodBase;
import org.apache.webdav.lib.methods.PropFindMethod;
import org.apache.webdav.lib.methods.ReportMethod;
import org.apache.webdav.lib.properties.AclProperty;
import org.apache.webdav.lib.properties.CurrentUserPrivilegeSetProperty;
import org.apache.webdav.lib.properties.GetLastModifiedProperty;
import org.apache.webdav.lib.properties.LockDiscoveryProperty;
import org.apache.webdav.lib.properties.OwnerProperty;
import org.apache.webdav.lib.properties.PrincipalCollectionSetProperty;
import org.apache.webdav.lib.properties.ResourceTypeProperty;
import org.apache.webdav.lib.properties.SupportedLockProperty;
import org.apache.webdav.lib.util.DOMUtils;
import org.apache.webdav.lib.util.DOMWriter;
import org.apache.webdav.lib.util.XMLDebugOutputer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLResponseMethodBase
extends HttpRequestBodyMethodBase {
    private int debug = 0;
    private XMLDebugOutputer xo = new XMLDebugOutputer();
    private Document responseDocument = null;
    protected DocumentBuilder builder = null;
    private Hashtable responseHashtable = null;
    protected Vector responseURLs = null;

    public XMLResponseMethodBase() {
    }

    public XMLResponseMethodBase(String uri) {
        super(uri);
    }

    public Document getResponseDocument() {
        return this.responseDocument;
    }

    public Enumeration getResponses() {
        return this.getResponseHashtable().elements();
    }

    public void setDebug(int debug) {
        this.debug = debug;
        this.xo.setDebug(debug > 0);
    }

    public int getDebug() {
        return this.debug;
    }

    public void recycle() {
        super.recycle();
        this.responseHashtable = null;
        this.responseURLs = null;
    }

    protected void readResponseBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.readResponseBody(state, conn);
        InputStream inStream = this.getResponseBodyAsStream();
        if (inStream != null) {
            this.parseResponse(inStream, state, conn);
            inStream.close();
        }
    }

    protected int getRequestContentLength() {
        if (!this.isRequestContentAlreadySet()) {
            String contents = this.generateRequestBody();
            if (contents == null) {
                contents = "";
            }
            this.setRequestBody(contents);
            if (this.debug > 0) {
                System.out.println("\n>>>>>>>  to  server  ---------------------------------------------------");
                System.out.println(this.getName() + " " + this.getPath() + (this.getQueryString() != null ? "?" + this.getQueryString() : "") + " " + "HTTP/1.1");
                Header[] headers = this.getRequestHeaders();
                int i = 0;
                while (i < headers.length) {
                    Header header = headers[i];
                    System.out.print(header.toString());
                    ++i;
                }
                System.out.println("Content-Length: " + super.getRequestContentLength());
                if (this instanceof DepthSupport) {
                    System.out.println("Depth: " + ((DepthSupport)((Object)this)).getDepth());
                }
                System.out.println();
                this.xo.print(contents);
                System.out.println("------------------------------------------------------------------------");
            }
        }
        return super.getRequestContentLength();
    }

    protected String generateRequestBody() {
        return "";
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.getRequestContentLength() > 0) {
            return super.writeRequestBody(state, conn);
        }
        return true;
    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn) throws IOException, HttpException {
        block2: {
            if (this.getStatusCode() != 207 && (!(this instanceof PropFindMethod) && !(this instanceof ReportMethod) || this.getStatusCode() != 200)) break block2;
            try {
                this.parseXMLResponse(input);
            }
            catch (IOException e) {}
        }
    }

    protected void parseXMLResponse(InputStream input) throws IOException, HttpException {
        if (this.builder == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                this.builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new HttpException("XML Parser Configuration error: " + e.getMessage());
            }
        }
        try {
            this.builder.setErrorHandler(new DummyErrorHandler());
            this.responseDocument = this.builder.parse(new InputSource(input));
            if (this.debug > 0) {
                System.out.println("\n<<<<<<< from server  ---------------------------------------------------");
                System.out.println(this.getStatusLine());
                Header[] headers = this.getResponseHeaders();
                int i = 0;
                while (i < headers.length) {
                    Header header = headers[i];
                    System.out.print(header.toString());
                    ++i;
                }
                System.out.println();
                this.xo.print(this.responseDocument);
                System.out.println("------------------------------------------------------------------------");
            }
        }
        catch (Exception e) {
            throw new IOException("XML parsing error; response stream is not valid XML: " + e.getMessage());
        }
    }

    protected Hashtable getResponseHashtable() {
        this.checkUsed();
        if (this.responseHashtable == null) {
            this.initResponseHashtable();
        }
        return this.responseHashtable;
    }

    protected Vector getResponseURLs() {
        this.checkUsed();
        if (this.responseHashtable == null) {
            this.initResponseHashtable();
        }
        return this.responseURLs;
    }

    private synchronized void initResponseHashtable() {
        if (this.responseHashtable == null) {
            this.responseHashtable = new Hashtable();
            this.responseURLs = new Vector();
            int status = this.getStatusLine().getStatusCode();
            if (status == 207 || (this instanceof PropFindMethod || this instanceof ReportMethod) && status == 200) {
                Document rdoc = this.getResponseDocument();
                NodeList list = null;
                if (rdoc != null) {
                    Element multistatus = this.getResponseDocument().getDocumentElement();
                    list = multistatus.getChildNodes();
                }
                if (list != null) {
                    int i = 0;
                    while (i < list.getLength()) {
                        try {
                            Element child = (Element)list.item(i);
                            String name = DOMUtils.getElementLocalName(child);
                            String namespace = DOMUtils.getElementNamespaceURI(child);
                            if ("response".equals(name) && "DAV:".equals(namespace)) {
                                ResponseWithinMultistatus response = new ResponseWithinMultistatus(child);
                                this.responseHashtable.put(((Response)response).getHref(), response);
                                this.responseURLs.add(((Response)response).getHref());
                            }
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
            } else if (this.responseDocument != null) {
                SingleResponse response = new SingleResponse(this.responseDocument, this.getPath(), status);
                this.responseHashtable.put(((Response)response).getHref(), response);
                this.responseURLs.add(((Response)response).getHref());
            }
        }
    }

    protected static Property convertElementToProperty(Response response, Element element) {
        BaseProperty property = null;
        String namespace = DOMUtils.getElementNamespaceURI(element);
        if (namespace != null && namespace.equals("DAV:")) {
            String localName = DOMUtils.getElementLocalName(element);
            if ("resourcetype".equals(localName)) {
                property = new ResourceTypeProperty(response, element);
            } else if ("getlastmodified".equals(localName)) {
                property = new GetLastModifiedProperty(response, element);
            } else if ("current-user-privilege-set".equals(localName)) {
                property = new CurrentUserPrivilegeSetProperty(response, element);
            } else if ("lockdiscovery".equals(localName)) {
                property = new LockDiscoveryProperty(response, element);
            } else if ("supportedlock".equals(localName)) {
                property = new SupportedLockProperty(response, element);
            } else if ("acl".equals(localName)) {
                property = new AclProperty(response, element);
            } else if ("principal-collection-set".equals(localName)) {
                property = new PrincipalCollectionSetProperty(response, element);
            } else if ("owner".equals(localName)) {
                property = new OwnerProperty(response, element);
            }
        }
        if (property == null) {
            property = new BaseProperty(response, element);
        }
        return property;
    }

    protected void setDocument(Document doc) {
        this.responseDocument = doc;
    }

    protected void setResponseHashtable(Hashtable h) {
        this.responseHashtable = h;
    }

    private static class DummyErrorHandler
    implements ErrorHandler {
        private DummyErrorHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
        }

        public void error(SAXParseException exception) throws SAXException {
        }

        public void fatalError(SAXParseException exception) throws SAXException {
        }
    }

    class OptionsResponse
    extends SingleResponse {
        OptionsResponse(Document document, String href, int statusCode) {
            super(document, href, statusCode);
        }

        public Enumeration getWorkspaces() {
            Node root = XMLResponseMethodBase.this.responseDocument.cloneNode(true).getFirstChild();
            String sPrefix = root.getPrefix();
            Vector<String> result = new Vector<String>();
            Node child = root.getFirstChild();
            while (child != null && !child.getNodeName().equalsIgnoreCase(sPrefix + ":workspace-collection-set")) {
                child = child.getNextSibling();
            }
            if (child != null && child.getNodeName().equalsIgnoreCase(sPrefix + ":workspace-collection-set")) {
                child = child.getFirstChild();
                while (child != null) {
                    result.add(child.getFirstChild().getNodeValue());
                    child = child.getNextSibling();
                }
            }
            return result.elements();
        }

        public Enumeration getHistories() {
            Node root = XMLResponseMethodBase.this.responseDocument.cloneNode(true).getFirstChild();
            String sPrefix = root.getPrefix();
            Vector<String> result = new Vector<String>();
            Node child = root.getFirstChild();
            while (child != null && !child.getNodeName().equalsIgnoreCase(sPrefix + ":version-history-collection-set")) {
                child = child.getNextSibling();
            }
            if (child != null && child.getNodeName().equalsIgnoreCase(sPrefix + ":version-history-collection-set")) {
                child = child.getFirstChild();
                while (child != null) {
                    result.add(child.getFirstChild().getNodeValue());
                    child = child.getNextSibling();
                }
            }
            return result.elements();
        }
    }

    class SingleResponse
    extends Response {
        private int statusCode = -1;
        private String href = null;

        SingleResponse(Document document, String href, int statusCode) {
            super(document);
            this.statusCode = statusCode;
            this.href = href;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHref() {
            return this.href;
        }
    }

    class ResponseWithinMultistatus
    extends Response {
        public ResponseWithinMultistatus(Element element) {
            super(element);
        }

        public int getStatusCode() {
            Element status;
            Element propstat = this.getFirstElement("DAV:", "propstat");
            if (propstat != null && (status = DOMUtils.getFirstElement(propstat, "DAV:", "status")) != null) {
                return DOMUtils.parseStatus(DOMUtils.getTextValue(status));
            }
            status = this.getFirstElement("DAV:", "status");
            if (status != null) {
                return DOMUtils.parseStatus(DOMUtils.getTextValue(status));
            }
            return -1;
        }

        public String getHref() {
            Element href = this.getFirstElement("DAV:", "href");
            if (href != null) {
                return DOMUtils.getTextValue(href);
            }
            return "";
        }

        protected Element getFirstElement(String namespace, String name) {
            return DOMUtils.getFirstElement(this.node, namespace, name);
        }
    }

    public abstract class Response
    implements ResponseEntity {
        protected Node node = null;
        public static final String TAG_NAME = "response";

        Response(Node node) {
            this.node = node;
        }

        public abstract int getStatusCode();

        public abstract String getHref();

        public Enumeration getHistories() {
            Vector result = new Vector();
            return result.elements();
        }

        public Enumeration getWorkspaces() {
            Vector result = new Vector();
            return result.elements();
        }

        public Enumeration getProperties() {
            NodeList list = DOMUtils.getElementsByTagNameNS(this.node, "prop", "DAV:");
            Vector<Property> vector = new Vector<Property>();
            int i = 0;
            while (list != null && i < list.getLength()) {
                Element element = (Element)list.item(i);
                NodeList children = element.getChildNodes();
                int j = 0;
                while (children != null && j < children.getLength()) {
                    try {
                        Element child = (Element)children.item(j);
                        vector.addElement(XMLResponseMethodBase.convertElementToProperty(this, child));
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                    ++j;
                }
                ++i;
            }
            return vector.elements();
        }

        public String toString() {
            StringWriter tmp = new StringWriter();
            DOMWriter domWriter = new DOMWriter(tmp, true);
            domWriter.print(this.node);
            return tmp.getBuffer().toString();
        }
    }
}

