/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Selectable;
import org.apache.batik.gvt.Selector;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.event.GraphicsNodeChangeEvent;
import org.apache.batik.gvt.event.GraphicsNodeEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.SelectionEvent;
import org.apache.batik.gvt.event.SelectionListener;
import org.apache.batik.gvt.text.Mark;

public class ConcreteTextSelector
implements Selector {
    private ArrayList listeners = null;
    private GraphicsNode selectionNode = null;
    private GraphicsNode currentNode = null;
    private int firstHit;
    private int lastHit;

    public void mouseClicked(GraphicsNodeMouseEvent evt) {
        this.checkSelectGesture(evt);
    }

    public void mouseDragged(GraphicsNodeMouseEvent evt) {
        this.checkSelectGesture(evt);
    }

    public void mouseEntered(GraphicsNodeMouseEvent evt) {
        this.currentNode = evt.getGraphicsNode();
        this.checkSelectGesture(evt);
    }

    public void mouseExited(GraphicsNodeMouseEvent evt) {
        this.checkSelectGesture(evt);
        this.currentNode = null;
    }

    public void mouseMoved(GraphicsNodeMouseEvent evt) {
    }

    public void mousePressed(GraphicsNodeMouseEvent evt) {
        this.checkSelectGesture(evt);
    }

    public void mouseReleased(GraphicsNodeMouseEvent evt) {
        this.checkSelectGesture(evt);
    }

    public void keyPressed(GraphicsNodeKeyEvent evt) {
        this.report(evt, "keyPressed");
    }

    public void keyReleased(GraphicsNodeKeyEvent evt) {
        this.report(evt, "keyReleased");
    }

    public void keyTyped(GraphicsNodeKeyEvent evt) {
        this.report(evt, "keyTyped");
    }

    public void changeStarted(GraphicsNodeChangeEvent gnce) {
    }

    public void changeCompleted(GraphicsNodeChangeEvent gnce) {
        if (this.selectionNode == null) {
            return;
        }
        Shape newShape = ((Selectable)((Object)this.selectionNode)).getHighlightShape();
        this.dispatchSelectionEvent(new SelectionEvent(this.getSelection(), 1, newShape));
    }

    public void setSelection(Mark begin, Mark end) {
        TextNode node = begin.getTextNode();
        if (node != end.getTextNode()) {
            throw new Error("Markers not from same TextNode");
        }
        node.setSelection(begin, end);
        Object selection = this.getSelection();
        Shape shape = node.getHighlightShape();
        this.dispatchSelectionEvent(new SelectionEvent(selection, 2, shape));
        this.copyToClipboard(selection);
    }

    public void clearSelection() {
        this.dispatchSelectionEvent(new SelectionEvent(null, 3, null));
        this.copyToClipboard(null);
    }

    protected void checkSelectGesture(GraphicsNodeEvent evt) {
        GraphicsNode source;
        GraphicsNodeMouseEvent mevt = null;
        if (evt instanceof GraphicsNodeMouseEvent) {
            mevt = (GraphicsNodeMouseEvent)evt;
        }
        if ((source = evt.getGraphicsNode()) instanceof Selectable && mevt != null) {
            Point2D p = new Point2D.Double(mevt.getX(), mevt.getY());
            AffineTransform t = source.getGlobalTransform();
            if (t == null) {
                t = new AffineTransform();
            } else {
                try {
                    t = t.createInverse();
                }
                catch (NoninvertibleTransformException ni) {
                    // empty catch block
                }
            }
            p = t.transform(p, null);
            if (this.isDeselectGesture(evt)) {
                if (this.selectionNode != null) {
                    this.selectionNode.getRoot().removeTreeGraphicsNodeChangeListener(this);
                }
                this.dispatchSelectionEvent(new SelectionEvent(null, 3, null));
                this.copyToClipboard(null);
                this.selectionNode = null;
            } else if (this.isSelectStartGesture(evt)) {
                if (this.selectionNode != source) {
                    if (this.selectionNode != null) {
                        this.selectionNode.getRoot().removeTreeGraphicsNodeChangeListener(this);
                    }
                    if (source != null) {
                        source.getRoot().addTreeGraphicsNodeChangeListener(this);
                    }
                }
                this.selectionNode = source;
                ((Selectable)((Object)source)).selectAt(p.getX(), p.getY());
                this.dispatchSelectionEvent(new SelectionEvent(null, 4, null));
            } else if (this.isSelectEndGesture(evt)) {
                if (this.selectionNode != source) {
                    if (this.selectionNode != null) {
                        this.selectionNode.getRoot().removeTreeGraphicsNodeChangeListener(this);
                    }
                    if (source != null) {
                        source.getRoot().addTreeGraphicsNodeChangeListener(this);
                    }
                }
                this.selectionNode = source;
                ((Selectable)((Object)source)).selectTo(p.getX(), p.getY());
                Object oldSelection = this.getSelection();
                Shape newShape = ((Selectable)((Object)source)).getHighlightShape();
                this.dispatchSelectionEvent(new SelectionEvent(oldSelection, 2, newShape));
                this.copyToClipboard(oldSelection);
            } else if (this.isSelectContinueGesture(evt)) {
                boolean result;
                if (this.selectionNode == source && (result = ((Selectable)((Object)source)).selectTo(p.getX(), p.getY()))) {
                    Shape newShape = ((Selectable)((Object)source)).getHighlightShape();
                    this.dispatchSelectionEvent(new SelectionEvent(null, 1, newShape));
                }
            } else if (this.isSelectAllGesture(evt)) {
                if (this.selectionNode != source) {
                    if (this.selectionNode != null) {
                        this.selectionNode.getRoot().removeTreeGraphicsNodeChangeListener(this);
                    }
                    if (source != null) {
                        source.getRoot().addTreeGraphicsNodeChangeListener(this);
                    }
                }
                this.selectionNode = source;
                ((Selectable)((Object)source)).selectAll(p.getX(), p.getY());
                Object oldSelection = this.getSelection();
                Shape newShape = ((Selectable)((Object)source)).getHighlightShape();
                this.dispatchSelectionEvent(new SelectionEvent(oldSelection, 2, newShape));
                this.copyToClipboard(oldSelection);
            }
        }
    }

    private boolean isDeselectGesture(GraphicsNodeEvent evt) {
        return evt.getID() == 500 && ((GraphicsNodeMouseEvent)evt).getClickCount() == 1;
    }

    private boolean isSelectStartGesture(GraphicsNodeEvent evt) {
        return evt.getID() == 501;
    }

    private boolean isSelectEndGesture(GraphicsNodeEvent evt) {
        return evt.getID() == 502;
    }

    private boolean isSelectContinueGesture(GraphicsNodeEvent evt) {
        return evt.getID() == 506;
    }

    private boolean isSelectAllGesture(GraphicsNodeEvent evt) {
        return evt.getID() == 500 && ((GraphicsNodeMouseEvent)evt).getClickCount() == 2;
    }

    public Object getSelection() {
        Object value = null;
        if (this.selectionNode instanceof Selectable) {
            value = ((Selectable)((Object)this.selectionNode)).getSelection();
        }
        return value;
    }

    public boolean isEmpty() {
        return this.getSelection() == null;
    }

    public void dispatchSelectionEvent(SelectionEvent e) {
        if (this.listeners != null) {
            Iterator iter = this.listeners.iterator();
            switch (e.getID()) {
                case 2: {
                    while (iter.hasNext()) {
                        ((SelectionListener)iter.next()).selectionDone(e);
                    }
                    break;
                }
                case 1: {
                    while (iter.hasNext()) {
                        ((SelectionListener)iter.next()).selectionChanged(e);
                    }
                    break;
                }
                case 3: {
                    while (iter.hasNext()) {
                        ((SelectionListener)iter.next()).selectionCleared(e);
                    }
                    break;
                }
                case 4: {
                    while (iter.hasNext()) {
                        ((SelectionListener)iter.next()).selectionStarted(e);
                    }
                    break;
                }
            }
        }
    }

    public void addSelectionListener(SelectionListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    private void copyToClipboard(final Object o) {
        new Thread(){

            public void run() {
                SecurityManager securityManager = System.getSecurityManager();
                boolean canAccessClipboard = true;
                if (securityManager != null) {
                    try {
                        securityManager.checkSystemClipboardAccess();
                    }
                    catch (SecurityException e) {
                        canAccessClipboard = false;
                    }
                }
                if (canAccessClipboard) {
                    String label = "";
                    if (o instanceof CharacterIterator) {
                        CharacterIterator iter = (CharacterIterator)o;
                        char[] cbuff = new char[iter.getEndIndex() - iter.getBeginIndex()];
                        if (cbuff.length > 0) {
                            cbuff[0] = iter.first();
                        }
                        int i = 1;
                        while (i < cbuff.length) {
                            cbuff[i] = iter.next();
                            ++i;
                        }
                        label = new String(cbuff);
                    }
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection selection = new StringSelection(label);
                    clipboard.setContents(selection, selection);
                }
            }
        }.start();
    }

    private void report(GraphicsNodeEvent evt, String message) {
        GraphicsNode source = evt.getGraphicsNode();
        String label = "(non-text node)";
        if (source instanceof TextNode) {
            AttributedCharacterIterator iter = ((TextNode)source).getAttributedCharacterIterator();
            char[] cbuff = new char[iter.getEndIndex()];
            if (cbuff.length > 0) {
                cbuff[0] = iter.first();
            }
            int i = 1;
            while (i < cbuff.length) {
                cbuff[i] = iter.next();
                ++i;
            }
            label = new String(cbuff);
        }
        System.out.println("Mouse " + message + " in " + label);
    }
}

