/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.ext.awt.geom.RectListManager;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.gvt.renderer.StaticRenderer;

public class DynamicRenderer
extends StaticRenderer {
    static final int COPY_OVERHEAD = 1000;
    static final int COPY_LINE_OVERHEAD = 10;
    RectListManager damagedAreas;

    public DynamicRenderer() {
    }

    public DynamicRenderer(RenderingHints rh, AffineTransform at) {
        super(rh, at);
    }

    protected CachableRed setupCache(CachableRed img) {
        return img;
    }

    public void flush(Rectangle r) {
    }

    public void flush(List areas) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(List areas) {
        if (areas == null) {
            return;
        }
        this.updateWorkingBuffers();
        if (this.rootCR == null || this.workingBaseRaster == null) {
            return;
        }
        CachableRed cr = this.rootCR;
        WritableRaster syncRaster = this.workingBaseRaster;
        WritableRaster copyRaster = this.workingRaster;
        Rectangle srcR = this.rootCR.getBounds();
        Rectangle dstR = this.workingRaster.getBounds();
        if (dstR.x < srcR.x || dstR.y < srcR.y || dstR.x + dstR.width > srcR.x + srcR.width || dstR.y + dstR.height > srcR.y + srcR.height) {
            cr = new PadRed(cr, dstR, PadMode.ZERO_PAD, null);
        }
        Rectangle[] devRects = new Rectangle[areas.size()];
        Iterator iter = areas.iterator();
        Rectangle dr = copyRaster.getBounds();
        float dmgSz = 0.0f;
        int sz = 0;
        while (iter.hasNext()) {
            int y1;
            int x1;
            int y0;
            Shape s = (Shape)iter.next();
            Rectangle2D r2d = (s = this.usr2dev.createTransformedShape(s)).getBounds2D();
            int x0 = (int)Math.floor(r2d.getX());
            Rectangle r = new Rectangle(x0 - 1, (y0 = (int)Math.floor(r2d.getY())) - 1, (x1 = (int)Math.ceil(r2d.getX() + r2d.getWidth())) - x0 + 3, (y1 = (int)Math.ceil(r2d.getY() + r2d.getHeight())) - y0 + 3);
            if (!dr.intersects(r)) continue;
            r = dr.intersection(r);
            devRects[sz++] = r;
            dmgSz += (float)r.width * (float)r.height;
        }
        RectListManager devRLM = null;
        try {
            devRLM = new RectListManager(devRects, 0, sz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        devRLM.mergeRects(1000, 10);
        boolean repaintAll = dmgSz > (float)(this.offScreenWidth * this.offScreenHeight) * 0.9f;
        WritableRaster writableRaster = syncRaster;
        synchronized (writableRaster) {
            if (repaintAll) {
                cr.copyData(copyRaster);
            } else {
                Graphics2D g2d = null;
                if (this.isDoubleBuffered && this.currentRaster != null && this.damagedAreas != null) {
                    this.damagedAreas.subtract(devRLM, 1000, 10);
                    this.damagedAreas.mergeRects(1000, 10);
                    iter = this.damagedAreas.iterator();
                    Rectangle sr = this.currentRaster.getBounds();
                    while (iter.hasNext()) {
                        Rectangle r = (Rectangle)iter.next();
                        WritableRaster src = this.currentRaster.createWritableChild(r.x, r.y, r.width, r.height, r.x, r.y, null);
                        GraphicsUtil.copyData(src, copyRaster);
                        if (g2d == null) continue;
                        g2d.setPaint(new Color(0, 0, 255, 50));
                        g2d.fill(r);
                        g2d.setPaint(new Color(0, 0, 0, 50));
                        g2d.draw(r);
                    }
                }
                iter = devRLM.iterator();
                while (iter.hasNext()) {
                    Rectangle r = (Rectangle)iter.next();
                    WritableRaster dst = copyRaster.createWritableChild(r.x, r.y, r.width, r.height, r.x, r.y, null);
                    cr.copyData(dst);
                    if (g2d == null) continue;
                    g2d.setPaint(new Color(255, 0, 0, 50));
                    g2d.fill(r);
                    g2d.setPaint(new Color(0, 0, 0, 50));
                    g2d.draw(r);
                }
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        BufferedImage tmpBI = this.workingOffScreen;
        this.workingBaseRaster = this.currentBaseRaster;
        this.workingRaster = this.currentRaster;
        this.workingOffScreen = this.currentOffScreen;
        this.currentRaster = copyRaster;
        this.currentBaseRaster = syncRaster;
        this.currentOffScreen = tmpBI;
        this.damagedAreas = devRLM;
    }

    static {
        COPY_OVERHEAD = 1000;
        COPY_LINE_OVERHEAD = 10;
    }
}

