/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericAttr;
import org.apache.batik.dom.GenericAttrNS;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericComment;
import org.apache.batik.dom.GenericDocumentFragment;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericEntityReference;
import org.apache.batik.dom.GenericProcessingInstruction;
import org.apache.batik.dom.GenericText;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGStyleSheetProcessingInstruction;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLangSpace;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class SVGOMDocument
extends AbstractDocument
implements SVGDocument,
DocumentCSS,
DocumentView,
SVGConstants {
    protected static final String RESOURCES = "org.apache.batik.dom.svg.resources.Messages";
    protected transient LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.svg.resources.Messages");
    protected String referrer = "";
    protected URL url;
    protected transient boolean readonly;
    protected transient AbstractView defaultView;
    protected transient CSSEngine cssEngine;

    protected SVGOMDocument() {
    }

    public SVGOMDocument(DocumentType dt, DOMImplementation impl) {
        super(impl);
        if (dt != null) {
            this.appendChild(dt);
        }
    }

    public void setCSSEngine(CSSEngine ctx) {
        this.cssEngine = ctx;
    }

    public CSSEngine getCSSEngine() {
        return this.cssEngine;
    }

    public void setLocale(Locale l) {
        super.setLocale(l);
        this.localizableSupport.setLocale(l);
    }

    public String formatMessage(String key, Object[] args) throws MissingResourceException {
        try {
            return super.formatMessage(key, args);
        }
        catch (MissingResourceException e) {
            return this.localizableSupport.formatMessage(key, args);
        }
    }

    public String getTitle() {
        StringBuffer sb = new StringBuffer();
        boolean preserve = false;
        Node n = this.getDocumentElement().getFirstChild();
        while (n != null) {
            String ns = n.getNamespaceURI();
            if (ns != null && ns.equals("http://www.w3.org/2000/svg") && n.getLocalName().equals("title")) {
                preserve = ((SVGLangSpace)((Object)n)).getXMLspace().equals("preserve");
                n = n.getFirstChild();
                while (n != null) {
                    if (n.getNodeType() == 3) {
                        sb.append(n.getNodeValue());
                    }
                    n = n.getNextSibling();
                }
                break;
            }
            n = n.getNextSibling();
        }
        String s = sb.toString();
        return preserve ? XMLSupport.preserveXMLSpace(s) : XMLSupport.defaultXMLSpace(s);
    }

    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String s) {
        this.referrer = s;
    }

    public String getDomain() {
        return this.url == null ? null : this.url.getHost();
    }

    public SVGSVGElement getRootElement() {
        return (SVGSVGElement)this.getDocumentElement();
    }

    public String getURL() {
        return this.url == null ? null : this.url.toString();
    }

    public URL getURLObject() {
        return this.url;
    }

    public void setURLObject(URL url) {
        this.url = url;
    }

    public Element createElement(String tagName) throws DOMException {
        return new GenericElement(tagName.intern(), this);
    }

    public DocumentFragment createDocumentFragment() {
        return new GenericDocumentFragment(this);
    }

    public Text createTextNode(String data) {
        return new GenericText(data, this);
    }

    public Comment createComment(String data) {
        return new GenericComment(data, this);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return new GenericCDATASection(data, this);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if ("xml-stylesheet".equals(target)) {
            return new SVGStyleSheetProcessingInstruction(data, this, (StyleSheetFactory)((Object)this.getImplementation()));
        }
        return new GenericProcessingInstruction(target, data, this);
    }

    public Attr createAttribute(String name) throws DOMException {
        return new GenericAttr(name.intern(), this);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return new GenericEntityReference(name, this);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (namespaceURI == null) {
            return new GenericAttr(qualifiedName.intern(), this);
        }
        return new GenericAttrNS(namespaceURI.intern(), qualifiedName.intern(), this);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        SVGDOMImplementation impl = (SVGDOMImplementation)this.implementation;
        return impl.createElementNS(this, namespaceURI, qualifiedName);
    }

    public Element getElementById(String elementId) {
        if (elementId == null || elementId.equals("")) {
            return null;
        }
        Element e = this.getDocumentElement();
        if (e == null) {
            return null;
        }
        return SVGOMDocument.getById(elementId, e);
    }

    protected static Element getById(String id, Node node) {
        Element elt;
        if (node.getNodeType() == 1 && (elt = (Element)node).getAttributeNS(null, "id").equals(id)) {
            return elt;
        }
        Node n = node.getFirstChild();
        while (n != null) {
            Element result = SVGOMDocument.getById(id, n);
            if (result != null) {
                return result;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean v) {
        this.readonly = v;
    }

    public StyleSheetList getStyleSheets() {
        throw new RuntimeException(" !!! Not implemented");
    }

    public AbstractView getDefaultView() {
        if (this.defaultView == null) {
            SVGDOMImplementation impl = (SVGDOMImplementation)this.implementation;
            this.defaultView = impl.createViewCSS(this);
        }
        return this.defaultView;
    }

    public void clearViewCSS() {
        this.defaultView = null;
        if (this.cssEngine != null) {
            this.cssEngine.dispose();
        }
        this.cssEngine = null;
    }

    public CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        throw new RuntimeException(" !!! Not implemented");
    }

    protected Node newNode() {
        return new SVGOMDocument();
    }

    protected Node copyInto(Node n) {
        super.copyInto(n);
        SVGOMDocument sd = (SVGOMDocument)n;
        sd.localizableSupport = new LocalizableSupport(RESOURCES);
        sd.referrer = this.referrer;
        sd.url = this.url;
        return n;
    }

    protected Node deepCopyInto(Node n) {
        super.deepCopyInto(n);
        SVGOMDocument sd = (SVGOMDocument)n;
        sd.localizableSupport = new LocalizableSupport(RESOURCES);
        sd.referrer = this.referrer;
        sd.url = this.url;
        return n;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES);
    }

    static {
        RESOURCES = RESOURCES;
    }
}

