/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Composite;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGAltGlyphHandler;
import org.apache.batik.bridge.SVGFontUtilities;
import org.apache.batik.bridge.SVGTextPathElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SVGTextElementBridge
extends AbstractGraphicsNodeBridge {
    protected static final Integer ZERO = new Integer(0);
    protected AttributedString layoutedText;
    protected DOMChildNodeRemovedEventListener childNodeRemovedEventListener = new DOMChildNodeRemovedEventListener();
    protected DOMSubtreeModifiedEventListener subtreeModifiedEventListener = new DOMSubtreeModifiedEventListener();
    private boolean hasNewACI;
    private Element cssProceedElement;

    public String getLocalName() {
        return "text";
    }

    public Bridge getInstance() {
        return new SVGTextElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        TextNode node = (TextNode)super.createGraphicsNode(ctx, e);
        if (node == null) {
            return null;
        }
        if (ctx.getTextPainter() != null) {
            node.setTextPainter(ctx.getTextPainter());
        }
        RenderingHints hints = CSSUtilities.convertTextRendering(e, null);
        if ((hints = CSSUtilities.convertColorRendering(e, hints)) != null) {
            node.setRenderingHints(hints);
        }
        node.setLocation(this.getLocation(ctx, e));
        return node;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new TextNode();
    }

    protected Point2D getLocation(BridgeContext ctx, Element e) {
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, e);
        String s = e.getAttributeNS(null, "x");
        float x = 0.0f;
        if (s.length() != 0) {
            StringTokenizer st = new StringTokenizer(s, ", ", false);
            x = UnitProcessor.svgHorizontalCoordinateToUserSpace(st.nextToken(), "x", uctx);
        }
        s = e.getAttributeNS(null, "y");
        float y = 0.0f;
        if (s.length() != 0) {
            StringTokenizer st = new StringTokenizer(s, ", ", false);
            y = UnitProcessor.svgVerticalCoordinateToUserSpace(st.nextToken(), "y", uctx);
        }
        return new Point2D.Float(x, y);
    }

    public void buildGraphicsNode(BridgeContext ctx, Element e, GraphicsNode node) {
        e.normalize();
        AttributedString as = this.buildAttributedString(ctx, e);
        this.addGlyphPositionAttributes(as, e, ctx);
        if (ctx.isDynamic()) {
            this.layoutedText = new AttributedString(as.getIterator());
        }
        TextNode tn = (TextNode)node;
        tn.setAttributedCharacterIterator(as.getIterator());
        TextDecoration textDecoration = this.getTextDecoration(e, tn, new TextDecoration(), ctx);
        this.addPaintAttributes(as, e, tn, textDecoration, ctx);
        tn.setAttributedCharacterIterator(as.getIterator());
        node.setFilter(CSSUtilities.convertFilter(e, node, ctx));
        node.setMask(CSSUtilities.convertMask(e, node, ctx));
        node.setClip(CSSUtilities.convertClipPath(e, node, ctx));
        node.setPointerEventType(CSSUtilities.convertPointerEvents(e));
        if (ctx.isDynamic()) {
            this.initializeDynamicSupport(ctx, e, node);
        }
        SVGUtilities.bridgeChildren(ctx, e);
    }

    public boolean isComposite() {
        return false;
    }

    protected void initializeDynamicSupport(BridgeContext ctx, Element e, GraphicsNode node) {
        super.initializeDynamicSupport(ctx, e, node);
        EventTarget evtTarget = (EventTarget)((Object)e);
        evtTarget.addEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        ctx.storeEventListener(evtTarget, "DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        evtTarget.addEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        ctx.storeEventListener(evtTarget, "DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        Node child = e.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                this.addContextToChild(ctx, (Element)child);
            }
            child = child.getNextSibling();
        }
    }

    protected void addContextToChild(BridgeContext ctx, Element e) {
        if (e.getNamespaceURI().equals("http://www.w3.org/2000/svg")) {
            if (e.getLocalName().equals("tspan")) {
                ((SVGOMElement)e).setSVGContext(new TspanBridge(ctx, this, e));
            } else if (e.getLocalName().equals("textPath")) {
                ((SVGOMElement)e).setSVGContext(new TextPathBridge(ctx, this, e));
            } else if (e.getLocalName().equals("tref")) {
                ((SVGOMElement)e).setSVGContext(new TRefBridge(ctx, this, e));
            }
        }
        Node child = e.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                this.addContextToChild(ctx, (Element)child);
            }
            child = child.getNextSibling();
        }
    }

    public void handleDOMNodeInsertedEvent(MutationEvent evt) {
        Node childNode = (Node)((Object)evt.getTarget());
        switch (childNode.getNodeType()) {
            case 3: 
            case 4: {
                this.layoutedText = null;
                break;
            }
            case 1: {
                String nodeName;
                if (!childNode.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !(nodeName = childNode.getLocalName()).equals("tspan") && !nodeName.equals("altGlyph") && !nodeName.equals("a") && !nodeName.equals("textPath") && !nodeName.equals("tref")) break;
                this.layoutedText = null;
                break;
            }
        }
        if (this.layoutedText == null) {
            this.computeLayoutedText();
        }
    }

    public void handleDOMNodeRemovedEvent(MutationEvent evt) {
        EventTarget evtTarget = evt.getTarget();
        evtTarget.removeEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        evtTarget.removeEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        super.handleDOMNodeRemovedEvent(evt);
    }

    public void handleDOMChildNodeRemovedEvent(MutationEvent evt) {
        Node childNode = (Node)((Object)evt.getTarget());
        switch (childNode.getNodeType()) {
            case 3: 
            case 4: {
                if (!this.isParentDisplayed(childNode)) break;
                this.layoutedText = null;
                break;
            }
            case 1: {
                String nodeName;
                if (!childNode.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !(nodeName = childNode.getLocalName()).equals("tspan") && !nodeName.equals("altGlyph") && !nodeName.equals("a") && !nodeName.equals("textPath") && !nodeName.equals("tref")) break;
                this.layoutedText = null;
                break;
            }
        }
    }

    public void handleDOMSubtreeModifiedEvent(MutationEvent evt) {
        if (this.layoutedText == null) {
            this.computeLayoutedText();
        }
    }

    public void handleDOMCharacterDataModified(MutationEvent evt) {
        Node childNode = (Node)((Object)evt.getTarget());
        if (this.isParentDisplayed(childNode)) {
            this.layoutedText = null;
        }
    }

    protected boolean isParentDisplayed(Node childNode) {
        String nodeName;
        Node parentNode = childNode.getParentNode();
        return parentNode.getNodeType() == 1 && parentNode.getNamespaceURI().equals("http://www.w3.org/2000/svg") && ((nodeName = parentNode.getLocalName()).equals("text") || nodeName.equals("tspan") || nodeName.equals("altGlyph") || nodeName.equals("a") || nodeName.equals("textPath") || nodeName.equals("tref"));
    }

    protected void computeLayoutedText() {
        AttributedString as = this.buildAttributedString(this.ctx, this.e);
        this.addGlyphPositionAttributes(as, this.e, this.ctx);
        this.layoutedText = new AttributedString(as.getIterator());
        TextNode tn = (TextNode)this.node;
        tn.setAttributedCharacterIterator(as.getIterator());
        TextDecoration textDecoration = this.getTextDecoration(this.e, tn, new TextDecoration(), this.ctx);
        this.addPaintAttributes(as, this.e, tn, textDecoration, this.ctx);
        tn.setAttributedCharacterIterator(as.getIterator());
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("x") || attrName.equals("y") || attrName.equals("dx") || attrName.equals("dy") || attrName.equals("rotate")) {
            if (attrName.equals("x") || attrName.equals("y")) {
                ((TextNode)this.node).setLocation(this.getLocation(this.ctx, this.e));
            }
            this.computeLayoutedText();
        } else {
            super.handleDOMAttrModifiedEvent(evt);
        }
    }

    public void handleCSSEngineEvent(CSSEngineEvent evt) {
        this.hasNewACI = false;
        int[] properties = evt.getProperties();
        int i = 0;
        while (i < properties.length) {
            switch (properties[i]) {
                case 1: 
                case 11: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 27: 
                case 29: 
                case 31: 
                case 32: 
                case 52: 
                case 55: 
                case 57: 
                case 58: {
                    if (this.hasNewACI) break;
                    this.hasNewACI = true;
                    AttributedString as = this.buildAttributedString(this.ctx, this.e);
                    this.addGlyphPositionAttributes(as, this.e, this.ctx);
                    this.layoutedText = new AttributedString(as.getIterator());
                    TextNode tn = (TextNode)this.node;
                    tn.setAttributedCharacterIterator(as.getIterator());
                    TextDecoration textDecoration = this.getTextDecoration(this.e, tn, new TextDecoration(), this.ctx);
                    this.addPaintAttributes(as, this.e, tn, textDecoration, this.ctx);
                    tn.setAttributedCharacterIterator(as.getIterator());
                }
            }
            ++i;
        }
        this.cssProceedElement = evt.getElement();
        super.handleCSSEngineEvent(evt);
        this.cssProceedElement = null;
    }

    protected void handleCSSPropertyChanged(int property) {
        switch (property) {
            case 15: 
            case 16: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: {
                AttributedString as;
                TextDecoration parentDecoration;
                if (this.hasNewACI) break;
                this.hasNewACI = true;
                TextNode tn = (TextNode)this.node;
                if (this.cssProceedElement == this.e) {
                    parentDecoration = new TextDecoration();
                    as = new AttributedString(this.layoutedText.getIterator());
                } else {
                    parentDecoration = this.getParentTextDecoration(tn.getAttributedCharacterIterator(), this.cssProceedElement);
                    as = new AttributedString(tn.getAttributedCharacterIterator());
                }
                tn.setAttributedCharacterIterator(as.getIterator());
                TextDecoration textDecoration = this.getTextDecoration(this.cssProceedElement, tn, parentDecoration, this.ctx);
                this.addPaintAttributes(as, this.cssProceedElement, tn, textDecoration, this.ctx);
                tn.setAttributedCharacterIterator(as.getIterator());
                break;
            }
            case 54: {
                RenderingHints hints = this.node.getRenderingHints();
                hints = CSSUtilities.convertTextRendering(this.e, hints);
                if (hints == null) break;
                this.node.setRenderingHints(hints);
                break;
            }
            case 9: {
                RenderingHints hints = this.node.getRenderingHints();
                hints = CSSUtilities.convertColorRendering(this.e, hints);
                if (hints == null) break;
                this.node.setRenderingHints(hints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(property);
            }
        }
    }

    protected AttributedString buildAttributedString(BridgeContext ctx, Element element) {
        AttributedStringBuffer asb = new AttributedStringBuffer();
        this.fillAttributedStringBuffer(ctx, element, true, null, asb);
        return asb.toAttributedString();
    }

    protected void fillAttributedStringBuffer(BridgeContext ctx, Element element, boolean top, TextPath textPath, AttributedStringBuffer asb) {
        if (!SVGUtilities.matchUserAgent(element, ctx.getUserAgent())) {
            return;
        }
        String s = XMLSupport.getXMLSpace(element);
        boolean preserve = s.equals("preserve");
        boolean first = true;
        boolean stripFirst = !preserve;
        boolean stripLast = !preserve;
        Element nodeElement = element;
        Map map = null;
        Node n = element.getFirstChild();
        while (n != null) {
            boolean last = n.getNextSibling() == null;
            int lastChar = asb.getLastChar();
            stripFirst = !preserve && first && (top || lastChar == 32 || lastChar == -1);
            switch (n.getNodeType()) {
                case 1: {
                    if (n.getNamespaceURI() != "http://www.w3.org/2000/svg") break;
                    nodeElement = (Element)n;
                    String ln = n.getLocalName();
                    if (ln.equals("tspan") || ln.equals("altGlyph")) {
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, textPath, asb);
                        break;
                    }
                    if (ln.equals("textPath")) {
                        SVGTextPathElementBridge textPathBridge = (SVGTextPathElementBridge)ctx.getBridge(nodeElement);
                        TextPath newTextPath = textPathBridge.createTextPath(ctx, nodeElement);
                        if (newTextPath == null) break;
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, newTextPath, asb);
                        break;
                    }
                    if (ln.equals("tref")) {
                        String uriStr = XLinkSupport.getXLinkHref((Element)n);
                        Element ref = ctx.getReferencedElement((Element)n, uriStr);
                        s = TextUtilities.getElementContent(ref);
                        if ((s = this.normalizeString(s, preserve, stripFirst, last && top)) == null) break;
                        boolean bl = stripLast = !preserve && s.charAt(0) == ' ';
                        if (stripLast && !asb.isEmpty()) {
                            asb.stripLast();
                        }
                        Map m = this.getAttributeMap(ctx, nodeElement, textPath);
                        asb.append(s, m);
                        break;
                    }
                    if (!ln.equals("a")) break;
                    EventTarget target = (EventTarget)((Object)nodeElement);
                    UserAgent ua = ctx.getUserAgent();
                    EventListener l = new SVGAElementBridge.AnchorListener(ua);
                    target.addEventListener("click", l, false);
                    ctx.storeEventListener(target, "click", l, false);
                    l = new SVGAElementBridge.CursorMouseOverListener(ua);
                    target.addEventListener("mouseover", l, false);
                    ctx.storeEventListener(target, "mouseover", l, false);
                    l = new SVGAElementBridge.CursorMouseOutListener(ua);
                    target.addEventListener("mouseout", l, false);
                    ctx.storeEventListener(target, "mouseout", l, false);
                    this.fillAttributedStringBuffer(ctx, nodeElement, false, textPath, asb);
                    break;
                }
                case 3: 
                case 4: {
                    s = n.getNodeValue();
                    s = this.normalizeString(s, preserve, stripFirst, last && top);
                    if (s == null) break;
                    boolean bl = stripLast = !preserve && s.charAt(0) == ' ';
                    if (stripLast && !asb.isEmpty()) {
                        asb.stripLast();
                    }
                    if (map == null) {
                        map = this.getAttributeMap(ctx, element, textPath);
                    }
                    asb.append(s, map);
                }
            }
            first = false;
            n = n.getNextSibling();
        }
    }

    protected String normalizeString(String s, boolean preserve, boolean stripfirst, boolean striplast) {
        StringBuffer sb = new StringBuffer();
        if (preserve) {
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        sb.append(' ');
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++i;
            }
        } else {
            char c;
            boolean space = false;
            int idx = 0;
            if (stripfirst) {
                block11: while (idx < s.length()) {
                    switch (s.charAt(idx)) {
                        default: {
                            break block11;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            ++idx;
                        }
                    }
                }
            }
            int i = idx;
            while (i < s.length()) {
                c = s.charAt(i);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        if (space) break;
                        sb.append(' ');
                        space = true;
                        break;
                    }
                    default: {
                        sb.append(c);
                        space = false;
                    }
                }
                ++i;
            }
            if (striplast) {
                int len;
                while ((len = sb.length()) > 0) {
                    if (sb.charAt(c - '\u0001') == ' ') {
                        sb.deleteCharAt(c - '\u0001');
                        continue;
                    }
                    break;
                }
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        if (stripfirst && striplast) {
            return " ";
        }
        return null;
    }

    protected boolean nodeAncestorOf(Node node1, Node node2) {
        if (node2 == null || node1 == null) {
            return false;
        }
        Node parent = node2.getParentNode();
        while (parent != null && parent != node1) {
            parent = parent.getParentNode();
        }
        return parent == node1;
    }

    protected void addGlyphPositionAttributes(AttributedString as, Element element, BridgeContext ctx) {
        int i;
        int len;
        ArrayList al;
        if (!SVGUtilities.matchUserAgent(element, ctx.getUserAgent())) {
            return;
        }
        AttributedCharacterIterator aci = as.getIterator();
        int firstChar = -1;
        int i2 = 0;
        while (i2 < aci.getEndIndex()) {
            aci.setIndex(i2);
            Element delimeter = (Element)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (delimeter == element || this.nodeAncestorOf(element, delimeter)) {
                firstChar = i2;
                break;
            }
            ++i2;
        }
        if (firstChar == -1) {
            return;
        }
        int lastChar = aci.getEndIndex() - 1;
        int i3 = aci.getEndIndex() - 1;
        while (i3 >= 0) {
            aci.setIndex(i3);
            Element delimeter = (Element)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (delimeter == element || this.nodeAncestorOf(element, delimeter)) {
                lastChar = i3;
                break;
            }
            --i3;
        }
        String xAtt = element.getAttributeNS(null, "x");
        String yAtt = element.getAttributeNS(null, "y");
        String dxAtt = element.getAttributeNS(null, "dx");
        String dyAtt = element.getAttributeNS(null, "dy");
        String rotateAtt = element.getAttributeNS(null, "rotate");
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, element);
        if (xAtt.length() != 0) {
            al = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "x", xAtt, ctx);
            len = al.size();
            i = 0;
            while (i < len) {
                if (firstChar + i <= lastChar) {
                    as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, al.get(i), firstChar + i, firstChar + i + 1);
                }
                ++i;
            }
        }
        if (yAtt.length() != 0) {
            al = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "y", yAtt, ctx);
            len = al.size();
            i = 0;
            while (i < len) {
                if (firstChar + i <= lastChar) {
                    as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, al.get(i), firstChar + i, firstChar + i + 1);
                }
                ++i;
            }
        }
        if (dxAtt.length() != 0) {
            al = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "dx", dxAtt, ctx);
            len = al.size();
            i = 0;
            while (i < len) {
                if (firstChar + i <= lastChar) {
                    as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DX, al.get(i), firstChar + i, firstChar + i + 1);
                }
                ++i;
            }
        }
        if (dyAtt.length() != 0) {
            al = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "dy", dyAtt, ctx);
            len = al.size();
            i = 0;
            while (i < len) {
                if (firstChar + i <= lastChar) {
                    as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DY, al.get(i), firstChar + i, firstChar + i + 1);
                }
                ++i;
            }
        }
        if (rotateAtt.length() != 0) {
            al = TextUtilities.svgRotateArrayToFloats(element, "rotate", rotateAtt, ctx);
            len = al.size();
            if (len == 1) {
                as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, al.get(0), firstChar, lastChar + 1);
            } else {
                i = 0;
                while (i < len) {
                    if (firstChar + i <= lastChar) {
                        as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, al.get(i), firstChar + i, firstChar + i + 1);
                    }
                    ++i;
                }
            }
        }
        this.addChildGlyphPositionAttributes(as, element, ctx);
    }

    protected void addChildGlyphPositionAttributes(AttributedString as, Element element, BridgeContext ctx) {
        Node child = element.getFirstChild();
        while (child != null) {
            String ln;
            if (child.getNodeType() == 1 && "http://www.w3.org/2000/svg".equals(child.getNamespaceURI()) && ((ln = child.getLocalName()).equals("tspan") || ln.equals("altGlyph") || ln.equals("a") || ln.equals("textPath") || ln.equals("tref"))) {
                this.addGlyphPositionAttributes(as, (Element)child, ctx);
            }
            child = child.getNextSibling();
        }
    }

    protected void addPaintAttributes(AttributedString as, Element element, TextNode node, TextDecoration textDecoration, BridgeContext ctx) {
        if (!SVGUtilities.matchUserAgent(element, ctx.getUserAgent())) {
            return;
        }
        AttributedCharacterIterator aci = as.getIterator();
        int firstChar = -1;
        int i = 0;
        while (i < aci.getEndIndex()) {
            aci.setIndex(i);
            Element delimeter = (Element)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (delimeter == element || this.nodeAncestorOf(element, delimeter)) {
                firstChar = i;
                break;
            }
            ++i;
        }
        if (firstChar == -1) {
            return;
        }
        int lastChar = aci.getEndIndex() - 1;
        int i2 = aci.getEndIndex() - 1;
        while (i2 >= 0) {
            aci.setIndex(i2);
            Element delimeter = (Element)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (delimeter == element || this.nodeAncestorOf(element, delimeter)) {
                lastChar = i2;
                break;
            }
            --i2;
        }
        Composite composite = CSSUtilities.convertOpacity(element);
        as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY, composite, firstChar, lastChar + 1);
        Paint p = PaintServer.convertFillPaint(element, node, ctx);
        as.addAttribute(TextAttribute.FOREGROUND, p, firstChar, lastChar + 1);
        Paint sp = PaintServer.convertStrokePaint(element, node, ctx);
        as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT, sp, firstChar, lastChar + 1);
        Stroke stroke = PaintServer.convertStroke(element);
        as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE, stroke, firstChar, lastChar + 1);
        if (textDecoration != null) {
            as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT, textDecoration.underlinePaint, firstChar, lastChar + 1);
            as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT, textDecoration.underlineStrokePaint, firstChar, lastChar + 1);
            as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE, textDecoration.underlineStroke, firstChar, lastChar + 1);
            as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT, textDecoration.overlinePaint, firstChar, lastChar + 1);
            as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT, textDecoration.overlineStrokePaint, firstChar, lastChar + 1);
            as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE, textDecoration.overlineStroke, firstChar, lastChar + 1);
            as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT, textDecoration.strikethroughPaint, firstChar, lastChar + 1);
            as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT, textDecoration.strikethroughStrokePaint, firstChar, lastChar + 1);
            as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE, textDecoration.strikethroughStroke, firstChar, lastChar + 1);
        }
        this.addChildPaintAttributes(as, element, node, textDecoration, ctx);
    }

    protected void addChildPaintAttributes(AttributedString as, Element element, TextNode node, TextDecoration textDecoration, BridgeContext ctx) {
        Node child = element.getFirstChild();
        while (child != null) {
            String ln;
            if (child.getNodeType() == 1 && "http://www.w3.org/2000/svg".equals(child.getNamespaceURI()) && ((ln = child.getLocalName()).equals("tspan") || ln.equals("altGlyph") || ln.equals("a") || ln.equals("textPath") || ln.equals("tref"))) {
                Element childElement = (Element)child;
                TextDecoration td = this.getTextDecoration(childElement, node, textDecoration, ctx);
                this.addPaintAttributes(as, childElement, node, td, ctx);
            }
            child = child.getNextSibling();
        }
    }

    protected Map getAttributeMap(BridgeContext ctx, Element element, TextPath textPath) {
        String s;
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, element);
        HashMap<AttributedCharacterIterator.Attribute, Object> result = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        boolean verticalText = false;
        result.put(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER, element);
        if (element.getTagName().equals("altGlyph")) {
            result.put(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER, new SVGAltGlyphHandler(ctx, element));
        }
        if (textPath != null) {
            result.put(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH, textPath);
        }
        TextNode.Anchor a = TextUtilities.convertTextAnchor(element);
        result.put(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE, a);
        Float fs = TextUtilities.convertFontSize(element);
        result.put(TextAttribute.SIZE, fs);
        Float fw = TextUtilities.convertFontWeight(element);
        Value v = CSSUtilities.getComputedStyle(element, 27);
        String fontWeightString = v.getCssText();
        result.put(TextAttribute.WEIGHT, fw);
        String fontStyleString = CSSUtilities.getComputedStyle(element, 25).getStringValue();
        result.put(TextAttribute.POSTURE, TextUtilities.convertFontStyle(element));
        String fontStretchString = CSSUtilities.getComputedStyle(element, 24).getStringValue();
        result.put(TextAttribute.WIDTH, TextUtilities.convertFontStretch(element));
        Value val = CSSUtilities.getComputedStyle(element, 21);
        Vector<GVTFontFamily> fontFamilyList = new Vector<GVTFontFamily>();
        int len = val.getLength();
        int i = 0;
        while (i < len) {
            Value it = val.item(i);
            String fontFamilyName = it.getStringValue();
            GVTFontFamily fontFamily = SVGFontUtilities.getFontFamily(element, ctx, fontFamilyName, fontWeightString, fontStyleString);
            fontFamilyList.add(fontFamily);
            ++i;
        }
        result.put(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES, fontFamilyList);
        Object bs = TextUtilities.convertBaselineShift(element);
        if (bs != null) {
            result.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, bs);
        }
        if ((s = (val = CSSUtilities.getComputedStyle(element, 55)).getStringValue()).charAt(0) == 'n') {
            result.put(TextAttribute.BIDI_EMBEDDING, ZERO);
        } else {
            val = CSSUtilities.getComputedStyle(element, 11);
            String rs = val.getStringValue();
            block0 : switch (rs.charAt(0)) {
                case 'l': {
                    result.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    switch (s.charAt(0)) {
                        case 'b': {
                            result.put(TextAttribute.BIDI_EMBEDDING, new Integer(-2));
                            break;
                        }
                        case 'e': {
                            result.put(TextAttribute.BIDI_EMBEDDING, new Integer(2));
                        }
                    }
                    break;
                }
                case 'r': {
                    result.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    switch (s.charAt(0)) {
                        case 'b': {
                            result.put(TextAttribute.BIDI_EMBEDDING, new Integer(-1));
                            break block0;
                        }
                        case 'e': {
                            result.put(TextAttribute.BIDI_EMBEDDING, new Integer(1));
                        }
                    }
                }
            }
        }
        val = CSSUtilities.getComputedStyle(element, 58);
        s = val.getStringValue();
        switch (s.charAt(0)) {
            case 'l': {
                result.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR);
                break;
            }
            case 'r': {
                result.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL);
                break;
            }
            case 't': {
                result.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB);
            }
        }
        val = CSSUtilities.getComputedStyle(element, 29);
        switch (val.getPrimitiveType()) {
            case 21: {
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO);
                break;
            }
            case 11: {
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(val.getFloatValue()));
                break;
            }
            case 12: {
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float((double)(val.getFloatValue() * 180.0f) / Math.PI));
                break;
            }
            case 13: {
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(val.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        Float sp = TextUtilities.convertLetterSpacing(element);
        if (sp != null) {
            result.put(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING, sp);
            result.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((sp = TextUtilities.convertWordSpacing(element)) != null) {
            result.put(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING, sp);
            result.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((sp = TextUtilities.convertKerning(element)) != null) {
            result.put(GVTAttributedCharacterIterator.TextAttribute.KERNING, sp);
            result.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((s = element.getAttributeNS(null, "textLength")).length() != 0) {
            float f = UnitProcessor.svgOtherLengthToUserSpace(s, "textLength", uctx);
            result.put(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH, new Float(f));
            s = element.getAttributeNS(null, "lengthAdjust");
            if (s.length() < 10) {
                result.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING);
                result.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
            } else {
                result.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL);
            }
        }
        return result;
    }

    protected TextDecoration getParentTextDecoration(AttributedCharacterIterator aci, Element child) {
        Element parent = null;
        int firstChar = -1;
        int i = 0;
        while (i < aci.getEndIndex()) {
            aci.setIndex(i);
            Element delimeter = (Element)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (this.nodeAncestorOf(delimeter, child)) {
                parent = delimeter;
                firstChar = i;
            }
            if (delimeter == child || this.nodeAncestorOf(child, delimeter)) break;
            ++i;
        }
        TextDecoration textDecoration = new TextDecoration();
        if (parent == null) {
            return textDecoration;
        }
        aci.setIndex(firstChar);
        textDecoration.underlinePaint = (Paint)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
        textDecoration.underlineStrokePaint = (Paint)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
        textDecoration.underlineStroke = (Stroke)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
        textDecoration.overlinePaint = (Paint)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
        textDecoration.overlineStrokePaint = (Paint)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
        textDecoration.overlineStroke = (Stroke)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
        textDecoration.strikethroughPaint = (Paint)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
        textDecoration.strikethroughStrokePaint = (Paint)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
        textDecoration.strikethroughStroke = (Stroke)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
        return textDecoration;
    }

    protected TextDecoration getTextDecoration(Element element, GraphicsNode node, TextDecoration parent, BridgeContext ctx) {
        int pidx = 53;
        Value val = CSSUtilities.getComputedStyle(element, pidx);
        StyleMap sm = ((CSSStylableElement)element).getComputedStyleMap(null);
        if (sm.isNullCascaded(pidx)) {
            return parent;
        }
        TextDecoration textDecoration = new TextDecoration(parent);
        short t = val.getCssValueType();
        switch (val.getCssValueType()) {
            case 2: {
                ListValue lst = (ListValue)val;
                Paint paint = PaintServer.convertFillPaint(element, node, ctx);
                Paint strokePaint = PaintServer.convertStrokePaint(element, node, ctx);
                Stroke stroke = PaintServer.convertStroke(element);
                int len = lst.getLength();
                int i = 0;
                while (i < len) {
                    Value v = lst.item(i);
                    String s = v.getStringValue();
                    switch (s.charAt(0)) {
                        case 'u': {
                            if (paint != null) {
                                textDecoration.underlinePaint = paint;
                            }
                            if (strokePaint != null) {
                                textDecoration.underlineStrokePaint = strokePaint;
                            }
                            if (stroke == null) break;
                            textDecoration.underlineStroke = stroke;
                            break;
                        }
                        case 'o': {
                            if (paint != null) {
                                textDecoration.overlinePaint = paint;
                            }
                            if (strokePaint != null) {
                                textDecoration.overlineStrokePaint = strokePaint;
                            }
                            if (stroke == null) break;
                            textDecoration.overlineStroke = stroke;
                            break;
                        }
                        case 'l': {
                            if (paint != null) {
                                textDecoration.strikethroughPaint = paint;
                            }
                            if (strokePaint != null) {
                                textDecoration.strikethroughStrokePaint = strokePaint;
                            }
                            if (stroke == null) break;
                            textDecoration.strikethroughStroke = stroke;
                        }
                    }
                    ++i;
                }
                return textDecoration;
            }
        }
        return TextDecoration.EMPTY_TEXT_DECORATION;
    }

    protected class TspanBridge
    extends AbstractTextChildBridgeUpdateHandler {
        public TspanBridge(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            super(ctx, parent, e);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent evt) {
            String attrName = evt.getAttrName();
            if (attrName.equals("x") || attrName.equals("y") || attrName.equals("dx") || attrName.equals("dy") || attrName.equals("rotate")) {
                this.textBridge.computeLayoutedText();
            }
        }
    }

    protected class TextPathBridge
    extends AbstractTextChildBridgeUpdateHandler {
        public TextPathBridge(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            super(ctx, parent, e);
        }
    }

    protected class TRefBridge
    extends AbstractTextChildBridgeUpdateHandler {
        public TRefBridge(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            super(ctx, parent, e);
        }
    }

    protected abstract class AbstractTextChildBridgeUpdateHandler
    extends AbstractTextChildSVGContext
    implements BridgeUpdateHandler {
        public AbstractTextChildBridgeUpdateHandler(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            super(ctx, parent, e);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        }

        public void handleDOMNodeInsertedEvent(MutationEvent evt) {
            this.textBridge.handleDOMNodeInsertedEvent(evt);
        }

        public void handleDOMNodeRemovedEvent(MutationEvent evt) {
            this.dispose();
        }

        public void handleDOMCharacterDataModified(MutationEvent evt) {
            this.textBridge.handleDOMCharacterDataModified(evt);
        }

        public void handleCSSEngineEvent(CSSEngineEvent evt) {
            this.textBridge.handleCSSEngineEvent(evt);
        }

        public void dispose() {
            ((SVGOMElement)this.e).setSVGContext(null);
        }
    }

    protected abstract class AbstractTextChildSVGContext
    implements SVGContext {
        protected BridgeContext ctx;
        protected SVGTextElementBridge textBridge;
        protected Element e;

        public AbstractTextChildSVGContext(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            this.ctx = ctx;
            this.textBridge = parent;
            this.e = e;
        }

        public float getPixelUnitToMillimeter() {
            return this.ctx.getUserAgent().getPixelUnitToMillimeter();
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public Rectangle2D getBBox() {
            return null;
        }

        public AffineTransform getCTM() {
            return null;
        }

        public AffineTransform getGlobalTransform() {
            return null;
        }

        public float getViewportWidth() {
            return this.ctx.getBlockWidth(this.e);
        }

        public float getViewportHeight() {
            return this.ctx.getBlockHeight(this.e);
        }

        public float getFontSize() {
            return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
        }
    }

    protected static class TextDecoration {
        static final TextDecoration EMPTY_TEXT_DECORATION = new TextDecoration();
        Paint underlinePaint;
        Paint underlineStrokePaint;
        Stroke underlineStroke;
        Paint overlinePaint;
        Paint overlineStrokePaint;
        Stroke overlineStroke;
        Paint strikethroughPaint;
        Paint strikethroughStrokePaint;
        Stroke strikethroughStroke;

        TextDecoration() {
            this.underlinePaint = null;
            this.underlineStrokePaint = null;
            this.underlineStroke = null;
            this.overlinePaint = null;
            this.overlineStrokePaint = null;
            this.overlineStroke = null;
            this.strikethroughPaint = null;
            this.strikethroughStrokePaint = null;
            this.strikethroughStroke = null;
        }

        TextDecoration(TextDecoration td) {
            this.underlinePaint = td.underlinePaint;
            this.underlineStrokePaint = td.underlineStrokePaint;
            this.underlineStroke = td.underlineStroke;
            this.overlinePaint = td.overlinePaint;
            this.overlineStrokePaint = td.overlineStrokePaint;
            this.overlineStroke = td.overlineStroke;
            this.strikethroughPaint = td.strikethroughPaint;
            this.strikethroughStrokePaint = td.strikethroughStrokePaint;
            this.strikethroughStroke = td.strikethroughStroke;
        }
    }

    protected static class AttributedStringBuffer {
        protected List strings = new ArrayList();
        protected List attributes = new ArrayList();
        protected int count = 0;
        protected int length = 0;

        public boolean isEmpty() {
            return this.count == 0;
        }

        public int length() {
            return this.length;
        }

        public void append(String s, Map m) {
            if (s.length() == 0) {
                return;
            }
            this.strings.add(s);
            this.attributes.add(m);
            ++this.count;
            this.length += s.length();
        }

        public int getLastChar() {
            if (this.count == 0) {
                return -1;
            }
            String s = (String)this.strings.get(this.count - 1);
            return s.charAt(s.length() - 1);
        }

        public void stripLast() {
            String s = (String)this.strings.remove(this.count - 1);
            if (s.charAt(s.length() - 1) == ' ') {
                if (s.length() == 1) {
                    this.attributes.remove(--this.count);
                    return;
                }
                this.strings.add(s.substring(0, s.length() - 1));
                --this.length;
            } else {
                this.strings.add(s);
            }
        }

        public AttributedString toAttributedString() {
            switch (this.count) {
                case 0: {
                    return new AttributedString(" ");
                }
                case 1: {
                    return new AttributedString((String)this.strings.get(0), (Map)this.attributes.get(0));
                }
            }
            StringBuffer sb = new StringBuffer();
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
            }
            AttributedString result = new AttributedString(sb.toString());
            Iterator sit = this.strings.iterator();
            Iterator ait = this.attributes.iterator();
            int idx = 0;
            while (sit.hasNext()) {
                String s = (String)sit.next();
                int nidx = idx + s.length();
                Map m = (Map)ait.next();
                Iterator kit = m.keySet().iterator();
                Iterator vit = m.values().iterator();
                while (kit.hasNext()) {
                    AttributedCharacterIterator.Attribute attr = (AttributedCharacterIterator.Attribute)kit.next();
                    Object val = vit.next();
                    result.addAttribute(attr, val, idx, nidx);
                }
                idx = nidx;
            }
            return result;
        }

        public String toString() {
            switch (this.count) {
                case 0: {
                    return "";
                }
                case 1: {
                    return (String)this.strings.get(0);
                }
            }
            StringBuffer sb = new StringBuffer();
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
            }
            return sb.toString();
        }
    }

    protected class DOMSubtreeModifiedEventListener
    implements EventListener {
        protected DOMSubtreeModifiedEventListener() {
        }

        public void handleEvent(Event evt) {
            SVGTextElementBridge.this.handleDOMSubtreeModifiedEvent((MutationEvent)evt);
        }
    }

    protected class DOMChildNodeRemovedEventListener
    implements EventListener {
        protected DOMChildNodeRemovedEventListener() {
        }

        public void handleEvent(Event evt) {
            SVGTextElementBridge.this.handleDOMChildNodeRemovedEvent((MutationEvent)evt);
        }
    }
}

