/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGAElement;

public class SVGAElementBridge
extends AbstractGraphicsNodeBridge {
    public String getLocalName() {
        return "a";
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new CompositeGraphicsNode();
    }

    public void buildGraphicsNode(BridgeContext ctx, Element e, GraphicsNode node) {
        super.buildGraphicsNode(ctx, e, node);
        EventTarget target = (EventTarget)((Object)e);
        EventListener l = new AnchorListener(ctx.getUserAgent());
        target.addEventListener("click", l, false);
        ctx.storeEventListener(target, "click", l, false);
        l = new CursorMouseOverListener(ctx.getUserAgent());
        target.addEventListener("mouseover", l, false);
        ctx.storeEventListener(target, "mouseover", l, false);
        l = new CursorMouseOutListener(ctx.getUserAgent());
        target.addEventListener("mouseout", l, false);
        ctx.storeEventListener(target, "mouseout", l, false);
    }

    public boolean isComposite() {
        return true;
    }

    public static class CursorMouseOutListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOutListener(UserAgent ua) {
            this.userAgent = ua;
        }

        public void handleEvent(Event evt) {
            SVGAElement elt = (SVGAElement)evt.getCurrentTarget();
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.userAgent.setSVGCursor(cursor);
            this.userAgent.displayMessage("");
            evt.stopPropagation();
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOverListener(UserAgent ua) {
            this.userAgent = ua;
        }

        public void handleEvent(Event evt) {
            SVGAElement elt = (SVGAElement)evt.getCurrentTarget();
            Cursor cursor = Cursor.getPredefinedCursor(12);
            this.userAgent.setSVGCursor(cursor);
            if (elt != null) {
                String href = XLinkSupport.getXLinkHref(elt);
                this.userAgent.displayMessage(href);
            }
            evt.stopPropagation();
        }
    }

    public static class AnchorListener
    implements EventListener {
        protected UserAgent userAgent;

        public AnchorListener(UserAgent ua) {
            this.userAgent = ua;
        }

        public void handleEvent(Event evt) {
            SVGAElement elt = (SVGAElement)evt.getCurrentTarget();
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.userAgent.setSVGCursor(cursor);
            this.userAgent.openLink(elt);
            evt.stopPropagation();
        }
    }
}

