/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFFileSpec;

public class PDFGoToRemote
extends PDFAction {
    protected PDFFileSpec pdfFileSpec;
    protected int pageReference = 0;
    protected String destination = null;

    public PDFGoToRemote(int number, PDFFileSpec pdfFileSpec) {
        super(number);
        this.pdfFileSpec = pdfFileSpec;
    }

    public PDFGoToRemote(int number, PDFFileSpec pdfFileSpec, int page) {
        super(number);
        this.pdfFileSpec = pdfFileSpec;
        this.pageReference = page;
    }

    public PDFGoToRemote(int number, PDFFileSpec pdfFileSpec, String dest) {
        super(number);
        this.pdfFileSpec = pdfFileSpec;
        this.destination = dest;
    }

    public String getAction() {
        return this.referencePDF();
    }

    public byte[] toPDF() {
        String p = new String(this.number + " " + this.generation + " obj\n" + "<<\n/S /GoToR\n" + "/F " + this.pdfFileSpec.referencePDF() + "\n");
        p = this.destination != null ? p + "/D (" + this.destination + ")" : p + "/D [ " + this.pageReference + " /XYZ null null null ]";
        p = p + " \n>>\nendobj\n";
        try {
            return p.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            return p.getBytes();
        }
    }
}

