/*
 * Decompiled with CFR 0.152.
 */
package be.re.xml.sax;

import be.re.xml.sax.CatalogResolver;
import be.re.xml.sax.ErrorHandler;
import java.net.URL;
import java.util.Iterator;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Util {
    public static XMLReader getParser(URL catalog, boolean validating) throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(validating);
            Util.tryFactoryProperties(factory, validating);
            XMLReader parser = factory.newSAXParser().getXMLReader();
            parser.setErrorHandler(new ErrorHandler(false));
            if (catalog != null) {
                CatalogResolver resolver = new CatalogResolver(catalog);
                parser.setEntityResolver(resolver);
                Util.trySchemaLocation(parser, resolver);
            }
            return parser;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public static SAXTransformerFactory newSAXTransformerFactory() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        return (SAXTransformerFactory)factory;
    }

    private static void tryFactoryProperties(SAXParserFactory factory, boolean validating) {
        try {
            factory.setFeature("http://apache.org/xml/features/validation/schema", validating);
            factory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", validating);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void trySchemaLocation(XMLReader parser, CatalogResolver resolver) {
        try {
            String schemaLocation = "";
            Iterator i = resolver.getSystemIdentifierMappings().keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                schemaLocation = schemaLocation + key + " " + key + " ";
            }
            parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", schemaLocation);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

