/*
 * Decompiled with CFR 0.152.
 */
package be.re.xml.sax;

import be.re.io.StreamConnector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CatalogResolver
implements EntityResolver {
    static final int SINGLE_QUOTE = 0;
    static final int DOUBLE_QUOTE = 1;
    static final int OTHER = 2;
    static final int SPACE = 3;
    static final int WHITE = 4;
    static final int EOF = 5;
    static final int TYP = 0;
    static final int SQ1 = 1;
    static final int DQ1 = 2;
    static final int ID1 = 3;
    static final int SQ2 = 4;
    static final int DQ2 = 5;
    static final int ERR = 6;
    static final int[][][] FSM = new int[][][]{new int[][]{{1, 1}, {2, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, new int[][]{{3, 1}, {1, 0}, {1, 0}, {1, 0}, {6, 0}, {6, 0}}, new int[][]{{2, 0}, {3, 1}, {2, 0}, {2, 0}, {6, 0}, {6, 0}}, new int[][]{{4, 1}, {5, 1}, {6, 0}, {3, 0}, {3, 0}, {6, 0}}, new int[][]{{0, 1}, {4, 0}, {4, 0}, {4, 0}, {6, 0}, {6, 0}}, new int[][]{{5, 0}, {0, 1}, {5, 0}, {5, 0}, {6, 0}, {6, 0}}};
    private URL catalogUrl;
    private Map publicIdentifiers = new HashMap();
    private Map systemIdentifiers = new HashMap();

    public CatalogResolver(URL catalogUrl) throws IOException {
        this.catalogUrl = catalogUrl;
        this.load();
    }

    private static int category(int c) {
        return c == 39 ? 0 : (c == 34 ? 1 : (c == 32 ? 3 : (c == 9 || c == 10 || c == 13 ? 4 : 2)));
    }

    private static void error(int in, int line) throws IOException {
        if (in == 5) {
            throw new IOException("Line " + String.valueOf(line) + ": premature end of file");
        }
        if (in == 4) {
            throw new IOException("Line " + String.valueOf(line) + ": \\t, \\n and \\r are not allowed in an identifier");
        }
        if (in == 2) {
            throw new IOException("Line " + String.valueOf(line) + ": white space expected");
        }
    }

    public Map getPublicIdentifierMappings() {
        return this.publicIdentifiers;
    }

    public Map getSystemIdentifierMappings() {
        return this.systemIdentifiers;
    }

    private static String getTypeToken(char[] c, int off, int len, int line) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(new String(c, off, len), " \t\n\r");
        if (!tokenizer.hasMoreTokens()) {
            throw new IOException("Line " + String.valueOf(line) + ": PUBLIC or SYSTEM expected");
        }
        String token = tokenizer.nextToken();
        if (!token.equals("PUBLIC") && !token.equals("SYSTEM")) {
            throw new IOException("Line " + String.valueOf(line) + ": PUBLIC or SYSTEM expected");
        }
        return token;
    }

    private void load() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamConnector.copy(this.catalogUrl.openStream(), out);
        char[] c = new String(out.toByteArray(), "ASCII").toCharArray();
        String from = null;
        int line = 1;
        int position = 0;
        int state = 0;
        String type = null;
        for (int i = 0; i < c.length; ++i) {
            int[] next = FSM[state][CatalogResolver.category(c[i])];
            if (next[0] == 6) {
                CatalogResolver.error(CatalogResolver.category(c[i]), line);
            }
            if (next[1] == 1) {
                switch (state) {
                    case 0: {
                        type = CatalogResolver.getTypeToken(c, position, i - position, line);
                        break;
                    }
                    case 1: 
                    case 2: {
                        from = new String(c, position, i - position);
                        break;
                    }
                    case 4: 
                    case 5: {
                        Map map = type.equals("PUBLIC") ? this.publicIdentifiers : this.systemIdentifiers;
                        map.put(from, new URL(this.catalogUrl, new String(c, position, i - position)));
                    }
                }
                position = i + 1;
            }
            state = next[0];
            if (c[i] != '\n') continue;
            ++line;
        }
        if (FSM[state][5][0] == 6) {
            CatalogResolver.error(5, line);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return publicId != null && this.publicIdentifiers.get(publicId) != null ? new InputSource(this.publicIdentifiers.get(publicId).toString()) : (systemId != null && this.systemIdentifiers.get(systemId) != null ? new InputSource(this.systemIdentifiers.get(systemId).toString()) : null);
    }
}

