/*
 * Decompiled with CFR 0.152.
 */
package be.re.xml;

import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class DOMToContentHandler {
    public static Attributes createAttributes(Element element) {
        AttributesImpl attributes = new AttributesImpl();
        NamedNodeMap map = element.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Attr attribute = (Attr)map.item(i);
            if (attribute.getNamespaceURI() != null) {
                attributes.addAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getPrefix() != null ? attribute.getPrefix() + ":" + attribute.getLocalName() : attribute.getLocalName(), "CDATA", attribute.getValue());
                continue;
            }
            attributes.addAttribute("", attribute.getName(), attribute.getName(), "CDATA", attribute.getValue());
        }
        return attributes;
    }

    public static void documentToContentHandler(Document document, ContentHandler handler) throws SAXException {
        XMLFilterImpl h = DOMToContentHandler.realHandler(handler);
        h.startDocument();
        DOMToContentHandler.elementToContentHandler(document.getDocumentElement(), h);
        h.endDocument();
    }

    public static void elementToContentHandler(Element element, ContentHandler handler) throws SAXException {
        DOMToContentHandler.elementToContentHandler(element, DOMToContentHandler.realHandler(handler));
    }

    private static void elementToContentHandler(Element element, XMLFilterImpl handler) throws SAXException {
        String[] prefixes = DOMToContentHandler.startPrefixMappings(element, handler);
        DOMToContentHandler.startElement(element, handler);
        DOMToContentHandler.siblingsToContentHandler(element.getFirstChild(), handler);
        DOMToContentHandler.endElement(element, handler);
        for (int i = prefixes.length - 1; i >= 0; --i) {
            handler.endPrefixMapping(prefixes[i]);
        }
    }

    public static void endElement(Element element, ContentHandler handler) throws SAXException {
        if (element.getNamespaceURI() != null) {
            handler.endElement(element.getNamespaceURI(), element.getLocalName(), element.getPrefix() != null ? element.getPrefix() + ":" + element.getLocalName() : element.getLocalName());
        } else {
            handler.endElement("", element.getTagName(), element.getTagName());
        }
    }

    private static XMLFilterImpl realHandler(ContentHandler handler) {
        XMLFilterImpl result = new XMLFilterImpl();
        result.setContentHandler(handler);
        if (handler instanceof XMLFilter) {
            ((XMLFilter)((Object)handler)).setParent(result);
        }
        return result;
    }

    public static void siblingsToContentHandler(Node node, ContentHandler handler) throws SAXException {
        DOMToContentHandler.siblingsToContentHandler(node, DOMToContentHandler.realHandler(handler));
    }

    private static void siblingsToContentHandler(Node node, XMLFilterImpl handler) throws SAXException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                DOMToContentHandler.elementToContentHandler((Element)node, handler);
                break;
            }
            case 7: {
                handler.processingInstruction(((ProcessingInstruction)node).getTarget(), ((ProcessingInstruction)node).getData());
                break;
            }
            case 3: {
                char[] chars = ((Text)node).getData().toCharArray();
                handler.characters(chars, 0, chars.length);
            }
        }
        DOMToContentHandler.siblingsToContentHandler(node.getNextSibling(), handler);
    }

    public static void startElement(Element element, ContentHandler handler) throws SAXException {
        if (element.getNamespaceURI() != null) {
            handler.startElement(element.getNamespaceURI(), element.getLocalName(), element.getPrefix() != null ? element.getPrefix() + ":" + element.getLocalName() : element.getLocalName(), DOMToContentHandler.createAttributes(element));
        } else {
            handler.startElement("", element.getTagName(), element.getTagName(), DOMToContentHandler.createAttributes(element));
        }
    }

    private static String[] startPrefixMappings(Element element, ContentHandler handler) throws SAXException {
        NamedNodeMap map = element.getAttributes();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < map.getLength(); ++i) {
            Attr attribute = (Attr)map.item(i);
            String name = attribute.getName();
            if (!name.startsWith("xmlns")) continue;
            String prefix = name.startsWith("xmlns:") ? name.substring(name.indexOf(58) + 1) : "";
            result.add(prefix);
            handler.startPrefixMapping(prefix, attribute.getValue());
        }
        return result.toArray(new String[result.size()]);
    }
}

