/*
 * Decompiled with CFR 0.152.
 */
package be.re.xml;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class Accumulator
extends XMLFilterImpl {
    private static final DocumentBuilder documentBuilder = Accumulator.createDocumentBuilder();
    private Node currentNode = null;
    private Document document = null;
    private Stack prefixMappings = new Stack();
    private Result result = null;

    public Accumulator() {
        this((Document)null, (Result)null);
    }

    public Accumulator(XMLReader parent) {
        this(null, null, parent);
    }

    public Accumulator(Result result) {
        this((Document)null, result);
    }

    public Accumulator(Result result, XMLReader parent) {
        this(null, result, parent);
    }

    public Accumulator(Document document) {
        this.document = document;
    }

    public Accumulator(Document document, XMLReader parent) {
        super(parent);
        this.document = document;
    }

    public Accumulator(Document document, Result result) {
        this.document = document;
        this.result = result;
    }

    public Accumulator(Document document, Result result, XMLReader parent) {
        super(parent);
        this.document = document;
        this.result = result;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentNode.appendChild(this.document.createTextNode(new String(ch, start, length)));
    }

    private static DocumentBuilder createDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void endDocument() throws SAXException {
        this.prefixMappings.pop();
        this.currentNode = null;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.prefixMappings.pop();
        this.currentNode = this.currentNode.getParentNode();
        if (this.result != null && this.currentNode == this.document) {
            this.result.report(this);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        ((Map)this.prefixMappings.peek()).remove(prefix);
    }

    public Document getDocument() {
        return this.document;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public static void postAccumulate(XMLFilter filter, ProcessElement process) throws SAXException {
        final XMLFilter f = filter;
        final ContentHandler handler = filter.getContentHandler();
        final ProcessElement p = process;
        Accumulator accumulator = new Accumulator(documentBuilder.newDocument(), new Result(){

            public void report(Accumulator accumulator) throws SAXException {
                f.setContentHandler(handler);
                p.process(accumulator.getDocument().getDocumentElement(), f);
                accumulator.endDocument();
            }
        });
        filter.setContentHandler(accumulator);
        accumulator.setParent(filter);
        accumulator.startDocument();
    }

    public static void preAccumulate(String namespaceURI, String localName, String qName, Attributes atts, XMLFilter filter, ProcessElement process) throws SAXException {
        if (filter.getParent() == null) {
            return;
        }
        final XMLFilter f = filter;
        final ContentHandler handler = filter.getParent().getContentHandler();
        final ProcessElement p = process;
        Accumulator accumulator = new Accumulator(documentBuilder.newDocument(), new Result(){

            public void report(Accumulator accumulator) throws SAXException {
                p.process(accumulator.getDocument().getDocumentElement(), f);
                accumulator.endDocument();
                f.getParent().setContentHandler(handler);
            }
        });
        filter.getParent().setContentHandler(accumulator);
        accumulator.setParent(filter.getParent());
        accumulator.startDocument();
        accumulator.startElement(namespaceURI, localName, qName, atts);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.currentNode.appendChild(this.document.createProcessingInstruction(target, data));
    }

    public void setDocumentLocator(Locator locator) {
    }

    private static void setAttributes(Element element, Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.getURI(i) == null || "".equals(atts.getURI(i))) {
                element.setAttribute(atts.getQName(i), atts.getValue(i));
                continue;
            }
            element.setAttributeNS(atts.getURI(i), atts.getQName(i), atts.getValue(i));
        }
    }

    private static void setPrefixMappings(Element element, Map mappings) {
        Iterator i = mappings.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            element.setAttribute("".equals(prefix) ? "xmlns" : "xmlns:" + prefix, (String)mappings.get(prefix));
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        if (this.document == null) {
            try {
                this.document = documentBuilder.newDocument();
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        } else if (this.document.getDocumentElement() != null) {
            this.document.removeChild(this.document.getDocumentElement());
        }
        this.currentNode = this.document;
        this.prefixMappings.push(new HashMap());
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Element element = this.document.createElementNS("".equals(namespaceURI) ? null : namespaceURI, qName);
        Accumulator.setAttributes(element, atts);
        Accumulator.setPrefixMappings(element, (Map)this.prefixMappings.peek());
        this.prefixMappings.push(new HashMap());
        this.currentNode.appendChild(element);
        this.currentNode = element;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        ((Map)this.prefixMappings.peek()).put(prefix, uri);
    }

    public static interface Result {
        public void report(Accumulator var1) throws SAXException;
    }

    public static interface ProcessElement {
        public void process(Element var1, XMLFilter var2) throws SAXException;
    }
}

