/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Constants;
import be.re.css.Util;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class WidthAndMarginsFilter
extends XMLFilterImpl {
    private Stack stack = new Stack();

    WidthAndMarginsFilter() {
    }

    WidthAndMarginsFilter(XMLReader parent) {
        super(parent);
    }

    private static String adjustMargin(String margin, Attributes atts, String edge) {
        String s;
        return "auto".equals(margin) ? margin : margin + (Util.isZeroLength(s = WidthAndMarginsFilter.getBorderWidth(atts, edge)) ? "" : "+" + s);
    }

    private static String canonicLength(String value) {
        return Util.isZeroLength(value) ? "0pt" : value;
    }

    private static Attributes correctBlock(Attributes atts, Attributes parent) {
        AttributesImpl result = new AttributesImpl(atts);
        String marginLeft = WidthAndMarginsFilter.getImplicitZeroProperty(atts, "margin-left");
        String marginRight = WidthAndMarginsFilter.getImplicitZeroProperty(atts, "margin-right");
        String width = WidthAndMarginsFilter.getWidth(atts, parent);
        if ("auto".equals(width)) {
            marginLeft = "0pt";
            marginRight = "0pt";
        } else if (!(width == null || width.equals("auto") || marginLeft.equals("auto") || marginRight.equals("auto"))) {
            String direction = atts.getValue(Constants.CSS, "direction");
            if (direction == null || direction.equals("ltr")) {
                marginRight = "auto";
            } else {
                marginLeft = "auto";
            }
        }
        if (marginLeft.equals("auto") && marginRight.equals("auto")) {
            marginRight = "0pt";
        }
        WidthAndMarginsFilter.setValue(result, "margin-left", WidthAndMarginsFilter.adjustMargin(marginLeft, atts, "left"));
        WidthAndMarginsFilter.setValue(result, "margin-right", WidthAndMarginsFilter.adjustMargin(marginRight, atts, "right"));
        if (width != null) {
            WidthAndMarginsFilter.setValue(result, "width", width);
        }
        return result;
    }

    private static Attributes correctInline(Attributes atts) {
        AttributesImpl result = new AttributesImpl(atts);
        int index = result.getIndex(Constants.CSS, "width");
        if (index != -1) {
            result.removeAttribute(index);
        }
        WidthAndMarginsFilter.makeAutoExplicit(result, "margin-left");
        WidthAndMarginsFilter.makeAutoExplicit(result, "margin-right");
        return result;
    }

    private static Attributes correctFloat(Attributes atts) {
        AttributesImpl result = new AttributesImpl(atts);
        WidthAndMarginsFilter.makeAutoExplicit(result, "margin-left");
        WidthAndMarginsFilter.makeAutoExplicit(result, "margin-right");
        return result;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        this.stack.pop();
    }

    private static String getBorderWidth(Attributes atts, String edge) {
        String value = atts.getValue(Constants.CSS, "border-" + edge + "-width");
        return atts.getValue(Constants.CSS, "border-" + edge + "-style") == null || "none".equals(atts.getValue(Constants.CSS, "border-" + edge + "-style")) ? "0pt" : (value == null ? "0.6pt" : ("thin".equals(value) ? "0.2pt" : ("medium".equals(value) ? "0.6pt" : ("thick".equals(value) ? "1pt" : WidthAndMarginsFilter.canonicLength(value)))));
    }

    private static String getImplicitZeroProperty(Attributes atts, String property) {
        String value = atts.getValue(Constants.CSS, property);
        return value == null ? "0pt" : WidthAndMarginsFilter.canonicLength(value);
    }

    private static String getPadding(Attributes atts, String edge) {
        String value = atts.getValue(Constants.CSS, "padding-" + edge);
        return value == null ? "0pt" : WidthAndMarginsFilter.canonicLength(value);
    }

    private static String getWidth(Attributes atts, Attributes parent) {
        String value = atts.getValue(Constants.CSS, "width");
        return value == null ? null : (value.endsWith("%") && (parent.getIndex(Constants.CSS, "width") == -1 || "auto".equals(parent.getValue(Constants.CSS, "width")) || "table-cell".equals(parent.getValue(Constants.CSS, "display"))) ? "auto" : value);
    }

    private static void makeAutoExplicit(AttributesImpl atts, String property) {
        int index = atts.getIndex(Constants.CSS, property);
        if (index == -1) {
            atts.addAttribute(Constants.CSS, property, "css:" + property, "CDATA", "0pt");
        } else if ("auto".equals(atts.getValue(index))) {
            atts.setValue(index, "0pt");
        }
    }

    private static void setValue(AttributesImpl atts, String name, String value) {
        int index = atts.getIndex(Constants.CSS, name);
        if (index != -1) {
            atts.setValue(index, value);
        } else {
            atts.addAttribute(Constants.CSS, name, "css:" + name, "CDATA", value);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String display = atts.getValue(Constants.CSS, "display");
        if (display != null) {
            if (display.equals("inline")) {
                atts = WidthAndMarginsFilter.correctInline(atts);
            } else if (atts.getValue(Constants.CSS, "float") != null && !"none".equals(atts.getValue(Constants.CSS, "float"))) {
                atts = WidthAndMarginsFilter.correctFloat(atts);
            } else if (!(!Util.inArray(new String[]{"block", "compact", "list-item", "run-in", "table"}, display) || "absolute".equals(atts.getValue(Constants.CSS, "position")) || "fixed".equals(atts.getValue(Constants.CSS, "position")) || !this.stack.isEmpty() && "table-cell".equals(((Attributes)this.stack.peek()).getValue(Constants.CSS, "display")))) {
                atts = WidthAndMarginsFilter.correctBlock(atts, !this.stack.isEmpty() ? (Attributes)this.stack.peek() : new AttributesImpl());
            }
        }
        this.stack.push(new AttributesImpl(atts));
        super.startElement(namespaceURI, localName, qName, atts);
    }
}

