/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Constants;
import be.re.css.Context;
import be.re.css.PageRule;
import be.re.css.Property;
import be.re.css.Util;
import be.re.xml.DOMToContentHandler;
import be.re.xml.sax.FilterOfFilters;
import be.re.xml.sax.GobbleDocumentEvents;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class PageSetupFilter
extends XMLFilterImpl {
    private static final String[][] pageInheritanceTable = new String[][]{{"first-left-named", "unnamed", "left", "first", "named"}, {"first-right-named", "unnamed", "right", "first", "named"}, {"left-named", "unnamed", "left", "named"}, {"right-named", "unnamed", "right", "named"}, {"blank-left-named", "unnamed", "left", "blank", "named"}, {"blank-right-named", "unnamed", "right", "blank", "named"}};
    private static final String[] prefixes = new String[]{"first-left-", "first-right-", "blank-left-", "blank-right-", "first-", "blank-", "left-", "right-"};
    private static final String[][] regionInheritanceTable = new String[][]{{"first-left-named", "first-named", "first-left", "first", "left-named", "left", "named", "unnamed"}, {"first-right-named", "first-named", "first-right", "first", "right-named", "right", "named", "unnamed"}, {"left-named", "left", "named", "unnamed"}, {"right-named", "right", "named", "unnamed"}, {"blank-left-named", "blank-named", "blank-left", "blank", "left-named", "left", "named", "unnamed"}, {"blank-right-named", "blank-named", "blank-right", "blank", "right-named", "right", "named", "unnamed"}};
    private URL baseUrl;
    private Context context;
    private boolean debug;
    private Stack elements = new Stack();
    private Map userAgentParameters;

    PageSetupFilter(Context context, URL baseUrl, Map userAgentParameters, boolean debug) {
        this.context = context;
        this.baseUrl = baseUrl;
        this.userAgentParameters = userAgentParameters;
        this.debug = debug;
    }

    PageSetupFilter(Context context, URL baseUrl, Map userAgentParameters, XMLReader parent, boolean debug) {
        super(parent);
        this.context = context;
        this.baseUrl = baseUrl;
        this.userAgentParameters = userAgentParameters;
        this.debug = debug;
    }

    private static List addUnnamedPageRule(List pageRules) {
        boolean unnamedPresent = false;
        Iterator i = pageRules.iterator();
        while (i.hasNext() && !unnamedPresent) {
            if (!((PageRule)i.next()).getName().equals("unnamed")) continue;
            unnamedPresent = true;
        }
        if (unnamedPresent) {
            return pageRules;
        }
        PageRule rule = new PageRule("unnamed", 0);
        rule.addProperty(new Property("size", "portrait", false));
        pageRules.add(rule);
        return pageRules;
    }

    private PageRule[] applyPageRules() throws SAXException {
        if (this.context.pageRules.size() == 0) {
            return new PageRule[0];
        }
        PageRule[] pageRules = PageSetupFilter.recomposePageRules(PageSetupFilter.sortPageRules(PageSetupFilter.splitPageRules(PageSetupFilter.addUnnamedPageRule(this.context.pageRules))));
        super.startElement(Constants.CSS, "pages", "css:pages", new AttributesImpl());
        String[] names = PageSetupFilter.getPageRuleNames(pageRules);
        for (int i = 0; i < names.length; ++i) {
            this.generatePage(this.getPageAttributes(pageRules, names[i], PageSetupFilter.getInheritanceTableEntry(pageInheritanceTable, names[i])));
        }
        super.endElement(Constants.CSS, "pages", "css:pages");
        return pageRules;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.shouldEmitContents()) {
            super.characters(ch, start, length);
        }
    }

    private static void cloneRegions(Map regions, String pageName, Map inheritedRegions) {
        HashMap<String, org.w3c.dom.Element> current = (HashMap<String, org.w3c.dom.Element>)regions.get(pageName);
        if (current == null) {
            current = new HashMap<String, org.w3c.dom.Element>();
        }
        Iterator i = inheritedRegions.keySet().iterator();
        while (i.hasNext()) {
            String regionName = (String)i.next();
            if (current.get(regionName) != null) continue;
            org.w3c.dom.Element regionCopy = (org.w3c.dom.Element)((org.w3c.dom.Element)inheritedRegions.get(regionName)).cloneNode(true);
            regionCopy.setAttributeNS(Constants.CSS, "css:page", pageName);
            current.put(regionName, regionCopy);
        }
        regions.put(pageName, current);
    }

    private boolean closeElementsInBodyRegion() throws SAXException {
        boolean closed = false;
        for (int i = this.elements.size() - 1; i >= 0 && ((Element)this.elements.get(i)).inBodyRegion; --i) {
            Element element = (Element)this.elements.get(i);
            super.endElement(element.namespaceURI, element.localName, element.qName);
            closed = true;
        }
        return closed;
    }

    public void endDocument() throws SAXException {
        super.endElement(Constants.CSS, "root", "css:root");
        super.endDocument();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Element element = (Element)this.elements.pop();
        if (element.inBodyRegion) {
            super.endElement(namespaceURI, localName, qName);
            if (this.elements.isEmpty() || !((Element)this.elements.peek()).inBodyRegion) {
                super.startElement(Constants.CSS, "last-page-mark", "css:last-page-mark", new AttributesImpl());
                super.endElement(Constants.CSS, "last-page-mark", "css:last-page-mark");
                super.endElement(Constants.CSS, "page-sequence", "css:page-sequence");
            } else if (element.span && this.closeElementsInBodyRegion()) {
                this.reopenElementsInBodyRegion(false);
            }
        }
    }

    private static String extractPseudoPrefix(String pageName) {
        for (int i = 0; i < prefixes.length; ++i) {
            if (!pageName.startsWith(prefixes[i])) continue;
            return prefixes[i];
        }
        return "";
    }

    private void generatePage(Attributes attributes) throws SAXException {
        super.startElement(Constants.CSS, "page", "css:page", attributes);
        super.endElement(Constants.CSS, "page", "css:page");
    }

    private void generateRegions(PageRule[] pageRules) throws SAXException {
        if (this.context.regions.size() == 0) {
            return;
        }
        this.resolveAllRegions(pageRules);
        super.startElement(Constants.CSS, "regions", "css:regions", new AttributesImpl());
        if (this.getContentHandler() != null) {
            FilterOfFilters filter = new FilterOfFilters(new XMLFilter[]{Util.createPostProjectionFilter(this.baseUrl, this.userAgentParameters, this.debug).getFilter(), new GobbleDocumentEvents()});
            ((XMLFilterImpl)filter).setContentHandler(this.getContentHandler());
            filter.startDocument();
            Iterator i = this.context.regions.values().iterator();
            while (i.hasNext()) {
                Iterator j = ((Map)i.next()).values().iterator();
                while (j.hasNext()) {
                    DOMToContentHandler.elementToContentHandler((org.w3c.dom.Element)j.next(), (ContentHandler)filter);
                }
            }
            filter.endDocument();
        }
        super.endElement(Constants.CSS, "regions", "css:regions");
    }

    private static String[] getInheritanceTableEntry(String[][] table, String name) {
        String symbolic = PageSetupFilter.extractPseudoPrefix(name) + "named";
        String unprefixed = PageSetupFilter.stripPseudoPrefix(name);
        for (int i = 0; i < table.length; ++i) {
            if (!table[i][0].equals(symbolic)) continue;
            String[] result = new String[table[i].length - 1];
            for (int j = 0; j < result.length; ++j) {
                int index = table[i][j + 1].equals("unnamed") ? -1 : table[i][j + 1].indexOf("named");
                result[j] = index != -1 ? table[i][j + 1].substring(0, index) + unprefixed : table[i][j + 1];
            }
            return result;
        }
        return new String[0];
    }

    private Attributes getPageAttributes(PageRule[] pageRules, String pageName, String[] names) {
        AttributesImpl result = new AttributesImpl();
        result.addAttribute(Constants.CSS, "name", "css:name", "CDATA", pageName);
        for (int i = 0; i < names.length; ++i) {
            boolean found = false;
            for (int j = 0; !found && j < pageRules.length; ++j) {
                if (!names[i].equals(pageRules[j].getName())) continue;
                found = true;
                Property[] properties = pageRules[j].getProperties();
                for (int k = 0; k < properties.length; ++k) {
                    Util.setCSSAttribute(result, properties[k], -1);
                }
            }
        }
        return result;
    }

    private static String[] getPageRuleNames(PageRule[] rules) {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < rules.length; ++i) {
            String stripped = PageSetupFilter.stripPseudoPrefix(rules[i].getName());
            if (PageSetupFilter.isPseudoPageName(rules[i].getName())) continue;
            result.add("first-left-" + stripped);
            result.add("first-right-" + stripped);
            result.add("blank-left-" + stripped);
            result.add("blank-right-" + stripped);
            result.add("left-" + stripped);
            result.add("right-" + stripped);
        }
        result.remove("first");
        result.remove("blank");
        result.remove("left");
        result.remove("right");
        result.remove("first-left");
        result.remove("first-right");
        result.remove("blank-left");
        result.remove("blank-right");
        result.remove("unnamed");
        return result.toArray(new String[result.size()]);
    }

    private static boolean isPseudoPageName(String name) {
        return Util.inArray(new String[]{"first", "left", "right", "blank"}, name);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.shouldEmitContents()) {
            super.processingInstruction(target, data);
        }
    }

    private static PageRule[] recomposePageRules(PageRule[] pageRules) {
        HashMap<String, PageRule> result = new HashMap<String, PageRule>();
        for (int i = 0; i < pageRules.length; ++i) {
            PageRule pageRule = (PageRule)result.get(pageRules[i].getName());
            if (pageRule == null) {
                pageRule = new PageRule(pageRules[i].getName(), 0);
                result.put(pageRule.getName(), pageRule);
            }
            pageRule.setProperty(pageRules[i].getProperties()[0]);
        }
        return result.values().toArray(new PageRule[0]);
    }

    private void reopenElementsInBodyRegion(boolean span) throws SAXException {
        int i;
        for (i = this.elements.size() - 1; i >= 0 && ((Element)this.elements.get(i)).inBodyRegion; --i) {
        }
        if (((Element)this.elements.get(i + 1)).inBodyRegion) {
            for (int j = i + 1; j < this.elements.size(); ++j) {
                Element element = (Element)this.elements.get(j);
                AttributesImpl atts = element.atts;
                if (span && j == i + 1) {
                    atts = new AttributesImpl(atts);
                    atts.addAttribute(Constants.CSS, "column-span", "css:column-span", "CDATA", "all");
                }
                super.startElement(element.namespaceURI, element.localName, element.qName, atts);
            }
        }
    }

    private void resolveAllRegions(PageRule[] pageRules) {
        String[] names = PageSetupFilter.getPageRuleNames(pageRules);
        for (int i = 0; i < names.length; ++i) {
            PageSetupFilter.resolveRegions(this.context.regions, names[i]);
        }
    }

    private static void resolveRegions(Map regions, String name) {
        String[] entry = PageSetupFilter.getInheritanceTableEntry(regionInheritanceTable, name);
        for (int i = 0; i < entry.length; ++i) {
            Map inherited = (Map)regions.get(entry[i]);
            if (inherited == null) continue;
            PageSetupFilter.cloneRegions(regions, name, inherited);
        }
    }

    void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    private boolean shouldEmitContents() {
        return ((Element)this.elements.peek()).inBodyRegion;
    }

    private static PageRule[] sortPageRules(PageRule[] pageRules) {
        Arrays.sort(pageRules, new Comparator(){

            public int compare(Object object1, Object object2) {
                int result;
                PageRule rule1 = (PageRule)object1;
                PageRule rule2 = (PageRule)object2;
                String name1 = rule1.getName();
                String name2 = rule2.getName();
                int n = !"unnamed".equals(name1) && "unnamed".equals(name2) ? 1 : (result = "unnamed".equals(name1) && !"unnamed".equals(name2) ? -1 : 0);
                if (result == 0) {
                    int n2 = "first".equals(name1) && !"first".equals(name2) ? 1 : (result = !"first".equals(name1) && "first".equals(name2) ? -1 : 0);
                }
                if (result == 0) {
                    int n3 = "left".equals(name1) && !"left".equals(name2) ? 1 : (result = !"left".equals(name1) && "left".equals(name2) ? -1 : 0);
                }
                if (result == 0) {
                    int n4 = "right".equals(name1) && !"right".equals(name2) ? 1 : (result = !"right".equals(name1) && "right".equals(name2) ? -1 : 0);
                }
                if (result == 0) {
                    result = rule1.getPosition() - rule2.getPosition();
                }
                return result;
            }
        });
        return pageRules;
    }

    private static PageRule[] splitPageRules(List pageRules) {
        ArrayList<PageRule> result = new ArrayList<PageRule>();
        Iterator i = pageRules.iterator();
        while (i.hasNext()) {
            PageRule[] split = ((PageRule)i.next()).split();
            for (int j = 0; j < split.length; ++j) {
                result.add(split[j]);
            }
        }
        return result.toArray(new PageRule[0]);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "css", "xmlns:css", "CDATA", Constants.CSS);
        atts.addAttribute("", "xh", "xmlns:xh", "CDATA", Constants.XHTML);
        atts.addAttribute("", "sp", "xmlns:sp", "CDATA", Constants.SPECIF);
        super.startElement(Constants.CSS, "root", "css:root", atts);
        this.getParent().setContentHandler(new Recorder());
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String display = atts.getValue(Constants.CSS, "display");
        Element element = new Element(namespaceURI, localName, qName, atts);
        Element parent = this.elements.isEmpty() ? null : (Element)this.elements.peek();
        element.inBodyRegion = parent != null && parent.inBodyRegion || "body".equals(atts.getValue(Constants.CSS, "region"));
        element.inTable = parent != null && parent.inTable || "table".equals(display);
        if (element.inBodyRegion && (parent == null || !parent.inTable && (element.inTable || "block".equals(display)))) {
            boolean newPage;
            int span = element.atts.getIndex(Constants.CSS, "column-span");
            if (span != -1) {
                element.span = "all".equals(element.atts.getValue(span));
                element.atts.removeAttribute(span);
            }
            element.pageName = atts.getValue(Constants.CSS, "page");
            if ("auto".equals(element.pageName)) {
                element.pageName = null;
            }
            if (element.pageName == null && parent != null) {
                element.pageName = parent.pageName;
            }
            if (element.pageName == null) {
                element.pageName = "unnamed";
            }
            boolean bl = newPage = parent == null || !element.pageName.equals(parent.pageName);
            if (newPage || element.span) {
                boolean closed = this.closeElementsInBodyRegion();
                if (newPage) {
                    if (parent != null && parent.pageName != null) {
                        super.endElement(Constants.CSS, "page-sequence", "css:page-sequence");
                    } else {
                        this.generateRegions(this.applyPageRules());
                    }
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute(Constants.CSS, "page", "css:page", "CDATA", element.pageName);
                    super.startElement(Constants.CSS, "page-sequence", "css:page-sequence", attributes);
                }
                if (closed) {
                    this.reopenElementsInBodyRegion(element.span);
                }
                if (parent != null) {
                    parent.pageName = element.pageName;
                }
            }
        } else if (parent != null) {
            element.pageName = parent.pageName;
        }
        if (element.inBodyRegion) {
            super.startElement(namespaceURI, localName, qName, element.atts);
        }
        this.elements.push(element);
    }

    private static String stripPseudoPrefix(String pageName) {
        for (int i = 0; i < prefixes.length; ++i) {
            if (!pageName.startsWith(prefixes[i])) continue;
            return pageName.substring(prefixes[i].length());
        }
        return pageName;
    }

    private class Recorder
    extends XMLFilterImpl {
        private List events = new ArrayList();
        private Stack elements = new Stack();

        private Recorder() {
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.elements.pop();
            this.events.add(new Event(namespaceURI, localName, qName, null));
        }

        private void replayEvents() throws SAXException {
            for (int i = 0; i < this.events.size(); ++i) {
                Event event = (Event)this.events.get(i);
                if (event.atts != null) {
                    PageSetupFilter.this.startElement(event.namespaceURI, event.localName, event.qName, event.atts);
                    continue;
                }
                PageSetupFilter.this.endElement(event.namespaceURI, event.localName, event.qName);
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.events.add(new Event(namespaceURI, localName, qName, atts));
            if (!this.elements.isEmpty() && ((Element)this.elements.peek()).inBodyRegion) {
                this.replayEvents();
                PageSetupFilter.this.getParent().setContentHandler(PageSetupFilter.this);
            } else {
                Element element = new Element(namespaceURI, localName, qName, atts);
                element.inBodyRegion = "body".equals(atts.getValue(Constants.CSS, "region"));
                this.elements.push(element);
            }
        }

        private class Event {
            private Attributes atts;
            private String localName;
            private String namespaceURI;
            private String qName;

            private Event(String namespaceURI, String localName, String qName, Attributes atts) {
                this.namespaceURI = namespaceURI;
                this.localName = localName;
                this.qName = qName;
                this.atts = atts == null ? null : new AttributesImpl(atts);
            }
        }
    }

    private static class Element {
        private AttributesImpl atts;
        private boolean inBodyRegion;
        private boolean inTable;
        private String localName;
        private String namespaceURI;
        private String pageName;
        private String qName;
        private boolean span;

        private Element(String namespaceURI, String localName, String qName, Attributes atts) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.qName = qName;
            this.atts = new AttributesImpl(atts);
        }
    }
}

