/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Constants;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class LinkFilter
extends XMLFilterImpl {
    private static final int EXTERNAL_LINK = 0;
    private static final int INTERNAL_LINK = 1;
    private static final int NO_LINK = 2;
    private URL baseUrl;
    private Stack stack = new Stack();

    LinkFilter(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    LinkFilter(URL baseUrl, XMLReader parent) {
        super(parent);
        this.baseUrl = baseUrl;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        int linkType = (Integer)this.stack.pop();
        if (linkType != 2) {
            String name = linkType == 1 ? "internal-link" : "external-link";
            super.endElement(Constants.CSS, name, "css:" + name);
        }
    }

    private static boolean isUrl(URL baseUrl, String target) {
        try {
            new URL(baseUrl != null ? baseUrl : new URL("file:///nowhere"), target);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    void setBaseUrl(URL url) {
        this.baseUrl = url;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String link = atts.getValue(Constants.CSS, "link");
        if (link != null) {
            atts = new AttributesImpl(atts);
            ((AttributesImpl)atts).removeAttribute(atts.getIndex(Constants.CSS, "link"));
            String target = atts.getValue(link);
            if (!link.equals("none") && target != null) {
                AttributesImpl linkAtts = new AttributesImpl();
                int linkType = target.startsWith("#") || "IDREF".equals(atts.getType(link)) ? 1 : (LinkFilter.isUrl(this.baseUrl, target) ? 0 : 2);
                this.stack.push(new Integer(linkType));
                if (linkType != 2) {
                    try {
                        String name;
                        String string = name = linkType == 1 ? "internal-link" : "external-link";
                        linkAtts.addAttribute("", "target", "target", "CDATA", linkType == 1 ? target.substring(target.startsWith("#") ? 1 : 0) : (this.baseUrl != null ? new URL(this.baseUrl, target).toString() : target));
                        super.startElement(Constants.CSS, name, "css:" + name, linkAtts);
                    }
                    catch (MalformedURLException e) {
                        throw new SAXException(e);
                    }
                }
            } else {
                this.stack.push(new Integer(2));
            }
        } else {
            this.stack.push(new Integer(2));
        }
        super.startElement(namespaceURI, localName, qName, atts);
    }
}

