/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Constants;
import be.re.xml.Accumulator;
import be.re.xml.DOMToContentHandler;
import java.util.Stack;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class FootnoteFilter
extends XMLFilterImpl {
    private Element footnoteReference = null;
    private Stack stack = new Stack();

    FootnoteFilter() {
    }

    FootnoteFilter(XMLReader parent) {
        super(parent);
    }

    private void accumulateFootnoteReference(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Accumulator.preAccumulate(namespaceURI, localName, qName, atts, this, new Accumulator.ProcessElement(){

            public void process(Element element, XMLFilter filter) throws SAXException {
                FootnoteFilter.this.footnoteReference = element;
            }
        });
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.flushFootnoteReference();
        super.characters(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.flushFootnoteReference();
        super.endElement(namespaceURI, localName, qName);
        if (((Boolean)this.stack.pop()).booleanValue()) {
            super.endElement(Constants.CSS, "footnote-body", "css:footnote-body");
            super.endElement(Constants.CSS, "footnote", "css:footnote");
        }
    }

    private void flushFootnoteReference() throws SAXException {
        if (this.footnoteReference != null && this.getContentHandler() != null) {
            this.footnoteReference.setAttributeNS(Constants.CSS, "css:display", "inline");
            DOMToContentHandler.elementToContentHandler(this.footnoteReference, this.getContentHandler());
            this.footnoteReference = null;
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String display = atts.getValue(Constants.CSS, "display");
        boolean extra = false;
        if ("footnote-reference".equals(display)) {
            this.flushFootnoteReference();
            this.accumulateFootnoteReference(namespaceURI, localName, qName, atts);
        } else {
            if ("footnote-body".equals(display)) {
                atts = new AttributesImpl(atts);
                if (this.footnoteReference == null) {
                    ((AttributesImpl)atts).setValue(atts.getIndex(Constants.CSS, "display"), "none");
                } else {
                    super.startElement(Constants.CSS, "footnote", "css:footnote", new AttributesImpl());
                    super.startElement(Constants.CSS, "footnote-reference", "css:footnote-reference", new AttributesImpl());
                    this.flushFootnoteReference();
                    super.endElement(Constants.CSS, "footnote-reference", "css:footnote-reference");
                    super.startElement(Constants.CSS, "footnote-body", "css:footnote-body", new AttributesImpl());
                    ((AttributesImpl)atts).setValue(atts.getIndex(Constants.CSS, "display"), "block");
                    extra = true;
                }
            } else {
                this.flushFootnoteReference();
            }
            super.startElement(namespaceURI, localName, qName, atts);
            this.stack.push(new Boolean(extra));
        }
    }
}

