/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.CSSToXSLFOException;
import be.re.css.Context;
import be.re.css.FOMarkerFilter;
import be.re.css.PageSetupFilter;
import be.re.css.ProjectorFilter;
import be.re.css.SpaceCorrectionFilter;
import be.re.css.Util;
import be.re.xml.sax.FilterOfFilters;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class CSSToXSLFOFilter
extends XMLFilterImpl {
    private XMLFilter filter;
    private PageSetupFilter pageSetupFilter;
    private Util.PostProjectionFilter postProjectionFilter;
    private ProjectorFilter projectorFilter;
    private static Templates templates = CSSToXSLFOFilter.loadStyleSheet();
    private Map userAgentParameters;
    static /* synthetic */ Class class$be$re$css$CSSToXSLFOFilter;

    public CSSToXSLFOFilter() throws CSSToXSLFOException {
        this(null, null, new HashMap(), false);
    }

    public CSSToXSLFOFilter(URL baseUrl) throws CSSToXSLFOException {
        this(baseUrl, null, new HashMap(), false);
    }

    public CSSToXSLFOFilter(URL baseUrl, URL userAgentStyleSheet) throws CSSToXSLFOException {
        this(baseUrl, userAgentStyleSheet, new HashMap(), false);
    }

    public CSSToXSLFOFilter(URL baseUrl, URL userAgentStyleSheet, Map userAgentParameters) throws CSSToXSLFOException {
        this(baseUrl, userAgentStyleSheet, userAgentParameters, false);
    }

    public CSSToXSLFOFilter(URL baseUrl, URL userAgentStyleSheet, Map userAgentParameters, boolean debug) throws CSSToXSLFOException {
        this.userAgentParameters = userAgentParameters != null ? userAgentParameters : new HashMap();
        try {
            Context context = new Context();
            this.projectorFilter = new ProjectorFilter(baseUrl, userAgentStyleSheet, userAgentParameters, context);
            this.postProjectionFilter = Util.createPostProjectionFilter(baseUrl, userAgentParameters, debug);
            this.pageSetupFilter = new PageSetupFilter(context, baseUrl, userAgentParameters, debug);
            this.filter = new FilterOfFilters(new XMLFilter[]{this.projectorFilter, new FOMarkerFilter(), this.postProjectionFilter.getFilter(), this.pageSetupFilter, this.newTemplatesFilter(), new SpaceCorrectionFilter()}, debug);
        }
        catch (Exception e) {
            throw new CSSToXSLFOException(e);
        }
    }

    public CSSToXSLFOFilter(XMLReader parent) throws CSSToXSLFOException {
        this(null, null, new HashMap(), parent, false);
    }

    public CSSToXSLFOFilter(URL baseUrl, XMLReader parent) throws CSSToXSLFOException {
        this(baseUrl, null, new HashMap(), parent, false);
    }

    public CSSToXSLFOFilter(URL baseUrl, URL userAgentStyleSheet, XMLReader parent) throws CSSToXSLFOException {
        this(baseUrl, userAgentStyleSheet, new HashMap(), parent, false);
    }

    public CSSToXSLFOFilter(URL baseUrl, URL userAgentStyleSheet, Map userAgentParameters, XMLReader parent) throws CSSToXSLFOException {
        this(baseUrl, userAgentStyleSheet, userAgentParameters, parent, false);
    }

    public CSSToXSLFOFilter(URL baseUrl, URL userAgentStyleSheet, Map userAgentParameters, XMLReader parent, boolean debug) throws CSSToXSLFOException {
        this(baseUrl, userAgentStyleSheet, userAgentParameters, debug);
        this.setParent(parent);
    }

    public URL getBaseUrl() {
        return this.projectorFilter.getBaseUrl();
    }

    public Map getParameters() {
        return this.userAgentParameters;
    }

    public URL getUserAgentStyleSheet() {
        return this.projectorFilter.getUserAgentStyleSheet();
    }

    private static Templates loadStyleSheet() {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setURIResolver(new URIResolver(){

                public Source resolve(String href, String base) {
                    try {
                        return new StreamSource(base != null && be.re.net.Util.isUrl(base) ? new URL(new URL(base), href).toString() : new URL((class$be$re$css$CSSToXSLFOFilter == null ? (class$be$re$css$CSSToXSLFOFilter = CSSToXSLFOFilter.class$("be.re.css.CSSToXSLFOFilter")) : class$be$re$css$CSSToXSLFOFilter).getResource("css.xsl"), href).toString());
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            return factory.newTemplates(new StreamSource((class$be$re$css$CSSToXSLFOFilter == null ? (class$be$re$css$CSSToXSLFOFilter = CSSToXSLFOFilter.class$("be.re.css.CSSToXSLFOFilter")) : class$be$re$css$CSSToXSLFOFilter).getResource("css.xsl").toString()));
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private XMLFilter newTemplatesFilter() throws Exception {
        if (!"net.sf.saxon.PreparedStylesheet".equals(templates.getClass().getName())) {
            return be.re.xml.sax.Util.newSAXTransformerFactory().newXMLFilter(new ParameterizableTemplate(templates));
        }
        XMLFilter result = be.re.xml.sax.Util.newSAXTransformerFactory().newXMLFilter(templates);
        if (this.userAgentParameters != null) {
            CSSToXSLFOFilter.setTransformerParameters((Transformer)result.getClass().getMethod("getTransformer", new Class[0]).invoke((Object)result, new Object[0]), this.userAgentParameters);
        }
        return result;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        if (this.getBaseUrl() == null && input.getSystemId() != null) {
            this.setBaseUrl(new URL(input.getSystemId()));
        }
        this.setupParse();
        this.filter.parse(input);
    }

    public void parse(String systemId) throws IOException, SAXException {
        if (this.getBaseUrl() == null && systemId != null) {
            this.setBaseUrl(new URL(systemId));
        }
        this.setupParse();
        this.filter.parse(systemId);
    }

    public void setBaseUrl(URL baseUrl) {
        this.projectorFilter.setBaseUrl(baseUrl);
        this.pageSetupFilter.setBaseUrl(baseUrl);
        this.postProjectionFilter.setBaseUrl(baseUrl);
    }

    public void setParameters(Map userAgentParameters) {
        this.userAgentParameters = userAgentParameters;
    }

    public void setParent(XMLReader parent) {
        super.setParent(parent);
        this.projectorFilter.setParent(parent);
    }

    private static void setTransformerParameters(Transformer transformer, Map parameters) {
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            transformer.setParameter((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setUserAgentStyleSheet(URL userAgentStyleSheet) {
        this.projectorFilter.setUserAgentStyleSheet(userAgentStyleSheet);
    }

    private void setupParse() {
        this.filter.setContentHandler(this);
        this.filter.setDTDHandler(this);
        this.filter.setEntityResolver(this);
        this.filter.setErrorHandler(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ParameterizableTemplate
    implements Templates {
        private Templates delegate;

        private ParameterizableTemplate(Templates delegate) {
            this.delegate = delegate;
        }

        public Properties getOutputProperties() {
            return this.delegate.getOutputProperties();
        }

        public Transformer newTransformer() throws TransformerConfigurationException {
            Transformer transformer = this.delegate.newTransformer();
            if (CSSToXSLFOFilter.this.userAgentParameters != null) {
                CSSToXSLFOFilter.setTransformerParameters(transformer, CSSToXSLFOFilter.this.userAgentParameters);
            }
            return transformer;
        }
    }
}

