#ifndef ZEERECIPEEDITWINDOW_H
#define ZEERECIPEEDITWINDOW_H

#include "zeemodalwindow.h"

class ZeeCategoryListView;
class ZeeIngredientListView;

class QComboBox;
class QLineEdit;
class QMultiLineEdit;
class QTabWidget;
class QToolButton;

class ZeeRecipeEditWindow : public ZeeModalWindow
{
    Q_OBJECT

public:
    ZeeRecipeEditWindow(int recipeId, QWidget* parent = 0, const char* name = 0);
    ~ZeeRecipeEditWindow();

    void closeEvent(QCloseEvent* e);

    void updateView(bool needDatabaseUpdate = true);
    void updateDatabase();

private slots:
    void addCategory();
    void editCategory();
    void removeCategory();
    void moveCategoryUp();
    void moveCategoryDown();

    void selectCategory();

    void addIngredient();
    void editIngredient();
    void removeIngredient();
    void moveIngredientUp();
    void moveIngredientDown();

    void selectIngredient();

private:
    int m_recipeId;

    QTabWidget* m_pTabWidget;

    QWidget* m_pGeneralTab;
    QWidget* m_pIngredientTab;
    QWidget* m_pDirectionTab;
    
    QLineEdit* m_pNameLineEdit;
    QLineEdit* m_pYieldQuantityLineEdit;
    QComboBox* m_pYieldUnitComboBox;

    QToolButton* m_pAddCategoryButton;
    QToolButton* m_pEditCategoryButton;
    QToolButton* m_pRemoveCategoryButton;
    QToolButton* m_pMoveCategoryUpButton;
    QToolButton* m_pMoveCategoryDownButton;

    ZeeCategoryListView* m_pCategoryListView;

    QToolButton* m_pAddIngredientButton;
    QToolButton* m_pEditIngredientButton;
    QToolButton* m_pRemoveIngredientButton;
    QToolButton* m_pMoveIngredientUpButton;
    QToolButton* m_pMoveIngredientDownButton;

    ZeeIngredientListView* m_pIngredientListView;

    QMultiLineEdit* m_pDirectionMultiLineEdit;
};

#endif // ZEERECIPEEDITWINDOW_H
