#include "zeeopendialog.h"

#include "zeecookbooklistview.h"

#include <qpe/applnk.h>

#include <qlayout.h>

ZeeOpenDialog::ZeeOpenDialog(QWidget* parent, const char* name)
    : QDialog(parent, name, true)
{
    setCaption(tr("Zee Cookbook - Open Cookbook"));

    m_pCookbookListView = new ZeeCookbookListView("application/zeecookbook", this);

    QVBoxLayout* mainLayout = new QVBoxLayout(this, 4, 4);
    mainLayout->addWidget(m_pCookbookListView);
    
    updateView();
}

ZeeOpenDialog::~ZeeOpenDialog()
{
}

void ZeeOpenDialog::updateView()
{
    blockSignals(true);
    
    blockSignals(false);
}

void ZeeOpenDialog::select(DocLnk* docLnk)
{
    m_pCookbookListView->select(docLnk);
}

DocLnk* ZeeOpenDialog::selected() const
{
    return m_pCookbookListView->selected();
}
