#ifndef ZEEMEALMASTERIMPORTER_H
#define ZEEMEALMASTERIMPORTER_H

#include "zeeimporter.h"

class ZeeMealMasterImporter : public ZeeImporter
{
public:
    ZeeMealMasterImporter();
    ~ZeeMealMasterImporter();

    QString name() const;
    QString mimeType() const;
    int totalSteps(QTextStream& textStream) const;

    void importRecipeList(QTextStream& textStream);

private:
    enum State {
        Unknown,
        InRecipe,
        InRecipeTitle,
        InRecipeCategory,
        InRecipeYield,
        InRecipeIngredient,
        InRecipeDirection
    };
    
    State state;
    int recipeId;
    QStringList directionList;

    QString line;

    QRegExp emptyRegExp;
    QRegExp headerRegExp1;
    QRegExp headerRegExp2;
    QRegExp titleRegExp;
    QRegExp categoryRegExp;
    QRegExp yieldRegExp1;
    QRegExp yieldRegExp2;
    QRegExp yieldQuantityRegExp;
    QRegExp ingredientRegExp1;
    QRegExp ingredientRegExp2;
    QRegExp ingredientGroupRegExp1;
    QRegExp ingredientGroupRegExp2;
    QRegExp trailerRegExp1;
    QRegExp trailerRegExp2;

    void readHeaderLine();
    void readTitleLine();
    void readCategoryLine();
    void readYieldLine();
    void readIngredientLine();
    void addIngredient(QString quantity, QString unitName, QString ingredientName);
    void readDirectionLine();
    void readTrailerLine();
};

#endif // ZEEMEALMASTERIMPORTER_H
