#include "zeelineeditdialog.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>

ZeeLineEditDialog::ZeeLineEditDialog(QString text, QString value, QWidget* parent, const char* name)
    : QDialog(parent, name, true)
{
    QLabel* textLabel = new QLabel(text, this);

    m_pLineEdit = new QLineEdit(this);
    m_pLineEdit->setText(value);
    connect(m_pLineEdit, SIGNAL(returnPressed()), this, SLOT(accept()));

    QVBoxLayout* mainLayout = new QVBoxLayout(this, 4, 4);

    mainLayout->addWidget(textLabel);
    mainLayout->addWidget(m_pLineEdit);
}

ZeeLineEditDialog::~ZeeLineEditDialog()
{
}

QString ZeeLineEditDialog::selected() const
{
    return m_pLineEdit->text();
}
