#ifndef ZEEINGREDIENTLISTVIEW_H
#define ZEEINGREDIENTLISTVIEW_H

#include "zeelistview.h"

class ZeeIngredientListViewItem : public QListViewItem
{
public:
    ZeeIngredientListViewItem(int recipeIngredientId, QString key, QString quantity, QString unit, QString name, bool isGroup, QListView* parent);
    ~ZeeIngredientListViewItem();

    int recipeIngredientId() const;
    
    QString key(int column, bool ascending) const;
    void paintCell(QPainter* p, const QColorGroup& cg, int column, int width, int align);

private:
    int m_recipeIngredientId;
    QString m_key;
    bool m_isGroup;
};

class ZeeIngredientListView : public ZeeListView
{
public:
    ZeeIngredientListView(int recipeId, QWidget* parent = 0, const char* name = 0);
    ~ZeeIngredientListView();

    void updateView();

    void select(int recipeIngredientId);
    int selected() const;

private:
    int m_recipeId;
};

#endif // ZEEINGREDIENTLISTVIEW_H
