#ifndef ZEEEXPORTDIALOG_H
#define ZEEEXPORTDIALOG_H

#include <qdialog.h>

class QComboBox;
class QLineEdit;
class QRadioButton;

class ZeeExportDialog : public QDialog
{
    Q_OBJECT

public:
    enum Selection {
        Current,
        Display,
        All
    };

    ZeeExportDialog(bool hasRecipe, bool isRecipeSelected, QWidget* parent = 0, const char* name = 0);
    ~ZeeExportDialog();

    void updateView();

    Selection selected();
    QString selectedName();
    QString selectedFormat();

private slots:
    void selectCurrent();
    void selectDisplay();
    void selectAll();

private:
    Selection m_selection;

    QRadioButton* m_pCurrentRadioButton;
    QRadioButton* m_pDisplayRadioButton;
    QRadioButton* m_pAllRadioButton;

    QLineEdit* m_pNameLineEdit;
    QComboBox* m_pFormatComboBox;
};

#endif // ZEEEXPORTDIALOG_H
