#include "zeecategoryeditdialog.h"

#include "sql/qsqlquery.h"

#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>

ZeeCategoryEditDialog::ZeeCategoryEditDialog(int recipeCategoryId, QWidget* parent, const char* name)
    : QDialog(parent, name, true)
{
    m_recipeCategoryId = recipeCategoryId;

    setCaption(tr("Edit Category"));

    QLabel* nameLabel = new QLabel(tr("Name:"), this);

    m_pNameComboBox = new QComboBox(true, this);
    m_pNameComboBox->setAutoCompletion(true);

    QHBoxLayout* mainLayout = new QHBoxLayout(this, 4, 4);

    mainLayout->addWidget(nameLabel);
    mainLayout->addWidget(m_pNameComboBox);

    updateView();
}

ZeeCategoryEditDialog::~ZeeCategoryEditDialog()
{
}

void ZeeCategoryEditDialog::updateView()
{
    blockSignals(true);

    QString queryString = "SELECT name FROM category ORDER BY name";
    QSqlQuery query(queryString);

    while (query.next()) {
        QString name = query.value(0).toString();
        m_pNameComboBox->insertItem(name);
    }

    QString categoryName = "";

    if (m_recipeCategoryId != -1) {
        queryString = "SELECT name FROM recipe_category, category";
        queryString += " WHERE recipe_category.id = %1 AND category_id = category.id";

        query.exec(queryString.arg(m_recipeCategoryId));

        if (query.first()) {
            categoryName = query.value(0).toString();
        }
    }

    m_pNameComboBox->setEditText(categoryName);

    blockSignals(false);
}

QString ZeeCategoryEditDialog::selected() const
{
    return m_pNameComboBox->currentText();
}
