/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public final class CCombo
extends Composite {
    Text text;
    List list;
    int visibleItemCount;
    Shell popup;
    Button arrow;
    boolean hasFocus;
    Listener listener;
    Listener filter;
    Color foreground;
    Color background;
    Font font;

    public CCombo(Composite composite, int n) {
        n = CCombo.checkStyle(n);
        super(composite, n);
        this.visibleItemCount = 5;
        int n2 = 4;
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        if ((n & 0x800000) != 0) {
            n2 |= 0x800000;
        }
        this.text = new Text(this, n2);
        int n3 = 1028;
        if ((n & 0x800000) != 0) {
            n3 |= 0x800000;
        }
        this.arrow = new Button(this, n3);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (CCombo.this.popup == event.widget) {
                    CCombo.this.popupEvent(event);
                    return;
                }
                if (CCombo.this.text == event.widget) {
                    CCombo.this.textEvent(event);
                    return;
                }
                if (CCombo.this.list == event.widget) {
                    CCombo.this.listEvent(event);
                    return;
                }
                if (CCombo.this.arrow == event.widget) {
                    CCombo.this.arrowEvent(event);
                    return;
                }
                if (CCombo.this == event.widget) {
                    CCombo.this.comboEvent(event);
                    return;
                }
                if (CCombo.this.getShell() == event.widget) {
                    CCombo.this.handleFocus(16);
                }
            }
        };
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == CCombo.this.getShell()) {
                    CCombo.this.handleFocus(16);
                }
            }
        };
        int[] nArray = new int[]{12, 10, 11};
        int n4 = 0;
        while (n4 < nArray.length) {
            this.addListener(nArray[n4], this.listener);
            ++n4;
        }
        int[] nArray2 = new int[]{1, 2, 35, 24, 3, 4, 31, 15, 25};
        int n5 = 0;
        while (n5 < nArray2.length) {
            this.text.addListener(nArray2[n5], this.listener);
            ++n5;
        }
        int[] nArray3 = new int[]{13, 15};
        int n6 = 0;
        while (n6 < nArray3.length) {
            this.arrow.addListener(nArray3[n6], this.listener);
            ++n6;
        }
        this.createPopup(null, -1);
        this.initAccessible();
    }

    static int checkStyle(int n) {
        int n2 = 0x6800808;
        return n & n2;
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.list.add(string);
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.list.add(string, n);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 13: {
                this.dropDown(!this.isDropped());
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
        this.list.deselectAll();
    }

    void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.list.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.text = null;
                this.list = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
            }
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        String[] stringArray = this.list.getItems();
        GC gC = new GC(this.text);
        int n5 = gC.stringExtent((String)" ").x;
        int n6 = gC.stringExtent((String)this.text.getText()).x;
        int n7 = 0;
        while (n7 < stringArray.length) {
            n6 = Math.max(gC.stringExtent((String)stringArray[n7]).x, n6);
            ++n7;
        }
        gC.dispose();
        Point point = this.text.computeSize(-1, -1, bl);
        Point point2 = this.arrow.computeSize(-1, -1, bl);
        Point point3 = this.list.computeSize(-1, -1, bl);
        int n8 = this.getBorderWidth();
        n4 = Math.max(point.y, point2.y);
        n3 = Math.max(n6 + 2 * n5 + point2.x + 2 * n8, point3.x);
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3 + 2 * n8, n4 + 2 * n8);
    }

    public void copy() {
        this.checkWidget();
        this.text.copy();
    }

    void createPopup(String[] stringArray, int n) {
        this.popup = new Shell(this.getShell(), 16392);
        int n2 = this.getStyle();
        int n3 = 516;
        if ((n2 & 0x800000) != 0) {
            n3 |= 0x800000;
        }
        if ((n2 & 0x4000000) != 0) {
            n3 |= 0x4000000;
        }
        if ((n2 & 0x2000000) != 0) {
            n3 |= 0x2000000;
        }
        this.list = new List(this.popup, n3);
        if (this.font != null) {
            this.list.setFont(this.font);
        }
        if (this.foreground != null) {
            this.list.setForeground(this.foreground);
        }
        if (this.background != null) {
            this.list.setBackground(this.background);
        }
        int[] nArray = new int[]{21, 9, 27};
        int n4 = 0;
        while (n4 < nArray.length) {
            this.popup.addListener(nArray[n4], this.listener);
            ++n4;
        }
        int[] nArray2 = new int[]{4, 13, 31, 1, 2, 15, 12};
        int n5 = 0;
        while (n5 < nArray2.length) {
            this.list.addListener(nArray2[n5], this.listener);
            ++n5;
        }
        if (stringArray != null) {
            this.list.setItems(stringArray);
        }
        if (n != -1) {
            this.list.setSelection(n);
        }
    }

    public void cut() {
        this.checkWidget();
        this.text.cut();
    }

    public void deselect(int n) {
        this.checkWidget();
        this.list.deselect(n);
    }

    public void deselectAll() {
        this.checkWidget();
        this.list.deselectAll();
    }

    void dropDown(boolean bl) {
        int n;
        String[] stringArray;
        if (bl == this.isDropped()) {
            return;
        }
        if (!bl) {
            this.popup.setVisible(false);
            if (!this.isDisposed() && this.arrow.isFocusControl()) {
                this.text.setFocus();
            }
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            stringArray = this.list.getItems();
            n = this.list.getSelectionIndex();
            this.list.removeListener(12, this.listener);
            this.popup.dispose();
            this.popup = null;
            this.list = null;
            this.createPopup(stringArray, n);
        }
        stringArray = this.getSize();
        n = this.list.getItemCount();
        n = n == 0 ? this.visibleItemCount : Math.min(this.visibleItemCount, n);
        int n2 = this.list.getItemHeight() * n;
        Point point = this.list.computeSize(-1, n2, false);
        this.list.setBounds(1, 1, Math.max(stringArray.x - 2, point.x), point.y);
        int n3 = this.list.getSelectionIndex();
        if (n3 != -1) {
            this.list.setTopIndex(n3);
        }
        Display display = this.getDisplay();
        Rectangle rectangle = this.list.getBounds();
        Rectangle rectangle2 = display.map((Control)this.getParent(), null, this.getBounds());
        Point point2 = this.getSize();
        Rectangle rectangle3 = this.getMonitor().getClientArea();
        int n4 = Math.max(point2.x, rectangle.width + 2);
        int n5 = rectangle.height + 2;
        int n6 = rectangle2.x;
        int n7 = rectangle2.y + point2.y;
        if (n7 + n5 > rectangle3.y + rectangle3.height) {
            n7 = rectangle2.y - n5;
        }
        if (n6 + n4 > rectangle3.x + rectangle3.width) {
            n6 = rectangle3.x + rectangle3.width - rectangle.width;
        }
        this.popup.setBounds(n6, n7, n4, n5);
        this.popup.setVisible(true);
        this.list.setFocus();
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return Character.toLowerCase(string.charAt(n));
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    Label getAssociatedLabel() {
        Control[] controlArray = this.getParent().getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] == this && n > 0 && controlArray[n - 1] instanceof Label) {
                return (Label)controlArray[n - 1];
            }
            ++n;
        }
        return null;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public String getItem(int n) {
        this.checkWidget();
        return this.list.getItem(n);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.list.getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.list.getItemHeight();
    }

    public String[] getItems() {
        this.checkWidget();
        return this.list.getItems();
    }

    public Menu getMenu() {
        return this.text.getMenu();
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.list.getSelectionIndex();
    }

    public int getStyle() {
        int n = super.getStyle();
        n &= 0xFFFFFFF7;
        if (!this.text.getEditable()) {
            n |= 8;
        }
        return n;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleItemCount;
    }

    void handleFocus(int n) {
        if (this.isDisposed()) {
            return;
        }
        switch (n) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event event = new Event();
                this.notifyListeners(15, event);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control control = this.getDisplay().getFocusControl();
                if (control == this.arrow || control == this.list || control == this.text) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event event = new Event();
                this.notifyListeners(16, event);
            }
        }
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return this.list.indexOf(string);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return this.list.indexOf(string, n);
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                String string = null;
                Label label = CCombo.this.getAssociatedLabel();
                if (label != null) {
                    string = CCombo.this.stripMnemonic(label.getText());
                }
                accessibleEvent.result = string;
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c;
                String string;
                String string2 = null;
                Label label = CCombo.this.getAssociatedLabel();
                if (label != null && (string = label.getText()) != null && (c = CCombo.this._findMnemonic(string)) != '\u0000') {
                    string2 = "Alt+" + c;
                }
                accessibleEvent.result = string2;
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = CCombo.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener(accessibleAdapter);
        this.text.getAccessible().addAccessibleListener(accessibleAdapter);
        this.list.getAccessible().addAccessibleListener(accessibleAdapter);
        this.arrow.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = CCombo.this.isDropped() ? SWT.getMessage("SWT_Close") : SWT.getMessage("SWT_Open");
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = "Alt+Down Arrow";
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = CCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleTextListener(new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent accessibleTextEvent) {
                accessibleTextEvent.offset = CCombo.this.text.getCaretPosition();
            }

            public void getSelectionRange(AccessibleTextEvent accessibleTextEvent) {
                Point point = CCombo.this.text.getSelection();
                accessibleTextEvent.offset = point.x;
                accessibleTextEvent.length = point.y - point.x;
            }
        });
        this.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = CCombo.this.toControl(accessibleControlEvent.x, accessibleControlEvent.y);
                if (CCombo.this.getBounds().contains(point)) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = CCombo.this.getBounds();
                Point point = CCombo.this.getParent().toDisplay(rectangle.x, rectangle.y);
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 46;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = CCombo.this.getText();
            }
        });
        this.text.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = CCombo.this.text.getEditable() ? 42 : 41;
            }
        });
        this.arrow.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = CCombo.this.isDropped() ? SWT.getMessage("SWT_Close") : SWT.getMessage("SWT_Open");
            }
        });
    }

    boolean isDropped() {
        return this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.text.isFocusControl() || this.arrow.isFocusControl() || this.list.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    void internalLayout(boolean bl) {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rectangle = this.getClientArea();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Point point = this.arrow.computeSize(-1, n2, bl);
        this.text.setBounds(0, 0, n - point.x, n2);
        this.arrow.setBounds(n - point.x, 0, point.x, point.y);
    }

    void listEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.getShell() == this.popup.getParent()) break;
                String[] stringArray = this.list.getItems();
                int n = this.list.getSelectionIndex();
                this.popup = null;
                this.list = null;
                this.createPopup(stringArray, n);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                break;
            }
            case 13: {
                int n = this.list.getSelectionIndex();
                if (n == -1) {
                    return;
                }
                this.text.setText(this.list.getItem(n));
                this.text.selectAll();
                this.list.setSelection(n);
                Event event2 = new Event();
                event2.time = event.time;
                event2.stateMask = event.stateMask;
                event2.doit = event.doit;
                this.notifyListeners(13, event2);
                event.doit = event2.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event event3 = new Event();
                event3.time = event.time;
                event3.detail = event.detail;
                event3.doit = event.doit;
                event3.character = event.character;
                event3.keyCode = event.keyCode;
                this.notifyListeners(31, event3);
                event.doit = event3.doit;
                event.detail = event3.detail;
                break;
            }
            case 2: {
                Event event4 = new Event();
                event4.time = event.time;
                event4.character = event.character;
                event4.keyCode = event.keyCode;
                event4.stateMask = event.stateMask;
                this.notifyListeners(2, event4);
                break;
            }
            case 1: {
                Event event5;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    event5 = new Event();
                    event5.time = event.time;
                    event5.stateMask = event.stateMask;
                    this.notifyListeners(14, event5);
                }
                if (this.isDisposed()) break;
                event5 = new Event();
                event5.time = event.time;
                event5.character = event.character;
                event5.keyCode = event.keyCode;
                event5.stateMask = event.stateMask;
                this.notifyListeners(1, event5);
            }
        }
    }

    public void paste() {
        this.checkWidget();
        this.text.paste();
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle rectangle = this.list.getBounds();
                Color color = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(color);
                event.gc.drawRectangle(0, 0, rectangle.width + 1, rectangle.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                if (!"carbon".equals(SWT.getPlatform())) {
                    Point point = this.arrow.toControl(this.getDisplay().getCursorLocation());
                    Point point2 = this.arrow.getSize();
                    Rectangle rectangle = new Rectangle(0, 0, point2.x, point2.y);
                    if (rectangle.contains(point)) break;
                    this.dropDown(false);
                    break;
                }
                this.dropDown(false);
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.text.redraw();
        this.arrow.redraw();
        if (this.popup.isVisible()) {
            this.list.redraw();
        }
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        super.redraw(n, n2, n3, n4, true);
    }

    public void remove(int n) {
        this.checkWidget();
        this.list.remove(n);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        this.list.remove(n, n2);
    }

    public void remove(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.list.remove(string);
    }

    public void removeAll() {
        this.checkWidget();
        this.text.setText("");
        this.list.removeAll();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n == -1) {
            this.list.deselectAll();
            this.text.setText("");
            return;
        }
        if (n >= 0 && n < this.list.getItemCount() && n != this.getSelectionIndex()) {
            this.text.setText(this.list.getItem(n));
            this.text.selectAll();
            this.list.select(n);
            this.list.showSelection();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.list != null) {
            this.list.setBackground(color);
        }
        if (this.arrow != null) {
            this.arrow.setBackground(color);
        }
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.text.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        if (this.text != null) {
            this.text.setEnabled(bl);
        }
        if (this.arrow != null) {
            this.arrow.setEnabled(bl);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        return this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.text.setFont(font);
        this.list.setFont(font);
        this.internalLayout(true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.list != null) {
            this.list.setForeground(color);
        }
        if (this.arrow != null) {
            this.arrow.setForeground(color);
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        this.list.setItem(n, string);
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        this.list.setItems(stringArray);
        if (!this.text.getEditable()) {
            this.text.setText("");
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMenu(Menu menu) {
        this.text.setMenu(menu);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.text.setSelection(point.x, point.y);
    }

    public void setText(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if ((n = this.list.indexOf(string)) == -1) {
            this.list.deselectAll();
            this.text.setText(string);
            return;
        }
        this.text.setText(string);
        this.text.selectAll();
        this.list.setSelection(n);
        this.list.showSelection();
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        this.text.setTextLimit(n);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.arrow.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.isDisposed()) {
            return;
        }
        if (!bl) {
            this.popup.setVisible(false);
        }
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleItemCount = n;
    }

    String stripMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return string;
            }
            if (string.charAt(n) != '&') {
                return String.valueOf(string.substring(0, n - 1)) + string.substring(n, n2);
            }
            if (++n >= n2) break;
        }
        return string;
    }

    void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 1: {
                Event event2 = new Event();
                event2.time = event.time;
                event2.character = event.character;
                event2.keyCode = event.keyCode;
                event2.stateMask = event.stateMask;
                this.notifyListeners(1, event2);
                if (this.isDisposed()) break;
                event.doit = event2.doit;
                if (!event.doit) break;
                if (event.character == '\r') {
                    this.dropDown(false);
                    Event event3 = new Event();
                    event3.time = event.time;
                    event3.stateMask = event.stateMask;
                    this.notifyListeners(14, event3);
                    if (this.isDisposed()) break;
                }
                if (event.keyCode != 0x1000001 && event.keyCode != 0x1000002) break;
                event.doit = false;
                if ((event.stateMask & 0x10000) != 0) {
                    boolean bl = this.isDropped();
                    this.text.selectAll();
                    if (!bl) {
                        this.setFocus();
                    }
                    this.dropDown(!bl);
                    break;
                }
                int n = this.getSelectionIndex();
                if (event.keyCode == 0x1000001) {
                    this.select(Math.max(n - 1, 0));
                } else {
                    this.select(Math.min(n + 1, this.getItemCount() - 1));
                }
                if (n != this.getSelectionIndex()) {
                    Event event4 = new Event();
                    event4.time = event.time;
                    event4.stateMask = event.stateMask;
                    this.notifyListeners(13, event4);
                }
                if (!this.isDisposed()) break;
                break;
            }
            case 2: {
                Event event5 = new Event();
                event5.time = event.time;
                event5.character = event.character;
                event5.keyCode = event.keyCode;
                event5.stateMask = event.stateMask;
                this.notifyListeners(2, event5);
                event.doit = event5.doit;
                break;
            }
            case 35: {
                Event event6 = new Event();
                event6.time = event.time;
                this.notifyListeners(35, event6);
                break;
            }
            case 24: {
                this.list.deselectAll();
                Event event7 = new Event();
                event7.time = event.time;
                this.notifyListeners(24, event7);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                boolean bl = this.isDropped();
                this.text.selectAll();
                if (!bl) {
                    this.setFocus();
                }
                this.dropDown(!bl);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                this.text.selectAll();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event event8 = new Event();
                event8.time = event.time;
                event8.detail = event.detail;
                event8.doit = event.doit;
                event8.character = event.character;
                event8.keyCode = event.keyCode;
                this.notifyListeners(31, event8);
                event.doit = event8.doit;
                event.detail = event8.detail;
                break;
            }
            case 25: {
                Event event9 = new Event();
                event9.text = event.text;
                event9.start = event.start;
                event9.end = event.end;
                event9.character = event.character;
                event9.keyCode = event.keyCode;
                event9.stateMask = event.stateMask;
                this.notifyListeners(25, event9);
                event.doit = event9.doit;
            }
        }
    }
}

