/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcClientAuth;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;

public class OncRpcClientAuthUnix
extends OncRpcClientAuth {
    private int stamp = (int)(System.currentTimeMillis() / (long)1000);
    private String machinename;
    private int uid;
    private int gid;
    private int[] gids;
    private byte[] shorthandCred;
    public static final int[] NO_GIDS = new int[0];

    public OncRpcClientAuthUnix(String machinename, int uid, int gid, int[] gids) {
        this.machinename = machinename;
        this.uid = uid;
        this.gid = gid;
        this.gids = gids;
    }

    public OncRpcClientAuthUnix(String machinename, int uid, int gid) {
        this(machinename, uid, gid, NO_GIDS);
    }

    protected void xdrEncodeCredVerf(XdrEncodingStream xdr) throws IOException, OncRpcException {
        if (this.shorthandCred == null) {
            if (this.gids.length > 16 || this.machinename.length() > 255) {
                throw new OncRpcAuthenticationException(7);
            }
            xdr.xdrEncodeInt(1);
            int len = 4 + (this.machinename.length() + 7 & 0xFFFFFFFC) + 4 + 4 + this.gids.length * 4 + 4;
            if (len > 400) {
                throw new OncRpcAuthenticationException(7);
            }
            xdr.xdrEncodeInt(len);
            xdr.xdrEncodeInt(this.stamp);
            xdr.xdrEncodeString(this.machinename);
            xdr.xdrEncodeInt(this.uid);
            xdr.xdrEncodeInt(this.gid);
            xdr.xdrEncodeIntVector(this.gids);
        } else {
            xdr.xdrEncodeInt(2);
            xdr.xdrEncodeDynamicOpaque(this.shorthandCred);
        }
        xdr.xdrEncodeInt(0);
        xdr.xdrEncodeInt(0);
    }

    protected void xdrDecodeVerf(XdrDecodingStream xdr) throws IOException, OncRpcException {
        switch (xdr.xdrDecodeInt()) {
            case 0: {
                if (xdr.xdrDecodeInt() == 0) break;
                throw new OncRpcAuthenticationException(7);
            }
            case 2: {
                this.shorthandCred = xdr.xdrDecodeDynamicOpaque();
                if (this.shorthandCred.length <= 400) break;
                throw new OncRpcAuthenticationException(7);
            }
            default: {
                throw new OncRpcAuthenticationException(6);
            }
        }
    }

    protected boolean canRefreshCred() {
        if (this.shorthandCred == null) {
            return false;
        }
        this.shorthandCred = null;
        this.stamp = (int)(System.currentTimeMillis() / (long)1000);
        return true;
    }

    public void setStamp(int stamp) {
        this.stamp = stamp;
    }

    public int getStamp() {
        return this.stamp;
    }

    public void setMachinename(String machinename) {
        this.machinename = machinename;
    }

    public String getMachinename() {
        return this.machinename;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public int getUid() {
        return this.uid;
    }

    public void setGid(int gid) {
        this.gid = gid;
    }

    public int getGid() {
        return this.gid;
    }

    public void setGids(int[] gids) {
        this.gids = gids;
    }

    public int[] getGids() {
        return this.gids;
    }
}

