#!/usr/bin/env python

###
# Purpose: Python script to generate SoftGL raster functions
#
# Note: Using this script is only necessary when using the
#       old rasterizer...
#
# Authors: Daniel Wagner, Tamer Fahmy
# Date: 2003-09-05, Vienna
#

import sys

zwrite_list = (("ZWRITE_OFF", ""), 
               ("ZWRITE_ON",  "_ZW"))

ztest_list = (("ZTEST_LESS"     , "_ZTl"),
#              ("ZTEST_LEQUAL"   , "_ZTle"),
#              ("ZTEST_EQUAL"    , "_ZTe"),
              ("ZTEST_GREATER"  , "_ZTg"),
#              ("ZTEST_NOTEQUAL" , "_ZTne"),
#              ("ZTEST_GEQUAL"   , "_ZTge"),
              ("ZTEST_ALWAYS"   , "_ZTa"))

color_list = (("COLOR_OFF"        , ""),
              ("COLOR_FLAT"       , "_Cf"),
              ("COLOR_GOURAUD"    , "_Cg"),
              ("COLOR_TEX"        , "_Ct"),
              ("COLOR_TEXFLAT"    , "_Ctf"),
              ("COLOR_TEXGOURAUD" , "_Ctg"))

fog_list = (("FOG_OFF" , ""),
            ("FOG_ON"  , "_F"))

blend_list = (("BLEND_OFF"             , ""),
              ("BLEND_ADD"             , "_Badd"),
              ("BLEND_ADDHALF"         , "_Baddh"),
              ("BLEND_ALPHA_VERTEX"    , "_Bav"),
              ("BLEND_ALPHA_TEX"       , "_Bat"),
              ("BLEND_ALPHA_TEXVERTEX" , "_Batv"))


def main():
    spanFuncs_list = []
    spanDefine_list = []

    fd = open("../klimt/src/RasterizerSW565.old/klRasterizerSW565_FuncTable.h", 'w')
    #fd = sys.stdout
    
    for blend in blend_list:
        for fog in fog_list:
            for color in color_list:
                for ztest in ztest_list:
                    for zwrite in zwrite_list:
                        if color[0]=="COLOR_OFF" and (zwrite[0]=="ZWRITE_OFF" or fog[0]!="FOG_OFF" or blend[0]!="BLEND_OFF"):   # removes 161 cases where nothing is done anyhow
                            continue
                        if (color[0]=="COLOR_OFF" or color[0]=="COLOR_FLAT" or color[0]=="COLOR_GOURAUD") and \
                    	   (blend[0]=="BLEND_ALPHA_TEX" or blend[0]=="BLEND_ALPHA_TEXVERTEX"):                                  # removes 112 non working cases
                            continue

                        func_name = "DrawScanLine" + zwrite[1] + ztest[1] + color[1] + fog[1] + blend[1]
                        spanDefine_list.append("#define SPAN_" + zwrite[0] + "\n" +
                                               "#define SPAN_" + ztest[0] + "\n" +
                                               "#define SPAN_" + color[0] + "\n" +
                                               "#define SPAN_" + fog[0] + "\n" +
                                               "#define SPAN_" + blend[0] + "\n" +
                                               "#define SPAN_FUNCTION_NAME " + func_name + "\n" +
                                               '#include "klRasterizerSW565_FuncImpl.h"' + "\n\n")
                        spanFuncs_list.append("setSpanFunc(" +
                                              "RASTER_"+zwrite[0] + "," +
                                              "RASTER_"+ztest[0] + "," +
                                              "RASTER_"+color[0] + "," +
                                              "RASTER_"+fog[0] + "," +
                                              "RASTER_"+blend[0] + ", " +
                                              "&klRasterizerSW565::" + func_name + ");\n")

    print >>fd, "/********************************************************************\\"
    print >>fd, " *                                                                  * "
    print >>fd, " *           This file is autogenerated. Do no edit.                * "
    print >>fd, " *                                                                  * "
    print >>fd, " *  Use GenerateRasterFuncs.py to create new versions of this file  * "
    print >>fd, " *                                                                  * "
    print >>fd, "\\********************************************************************/\n"
    print >>fd, "// fill the spanfunc list with\n// "+str(len(spanFuncs_list))+" functions as defined below"
    print >>fd, "void\ninitSpanFuncs()\n{"
    print >>fd, "\tfor(int i=0; i<NUM_SPANFUNCS; i++)\n\t\tspanFuncs[i] = NULL;\n"
    for func in spanFuncs_list:
        print >>fd, "\t" + func,
    print >>fd, "}\n"

    print >>fd, "// define " + str(len(spanDefine_list)) + " different scanline functions\n//"
    for define in spanDefine_list:
        print >>fd, define,
                        
    fd.close()

if __name__ == '__main__':
    main()
