

#include "teapot.h"
#include "resource.h"

#include <pocketKnife/FileTool.h>
#include <pocketKnife/CEUtil.h>

#include <gl/gl.h>
#include <gl/glu.h>
#include <glut.h>


using namespace IMS;


int                                                                                           
WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
{
	teapot app;

	if(!app.init(hInstance, nCmdShow))
		return FALSE;

	return (int)app.run();
}

static int cc=0;

teapot::teapot()
{
	f1 = f2 = 0.0f;

	f1+=cc*0.3f;
	f2+=cc*0.5f;

	useWireframe = false;
}


void
teapot::startup()
{
#ifdef _WIN32_WCE										// switch to fullscreen and
	::SHFullScreen(hWnd, SHFS_HIDESTARTICON);			// remove all buttons, bar, etc...
	::SHFullScreen(hWnd, SHFS_HIDESIPBUTTON);
	::SHFullScreen(hWnd, SHFS_HIDETASKBAR);
	::MoveWindow(hWnd, 0, 0, 240, 320, TRUE);
	::ShowWindow(hWnd, SW_SHOW);
	::UpdateWindow(hWnd);
#endif //_WIN32_WCE

	unsigned char* pixels = NULL;

	font = Font::load(IDB_FONT_6x8, 6);
	font->setTransparentColor(255,0,255);
	font2 = Font::load(IDB_FONT_8x12, 8);
	font2->setTransparentColor(255,0,255);

	klCreateDefaultContext();
	klSetBufferSize(320,240);

	// general setup
	//
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0f,(float)320/(float)240,0.5f,30.0f);

	glMatrixMode(GL_MODELVIEW);
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

	//glEnable(GL_NORMALIZE);

	glNewList(dplList, GL_COMPILE);
		renderTeapot();
	glEndList();

}


void
teapot::shutDown()
{
	this->Application::shutDown();
}


void
teapot::onButtonPressed(Input::BUTTON nButton)
{
	shutDown();
}


void
teapot::onStylusDown(int nX, int nY)
{
	if(nX<30 && nY>210)
		shutDown();
	else
		useWireframe = !useWireframe;
}


void
teapot::renderFrame()
{
	Image* bb = getBackBuffer();
	klSetColorBuffer(bb->getPixels());

	float mat[] = { 0.5f, 0.5f, 0.5f, 1.0f },
		  light0ColAmb[] = { 0.7f, 0.0f, 0.0f, 1.0f },
		  light0ColDif[] = { 1.0f, 0.5f, 0.5f, 1.0f },
		  light1ColAmb[] = { 0.0f, 0.7f, 0.0f, 1.0f },
		  light1ColDif[] = { 0.5f, 1.0f, 0.5f, 1.0f };
	float l0Pos[4] = {  1.0f,  1.0f, 1.0f, 0.0f },
		  l1Pos[4] = { -1.0f, -1.0f, 1.0f, 0.0f };

	//glNormal3f(200.0f, 100.0f, 100.0f);

	glClearColor(0.0f, 0.5f, 1.0f,0.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glLightfv(GL_LIGHT0, GL_POSITION, l0Pos);
	glLightfv(GL_LIGHT0, GL_AMBIENT, light0ColAmb);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, light0ColDif);

	glLightfv(GL_LIGHT1, GL_POSITION, l1Pos);
	glLightfv(GL_LIGHT1, GL_AMBIENT, light1ColAmb);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, light1ColDif);

	glMaterialfv(GL_FRONT, GL_DIFFUSE, mat);

	//glDisable(GL_DEPTH_TEST);							// Disable z-test
	//glDepthMask(GL_FALSE);

	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHT1);

	//glEnable(GL_TEXTURE_2D);
	//glBindTexture(GL_TEXTURE_2D, texNr);

	glCullFace(GL_BACK);
	//glShadeModel(GL_FLAT);
	glEnable(GL_CULL_FACE);

	glPolygonMode(GL_FRONT_AND_BACK, useWireframe ? GL_LINE: GL_FILL);

	glLoadIdentity();									// Reset The View
	glTranslatef(0.0f,0.0f,-15.0f);
	glRotatef(f1,1.0f,0.0f,0.0f);
	glRotatef(f2,0.0f,1.0f,0.0f);
	glTranslatef(0.0f,-1.5f,0.0f);
	glCallList(dplList);


	/*glLoadIdentity();									// Reset The Current Modelview Matrix
	glTranslatef(0.0f,0.0f,-5.0f);						// Move Right 1.5 Units And Into The Screen 7.0
	glRotatef(45.0f,0.5f,-0.5f,-0.5f);

	glDisable(GL_CULL_FACE);
	glDisable(GL_LIGHTING);

	glBegin(GL_QUADS);
		glColor4f(1.0f, 0.0f, 0.0f, 1.0f);  glVertex3f(-1.0f, -1.0f,  1.0f);
		glColor4f(0.0f, 1.0f, 0.0f, 0.5f);  glVertex3f( 1.0f, -1.0f,  1.0f);
		glColor4f(0.0f, 0.0f, 1.0f, 0.2f);  glVertex3f( 1.0f,  1.0f,  1.0f);
		glColor4f(1.0f, 1.0f, 0.0f, 0.7f);  glVertex3f(-1.0f,  1.0f,  1.0f);
	glEnd();*/



	/*glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

	glLoadIdentity();									// Reset The View
	glTranslatef(-5.0f,-1.0f,-23.0f);
	glRotatef(f2,0.0f,1.0f,0.0f);
	glCallList(dplList);

	glLoadIdentity();									// Reset The View
	glTranslatef( 5.0f,-1.0f,-23.0f);
	glRotatef(f2,0.0f,1.0f,0.0f);
	glCallList(dplList);*/


	float fps=getFPS();
	if(fps>0.0f)
	{
		float dt = 1.0f/fps;

		f1 += 20.0f*dt;
		f2 += 35.0f*dt;
	}

	//f1+=0.3f;
	//f2+=0.5f;
	//cc++;

	bb->drawTextEx(2, bb->getHeight()-font->getHeight()-2, font, true, "FPS: %.1f", fps);
}


#include "teapot_data.h"

void
teapot::renderTeapot()
{
	int face;

	glBegin(GL_TRIANGLES);

	for(face=0; face<numFaces; face++)
	//for(face=955; face<956; face++)
	{
		int vidx0 = faces[face][1],
			vidx1 = faces[face][2],
			vidx2 = faces[face][3],
			nidx0 = faces[face][4],
			nidx1 = faces[face][5],
			nidx2 = faces[face][6];

		glNormal3fv(normals[nidx0]);
		//glTexCoord2fv(normals[nidx0]);
		glVertex3fv(vertices[vidx0]);

		glNormal3fv(normals[nidx1]);
		//glTexCoord2fv(normals[nidx1]);
		glVertex3fv(vertices[vidx1]);

		glNormal3fv(normals[nidx2]);
		//glTexCoord2fv(normals[nidx2]);
		glVertex3fv(vertices[vidx2]);
	}

	glEnd();
}
