/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klEGLSurfaceNative.h,v 1.3 2004/01/13 14:40:28 tuhtah Exp $
 *
\**************************************************************************/


//
// select native surface classes
//

#ifdef _IS_WIN32_
  #include "Win32/klEGLSurfaceX86Window.h"					// x86 (desktop) windows, displays a 2x zoomed window
  typedef klEGLSurfaceX86Window klEGLSurfaceWindow;
#endif //_IS_WIN32_


#ifdef _IS_WINCE_
  #ifdef _USE_POCKETHAL_
    #include "WinCE/klEGLSurfacePocketHAL.h"				// use PocketHAL for video memory access under WindowsCE
    typedef klEGLSurfacePocketHAL klEGLSurfaceWindow;
  #else //!_USE_POCKETHAL_
    #include "WinCE/klEGLSurfaceGapi.h"						// use Gapi for video memory access under WindowsCE
    typedef klEGLSurfaceGapi klEGLSurfaceWindow;
  #endif //_USE_POCKETHAL_
#endif //_IS_WINCE_


#ifdef _IS_LINUX_
  	#ifdef _IS_QTEMBEDDED_
		#include "Linux/klEGLSurfaceQTE.h"
    	typedef klEGLSurfaceQTE klEGLSurfaceWindow;
    #elif defined(_IS_SDL_)
		#include "Linux/klEGLSurfaceSDL.h"
		typedef klEGLSurfaceSDL klEGLSurfaceWindow;
	#else
		ERROR: we do not have support for another window system in linux yet...
	#endif //_IS_SDL_
#endif //_IS_LINUX_
