/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klEGLSurfaceBuffer.cpp,v 1.3 2004/01/14 16:50:18 drgoldie Exp $
 *
\**************************************************************************/


#include "../include/klMain.h"
#include "klEGLSurfaceBuffer.h"


klEGLSurfaceBuffer::klEGLSurfaceBuffer()
{
	colorType = COLOR_TYPE_RGB565;
	depthType = DEPTH_TYPE_INT32;

	width = height = 0;
	cBuffer = NULL;
	zBuffer = NULL;
}


klEGLSurfaceBuffer::~klEGLSurfaceBuffer()
{
	destroy();
}


bool
klEGLSurfaceBuffer::setWindow(NativeWindowType /*nWnd*/)
{
	return true;
}


bool
klEGLSurfaceBuffer::setDisplay(NativeDisplayType /*nDisp*/)
{
	return true;
}


bool
klEGLSurfaceBuffer::destroy()
{
	bool ret = true;

	if(cBuffer)
		delete static_cast<unsigned short *>(cBuffer);
	cBuffer = NULL;

	if(zBuffer)
		delete static_cast<unsigned int *>(zBuffer);
	zBuffer = NULL;

	return ret;
}


void
klEGLSurfaceBuffer::setSize(int nWidth, int nHeight)
{
	if(width!=nWidth || height!=nHeight)
	{
		width = nWidth;
		height = nHeight;

		if(cBuffer)
			delete static_cast<unsigned short *>(cBuffer);
		cBuffer = new unsigned short[width*height];

		if(zBuffer)
			delete static_cast<unsigned short *>(zBuffer);
		zBuffer = new unsigned int[width*height];
	}
}


bool
klEGLSurfaceBuffer::flip()
{
	return true;
}
