/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klContext_oglTexture.h,v 1.4 2004/01/14 16:50:18 drgoldie Exp $
 *
\**************************************************************************/



/**
class klContext
{
*/


//
// This file holds all opengl functions that deal with
//
//                 texture setup
//

void glGenTextures(GLsizei n, GLuint *textures)
{
	for(int i=0,handle; i<n; i++)
	{
		if((handle = rasterizer->createTexture())!=-1)
			textures[i] = handle;
		else
		{
			// ERROR: no more textures storeable...
			break;
		}
	}
}


void glDeleteTextures(GLsizei n, const GLuint *textures)
{
	for(int i=0; i<n; i++)
	{
		//assertMessage(textures[nTextures[i]]!=NULL, "ERROR(glDeleteTextures): texture was not generated");
		rasterizer->destroyTexture(textures[n]);
	}
}


void glBindTexture(GLenum /*nTarget*/, GLuint nTexture)
{
	RECORD_DISPLAYLISTS1(BindTexture, nTexture)
	if(!displaylist.executeCommands)
		return;

	// ignore the target (we only support GL_TEXTURE_2D)
	rasterizer->setCurrentTexture(nTexture);
}


void glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params)
{
	if(target!=GL_TEXTURE_2D)
	{
		//report(reportMode, reportSelector, KL_REPORT_IMPORTANT, "glGetTexLevelParameteriv(): only 2D textures supported");
		return;
	}

	const klMipMapLevel_Info* info = rasterizer->getMipMapLevelInfo(level);
	if(!info)
	{
		// ERROR: texture not set or MM-level does not exist
		return;
	}

	switch(pname)
	{
	case GL_TEXTURE_WIDTH:
		*params = info->width;
		return;

	case GL_TEXTURE_HEIGHT:
		*params = info->height;
		return;

	case GL_TEXTURE_INTERNAL_FORMAT:
		*params = info->internalFormat;
		return;

	default:
		//report(reportMode, reportSelector, KL_REPORT_IMPORTANT, "glGetTexLevelParameteriv(): unsupported parameter");
		return;
	}
}


// does no color format/type conversion at the moment
// updateCurrentTexture() expects pixels to be in RGBA 32-bits!
//
void glTexImage2D(GLenum /*target*/, GLint level, GLint internalformat, GLsizei width, GLsizei height,
				  GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
	if(internalformat==4 && format==GL_RGBA && type==GL_UNSIGNED_BYTE)
	{
		RECORD_DISPLAYLISTS8(TexImage2D, level, internalformat, width, height, border, format, type, pixels)
		if(!displaylist.executeCommands)
			return;

		rasterizer->updateCurrentTexture(level, internalformat, width, height, border, format, type, pixels);
	}
	else
	{
		//
		// TODO: support more data formats to convert from and to...
		//
		int numSrcComps = getNumRGBComponents(internalformat);
		void* data = klImageConverter::convert(width, height, pixels, numSrcComps, format, type, 4, GL_RGBA, GL_UNSIGNED_BYTE);
		if(data)
		{
			RECORD_DISPLAYLISTS8(TexImage2D, level, internalformat, width, height, border, format, type, data)
			if(displaylist.executeCommands)
				rasterizer->updateCurrentTexture(level, internalformat, width, height, border, format, type, data);
			delete static_cast<unsigned char *>(data);
		}
	}
}


void glTexEnvi(GLenum /*target*/, GLenum /*pname*/, GLint param)
{
	RECORD_DISPLAYLISTS1(TexEnv, param)
	if(!displaylist.executeCommands)
		return;
		
	switch(param)
	{
	case GL_MODULATE:
	case GL_DECAL:
		textureApplyMode = param;
		break;

	case GL_BLEND:
	case GL_REPLACE:
		//report(reportMode, reportSelector, KL_REPORT_UNIMPORTANT, "glTexEnvf(): unsupported parameter for 'param'");
		break;
	}
}


void glTexEnvf(GLenum target, GLenum pname, GLfloat param)
{
	glTexEnvi(target, pname, (GLint)param);
}


void glTexEnvx(GLenum target, GLenum pname, GLfixed param)
{
	glTexEnvi(target, pname, (GLint)(param>>16));
}


/**
}  // class klContext
*/

