/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klContext_oglAttributeStack.h,v 1.1 2004/01/13 11:20:09 drgoldie Exp $
 *
\**************************************************************************/



/**
class klContext
{
*/


//
// This file holds all opengl functions that deal with
//
//                 Attribute Stacks
//

void glPushAttrib(GLbitfield mask)
{
	RECORD_DISPLAYLISTS1(PushAttrib, mask)
	if(!displaylist.executeCommands)
		return;

	int				i;
	klAttributes&	top = attributeStack.getTop();

	top.mask = mask;

	if(mask&GL_CURRENT_BIT)
	{
		top.currentColor = beginendState.currentColor;
		top.currentNormal = beginendState.currentNormal;
		top.currentTexCoord = beginendState.currentTexCoord;
	}

	if(mask&GL_POLYGON_BIT)
	{
		top.cullingEnabled = cullingEnabled;
		top.cullMode = cullMode;
		top.frontPolyMode = frontPolyMode;
		top.backPolyMode = backPolyMode;
		top.frontFace = frontFace;
	}

	if(mask&GL_LIGHTING_BIT)
	{
		top.colorMaterialEnabled = colorMaterialEnabled;
		top.materialFront = materialFront;
		top.materialBack = materialBack;
		top.lightModel = lightModel;
		for(i=0; i<MAX_LIGHTS; i++)
			top.lights[i] = lights[i];
	}

	if(mask&GL_FOG_BIT)
	{
		top.fog = fog;
	}

	if(mask&GL_DEPTH_BUFFER_BIT)
	{
		top.depthTestEnabled = depthTestEnabled;
		top.depthWriteEnabled = depthWriteEnabled;
		top.depthFunc = depthFunc;
		top.clearDepth = clearDepth;
	}

	if(mask&GL_TRANSFORM_BIT)
	{
		top.curStack = curStack;
		top.normalizeNormalsEnabled = normalizeNormalsEnabled;
	}

	if(mask&GL_ENABLE_BIT)
	{
		top.blend.enabled = blend.enabled;
		top.colorMaterialEnabled = colorMaterialEnabled;
		top.cullingEnabled = cullingEnabled;
		top.depthTestEnabled = depthTestEnabled;
		top.fog.enabled = fog.enabled;
		for(i=0; i<MAX_LIGHTS; i++)
			top.lights[i].enabled = lights[i].enabled;
		top.lightingEnabled = lightingEnabled;
		top.normalizeNormalsEnabled = normalizeNormalsEnabled;
		top.scissor.enabled = scissor.enabled;
		top.texturingEnabled = texturingEnabled;
	}

	if(mask&GL_COLOR_BUFFER_BIT)
	{
		top.blend = blend;
	}

	if(mask&GL_SCISSOR_BIT)
	{
		top.scissor = scissor;
	}


	// these attributes are not stored since we
	// don't support those features anyway...
	//
	//if(mask&GL_POINT_BIT)					{}
	//if(mask&GL_LINE_BIT)					{}
	//if(mask&GL_POLYGON_STIPPLE_BIT)		{}
	//if(mask&GL_PIXEL_MODE_BIT)			{}
	//if(mask&GL_ACCUM_BUFFER_BIT)			{}
	//if(mask&GL_STENCIL_BUFFER_BIT)		{}
	//if(mask&GL_VIEWPORT_BIT)				{}
	//if(mask&GL_HINT_BIT)					{}
	//if(mask&GL_LIST_BIT)					{}
	//if(mask&GL_EVAL_BIT)					{}
	//if(mask&GL_TEXTURE_BIT)				{}

	attributeStack.grow();
}


void glPopAttrib()
{
	RECORD_DISPLAYLISTS0(PopAttrib)
	if(!displaylist.executeCommands)
		return;

	attributeStack.pop();

	int					i;
	const klAttributes&	top = attributeStack.getTop();
	GLbitfield			mask = top.mask;

	if(mask&GL_CURRENT_BIT)
	{
		beginendState.currentColor = top.currentColor;
		beginendState.currentNormal = top.currentNormal;
		beginendState.currentTexCoord = top.currentTexCoord;
	}

	if(mask&GL_POLYGON_BIT)
	{
		cullingEnabled = top.cullingEnabled;
		cullMode = top.cullMode;
		frontPolyMode = top.frontPolyMode;
		backPolyMode = top.backPolyMode;
		frontFace = top.frontFace;
	}

	if(mask&GL_LIGHTING_BIT)
	{
		colorMaterialEnabled = top.colorMaterialEnabled;
		materialFront = top.materialFront;
		materialBack = top.materialBack;
		lightModel = top.lightModel;
		for(i=0; i<MAX_LIGHTS; i++)
			lights[i] = top.lights[i];
	}

	if(mask&GL_FOG_BIT)
	{
		fog = top.fog;
	}

	if(mask&GL_DEPTH_BUFFER_BIT)
	{
		depthTestEnabled = top.depthTestEnabled;
		depthWriteEnabled = top.depthWriteEnabled;
		depthFunc = top.depthFunc;
		clearDepth = top.clearDepth;
	}

	if(mask&GL_TRANSFORM_BIT)
	{
		curStack = top.curStack;
		normalizeNormalsEnabled = top.normalizeNormalsEnabled;
	}

	if(mask&GL_ENABLE_BIT)
	{
		blend.enabled = top.blend.enabled;
		colorMaterialEnabled = top.colorMaterialEnabled;
		cullingEnabled = top.cullingEnabled;
		depthTestEnabled = top.depthTestEnabled;
		fog.enabled = top.fog.enabled;
		for(i=0; i<MAX_LIGHTS; i++)
			lights[i].enabled = top.lights[i].enabled;
		lightingEnabled = top.lightingEnabled;
		normalizeNormalsEnabled = top.normalizeNormalsEnabled;
		scissor.enabled = top.scissor.enabled;
		texturingEnabled = top.texturingEnabled;
	}

	if(mask&GL_COLOR_BUFFER_BIT)
	{
		blend = top.blend;
	}

	if(mask&GL_SCISSOR_BIT)
	{
		scissor = top.scissor;
	}


	// these attributes are not applied since we
	// don't support those features anyway...
	//
	//if(mask&GL_POINT_BIT)					{}
	//if(mask&GL_LINE_BIT)					{}
	//if(mask&GL_POLYGON_STIPPLE_BIT)		{}
	//if(mask&GL_PIXEL_MODE_BIT)			{}
	//if(mask&GL_ACCUM_BUFFER_BIT)			{}
	//if(mask&GL_STENCIL_BUFFER_BIT)		{}
	//if(mask&GL_VIEWPORT_BIT)				{}
	//if(mask&GL_HINT_BIT)					{}
	//if(mask&GL_LIST_BIT)					{}
	//if(mask&GL_EVAL_BIT)					{}
	//if(mask&GL_TEXTURE_BIT)				{}
}


void glPushClientAttrib(GLbitfield mask)
{
	RECORD_DISPLAYLISTS1(PushAttrib, mask)
	if(!displaylist.executeCommands)
		return;

	klClientAttributes&	top = clientAttributeStack.getTop();

	top.mask = mask;

	if(mask&GL_CLIENT_VERTEX_ARRAY_BIT)
	{
		top.arrayVertex = arrayVertex;
		top.arrayNormal = arrayNormal;
		top.arrayColor = arrayColor;
		top.arrayTexCoord = arrayTexCoord;
	}
}


void glPopClientAttrib()
{
	RECORD_DISPLAYLISTS0(PopAttrib)
	if(!displaylist.executeCommands)
		return;

	attributeStack.pop();

	const klClientAttributes&	top = clientAttributeStack.getTop();
	GLbitfield					mask = top.mask;

	if(mask&GL_CLIENT_VERTEX_ARRAY_BIT)
	{
		arrayVertex = top.arrayVertex;
		arrayNormal = top.arrayNormal;
		arrayColor = top.arrayColor;
		arrayTexCoord = top.arrayTexCoord;
	}
}

/**
}  // class klContext
*/

