/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klEGLSurfaceGapi.h,v 1.1 2004/01/13 11:20:10 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __KLEGLSURFACE_GAPI_HEADERFILE__
#define __KLEGLSURFACE_GAPI_HEADERFILE__


#include "../klEGLSurface.h"
#include <windows.h>
#include <aygshell.h>
#include <gx.h>

#pragma comment( lib, "Aygshell.lib" )
#pragma comment( lib, "gx.lib" )

#ifndef _IS_WINCE_
#pragma message (__FILE__ "() error: this code only works under Windows CE")
#endif //_IS_WINCE_


/// Windows CE implementation of EGLSurface using GAPI
/**
 *  This Windows CE implementation using Gapi of EGLSurface.
 *  It uses Gapi to switch into the devices graphics mode
 *  to allow per pixel access to video memory.
 */
class klEGLSurfaceGapi : public klEGLSurface
{
public:
	klEGLSurfaceGapi();
	~klEGLSurfaceGapi();
	
	virtual bool setNativeWindow(NativeWindowType nHWnd);
	virtual bool setNativeDisplay(NativeDisplayType nDisp);

	virtual NativeWindowType getNativeWindow();
	virtual NativeDisplayType getNativeDisplay();

	virtual bool destroy();
	virtual bool flip();

private:
	void setSize(int nWidth, int nHeight);

	HWND				hwnd;
	HDC					hdc;
	bool				displayOpened;
	GXDisplayProperties gxDisplayProp;
};


#endif //__KLEGLSURFACE_GAPI_HEADERFILE__
