/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/RasterizerSW565/klRSW565_Scanline_ZBuffer.h,v 1.4 2004/02/06 14:15:10 drgoldie Exp $
 *
\**************************************************************************/


//
// class klRSW565 {
//


////////////////////////////
//
//    Without Z-Writing
//

int	drawScanLine_ZBuffer_Always_NoWrite(const klFloat& /*nLeftZ*/, const klFloat& /*nRightZ*/, const klFloat& /*nPreStep*/,
										int nLen, const klFloat& /*nLenInv*/, DEPTHTYPE* /*nSrc*/)
{
	scanlineRunLengths[0] = (unsigned short)nLen;
	return 1;
}


int	drawScanLine_ZBuffer_Never_NoWrite(const klFloat& /*nLeftZ*/, const klFloat& /*nRightZ*/, const klFloat& /*nPreStep*/,
									   int /*nLen*/, const klFloat& /*nLenInv*/, DEPTHTYPE* /*nSrc*/)
{
	return 0;
}


int drawScanLine_ZBuffer_Less_NoWrite(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
									  int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ<*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ>=*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}


int drawScanLine_ZBuffer_LessEqual_NoWrite(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
										   int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ<=*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ>*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}


int drawScanLine_ZBuffer_Equal_NoWrite(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
									   int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ==*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ!=*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}


int drawScanLine_ZBuffer_GreaterEqual_NoWrite(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
											  int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ>=*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ<*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}


int drawScanLine_ZBuffer_Greater_NoWrite(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
										 int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ>*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ<=*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}


int drawScanLine_ZBuffer_Notequal_NoWrite(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
										  int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ!=*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ==*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}



////////////////////////////
//
//      With Z-Writing
//

int drawScanLine_ZBuffer_Always_Write(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
									  int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);

	while(nLen--)
	{
		*(nSrc++) = iZ.getZ();
		iZ.step();
	}

	scanlineRunLengths[0] = (unsigned short)nLen;
	return 1;
}


int	drawScanLine_ZBuffer_Never_Write(const klFloat& /*nLeftZ*/, const klFloat& /*nRightZ*/, const klFloat& /*nPreStep*/,
									 int /*nLen*/, const klFloat& /*nLenInv*/, DEPTHTYPE* /*nSrc*/)
{
	return 0;
}


int drawScanLine_ZBuffer_Less_Write(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
									int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ<*nSrc)
			{
				*(nSrc++) = curZ;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ>=*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				*(nSrc++) = curZ;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}


int drawScanLine_ZBuffer_LessEqual_Write(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
										 int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ<=*nSrc)
			{
				*(nSrc++) = curZ;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ>*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				*(nSrc++) = curZ;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}


int drawScanLine_ZBuffer_Equal_Write(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
									 int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ==*nSrc)
			{
				*(nSrc++) = curZ;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ!=*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				*(nSrc++) = curZ;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}


int drawScanLine_ZBuffer_GreaterEqual_Write(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
										    int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ>=*nSrc)
			{
				*(nSrc++) = curZ;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ<*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				*(nSrc++) = curZ;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}


int drawScanLine_ZBuffer_Greater_Write(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
									   int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ>*nSrc)
			{
				*(nSrc++) = curZ;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ<=*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				*(nSrc++) = curZ;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}


int drawScanLine_ZBuffer_Notequal_Write(const klFloat& nLeftZ, const klFloat& nRightZ, const klFloat& nPreStep,
									    int nLen, const klFloat& nLenInv, DEPTHTYPE* nSrc)
{
	InterpolatorZ_Linear	iZ(nLeftZ, nRightZ, nPreStep, nLenInv);
	klFloat					curZ;
	int						rlIdx=0;
	DEPTHTYPE*				src0 = nSrc;

	while(nLen>0)
	{
		// we start with visible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ!=*nSrc)
			{
				*(nSrc++) = curZ;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				nSrc++;
				break;
			}
		}

		if(nLen<=0)
			break;

		// now count invisible pixels
		while(nLen--)
		{
			curZ = iZ.getZ();
			iZ.step();
			if(curZ==*nSrc)
			{
				nSrc++;
			}
			else
			{
				scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
				src0 = nSrc;
				*(nSrc++) = curZ;
				break;
			}
		}
	}

	scanlineRunLengths[rlIdx++] = (unsigned short)(nSrc-src0);
	return rlIdx;
}


DEPTHFUNC drawScanLine_GetDepthFunc(RASTER_MODE_ZWRITE nZWrite, RASTER_MODE_ZTEST nZTest)
{
	if(nZWrite==RASTER_ZWRITE_OFF)			// no z-write
	{
		switch(nZTest)
		{
		case RASTER_ZTEST_ALWAYS:
			return &klRSW565::drawScanLine_ZBuffer_Always_NoWrite;

		case RASTER_ZTEST_NEVER:
			return &klRSW565::drawScanLine_ZBuffer_Never_NoWrite;

		case RASTER_ZTEST_LESS:
			return &klRSW565::drawScanLine_ZBuffer_Less_NoWrite;

		case RASTER_ZTEST_LEQUAL:
			return &klRSW565::drawScanLine_ZBuffer_LessEqual_NoWrite;

		case RASTER_ZTEST_EQUAL:
			return &klRSW565::drawScanLine_ZBuffer_Equal_NoWrite;

		case RASTER_ZTEST_GEQUAL:
			return &klRSW565::drawScanLine_ZBuffer_GreaterEqual_NoWrite;

		case RASTER_ZTEST_GREATER:
			return &klRSW565::drawScanLine_ZBuffer_Greater_NoWrite;

		case RASTER_ZTEST_NOTEQUAL:
			return &klRSW565::drawScanLine_ZBuffer_Notequal_NoWrite;
		}
	}
	else									// z-write
	{
		switch(nZTest)
		{
		case RASTER_ZTEST_ALWAYS:
			return &klRSW565::drawScanLine_ZBuffer_Always_Write;

		case RASTER_ZTEST_NEVER:
			return &klRSW565::drawScanLine_ZBuffer_Never_Write;

		case RASTER_ZTEST_LESS:
			return &klRSW565::drawScanLine_ZBuffer_Less_Write;

		case RASTER_ZTEST_LEQUAL:
			return &klRSW565::drawScanLine_ZBuffer_LessEqual_Write;

		case RASTER_ZTEST_EQUAL:
			return &klRSW565::drawScanLine_ZBuffer_Equal_Write;

		case RASTER_ZTEST_GEQUAL:
			return &klRSW565::drawScanLine_ZBuffer_GreaterEqual_Write;

		case RASTER_ZTEST_GREATER:
			return &klRSW565::drawScanLine_ZBuffer_Greater_Write;

		case RASTER_ZTEST_NOTEQUAL:
			return &klRSW565::drawScanLine_ZBuffer_Notequal_Write;
		}
	}


	// should never come here...
	//
	return &klRSW565::drawScanLine_ZBuffer_Never_NoWrite;
}

//
// } class klRSW565
//
