/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/RasterizerSW565/klRSW565_Line.h,v 1.2 2004/02/10 18:19:31 drgoldie Exp $
 *
\**************************************************************************/


//
//class klRSW565 {
//

//
// Line drawing functions
//

inline void
drawLine(const DeviceVertex& nV0, const DeviceVertex& nV1)
{
	DeviceVertex v0(nV0), v1(nV1);

	if(!clipline2d(v0,v1))
		return;

	//
	// TODO: all types of z-buffered line drawing are missing currently
	//
	//if(settings.color==RASTER_COLOR_OFF)
	//{
	//	// only write into the z-buffer
	//}
	//else
	if(v0.col==v1.col)
	{
		//if(settings.zwrite==RASTER_ZWRITE_ON)
		//	drawLine_Flat_Z(x1,y1,z1, x2,y2,z2, calcColor(r1, g1, b1));
		//else
			drawLine_Flat(v0.pos[0].getInt(),v0.pos[1].getInt(),
						  v1.pos[0].getInt(),v1.pos[1].getInt(), calcColor(v0.col));
	}
	else
	{
		//if(settings.zwrite==RASTER_ZWRITE_ON)
		//	drawLine_Gouraud_Z(x1,y1,z1, r1,g1,b1, x2,y2,z2, r2,g2,b2);
		//else
			drawLine_Gouraud(v0.pos[0].getInt(),v0.pos[1].getInt(), v0.col[0].getByte(),v0.col[1].getByte(),v0.col[2].getByte(),
							 v1.pos[0].getInt(),v1.pos[1].getInt(), v1.col[0].getByte(),v1.col[1].getByte(),v1.col[2].getByte());
	}
}


// clips a shaded line at the clip rectangle
//
bool
clipline2d(DeviceVertex& nV0, DeviceVertex& nV1)
{
	if(!clipEnabled)
		return true;

	// check for quick rejection cases
	//
	if(nV0.pos[0]<clipX0 && nV1.pos[0]<clipX0)
		return false;
	if(nV0.pos[0]>clipX1 && nV1.pos[0]>clipX1)
		return false;
	if(nV0.pos[1]<clipY0 && nV1.pos[1]<clipY0)
		return false;
	if(nV0.pos[1]>clipY1 && nV1.pos[1]>clipY1)
		return false;


	// clip on left side?
	//
	if(nV0.pos[0]<clipX0 && nV1.pos[0]>=clipX0)			// nV0.pos[0] left outside
	{
		klFloat d = (clipX0-nV0.pos[0]) / (nV1.pos[0]-nV0.pos[0]);

		nV0.pos[0] = clipX0;				
		nV0.pos[1] += (d*(nV1.pos[1]-nV0.pos[1]));		nV0.pos[2] += (d*(nV1.pos[2]-nV0.pos[2]));
		nV0.col[0] += (d*(nV1.col[0]-nV0.col[0]));		nV0.col[1] += (d*(nV1.col[1]-nV0.col[1]));		nV0.col[2] += (d*(nV1.col[2]-nV0.col[2]));
	}
	if(nV1.pos[0]<clipX0 && nV0.pos[0]>=clipX0)			// nV1.pos[0] left outside
	{
		klFloat d = (clipX0-nV1.pos[0]) / (nV1.pos[0]-nV0.pos[0]);

		nV1.pos[0] = clipX0;						nV1.pos[1] += (d*(nV1.pos[1]-nV0.pos[1]));		nV1.pos[2] += (d*(nV1.pos[2]-nV0.pos[2]));
		nV1.col[0] += (d*(nV1.col[0]-nV0.col[0]));		nV1.col[1] += (d*(nV1.col[1]-nV0.col[1]));		nV1.col[2] += (d*(nV1.col[2]-nV0.col[2]));
	}

	// clip on right side?
	//
	if(nV1.pos[0]<clipX1 && nV0.pos[0]>=clipX1)			// nV0.pos[0] right outside
	{
		klFloat d = (clipX1-nV0.pos[0]) / (nV1.pos[0]-nV0.pos[0]);

		nV0.pos[0] = clipX1;						nV0.pos[1] += (d*(nV1.pos[1]-nV0.pos[1]));		nV0.pos[2] += (d*(nV1.pos[2]-nV0.pos[2]));
		nV0.col[0] += (d*(nV1.col[0]-nV0.col[0]));		nV0.col[1] += (d*(nV1.col[1]-nV0.col[1]));		nV0.col[2] += (d*(nV1.col[2]-nV0.col[2]));
	}
	if(nV0.pos[0]<clipX1 && nV1.pos[0]>=clipX1)			// nV1.pos[0] right outside
	{
		klFloat d = (clipX1-nV1.pos[0]) / (nV1.pos[0]-nV0.pos[0]);

		nV1.pos[0] = clipX1;						nV1.pos[1] += (d*(nV1.pos[1]-nV0.pos[1]));		nV1.pos[2] += (d*(nV1.pos[2]-nV0.pos[2]));
		nV1.col[0] += (d*(nV1.col[0]-nV0.col[0]));		nV1.col[1] += (d*(nV1.col[1]-nV0.col[1]));		nV1.col[2] += (d*(nV1.col[2]-nV0.col[2]));
	}

	// clip on top side?
	//
	if(nV0.pos[1]<clipY0 && nV1.pos[1]>=clipY0)			// nV0.pos[1] top outside
	{
		klFloat d = (clipY0-nV0.pos[1]) / (nV1.pos[1]-nV0.pos[1]);

		nV0.pos[0] += (d*(nV1.pos[0]-nV0.pos[0]));		nV0.pos[1] = clipY0;						nV0.pos[2] += (d*(nV1.pos[2]-nV0.pos[2]));
		nV0.col[0] += (d*(nV1.col[0]-nV0.col[0]));		nV0.col[1] += (d*(nV1.col[1]-nV0.col[1]));		nV0.col[2] += (d*(nV1.col[2]-nV0.col[2]));
	}
	if(nV1.pos[1]<clipY0 && nV0.pos[1]>=clipY0)			// nV1.pos[1] top outside
	{
		klFloat d = (clipY0-nV1.pos[1]) / (nV1.pos[1]-nV0.pos[1]);

		nV1.pos[0] += (d*(nV1.pos[0]-nV0.pos[0]));		nV1.pos[1] = clipY0;						nV1.pos[2] += (d*(nV1.pos[2]-nV0.pos[2]));
		nV1.col[0] += (d*(nV1.col[0]-nV0.col[0]));		nV1.col[1] += (d*(nV1.col[1]-nV0.col[1]));		nV1.col[2] += (d*(nV1.col[2]-nV0.col[2]));
	}

	// clip on bottom side?
	//
	if(nV1.pos[1]<clipY1 && nV0.pos[1]>=clipY1)			// nV0.pos[1] right outside
	{
		klFloat d = (clipY1-nV0.pos[1]) / (nV1.pos[1]-nV0.pos[1]);

		nV0.pos[0] += (d*(nV1.pos[0]-nV0.pos[0]));		nV0.pos[1] = clipY1;						nV0.pos[2] += (d*(nV1.pos[2]-nV0.pos[2]));
		nV0.col[0] += (d*(nV1.col[0]-nV0.col[0]));		nV0.col[1] += (d*(nV1.col[1]-nV0.col[1]));		nV0.col[2] += (d*(nV1.col[2]-nV0.col[2]));
	}
	if(nV0.pos[1]<clipY1 && nV1.pos[1]>=clipY1)			// nV1.pos[1] right outside
	{
		klFloat d = (clipY1-nV1.pos[1]) / (nV1.pos[1]-nV0.pos[1]);

		nV1.pos[0] += (d*(nV1.pos[0]-nV0.pos[0]));		nV1.pos[1] = clipY1;						nV1.pos[2] += (d*(nV1.pos[2]-nV0.pos[2]));
		nV1.col[0] += (d*(nV1.col[0]-nV0.col[0]));		nV1.col[1] += (d*(nV1.col[1]-nV0.col[1]));		nV1.col[2] += (d*(nV1.col[2]-nV0.col[2]));
	}

	return true;
}


////////////////////////////////////////////////////////////////////////////////////////
//
//   drawLine_Flat draws a flat shaded line without z-buffer
//
void
drawLine_Flat(int x1, int y1, int x2, int y2, PIXELTYPE nColor)
{
	int	x=x1, y=y1;
	int dx, dy;
	int incx, incy;
	int balance;

	if(x2 >= x1)
	{	dx = x2 - x1;	incx = 1;	}
	else
	{	dx = x1 - x2;	incx = -1;	}

	if (y2 >= y1)
	{	dy = y2 - y1;	incy = 1;	}
	else
	{	dy = y1 - y2;	incy = -1;	}

	int	offset = y*width + x,
		incxBuf = incx,
		incyBuf = incy*width;

	if(dx==0 && dy==0)
	{
		setPixel(offset, nColor);
		return;
	}

	if (dx >= dy)
	{
		dy <<= 1;
		balance = dy - dx;
		dx <<= 1;

		while (x != x2)
		{
			setPixel(offset, nColor);
			if (balance >= 0)
			{
				y += incy;		offset += incyBuf;
				balance -= dx;
			}
			balance += dy;
			x += incx;			offset += incxBuf;
		}
		setPixel(offset, nColor);
	}
	else
	{
		dx <<= 1;
		balance = dx - dy;
		dy <<= 1;
		while (y != y2)
		{
			setPixel(offset, nColor);
			if (balance >= 0)
			{
				x += incx;		offset += incxBuf;
				balance -= dy;
			}
			balance += dx;
			y += incy;			offset += incyBuf;
		} 
		setPixel(offset, nColor);
	}
}


////////////////////////////////////////////////////////////////////////////////////////
//
//   drawLine_Gouraud draws a gouraud shaded line with z-buffer
//
void
drawLine_Gouraud(int x1, int y1, int r1, int g1, int b1,
				 int x2, int y2, int r2, int g2, int b2)
{
	int prec = 1024, precs = 10;
	int	x=x1, y=y1, r=r1<<precs, g=g1<<precs, b=b1<<precs;
	int dx, dy, dr,dg,db;
	int incx, incy;
	int balance;

	if(x2 >= x1)
	{	dx = x2 - x1;	incx = 1;	}
	else
	{	dx = x1 - x2;	incx = -1;	}

	if (y2 >= y1)
	{	dy = y2 - y1;	incy = 1;	}
	else
	{	dy = y1 - y2;	incy = -1;	}

	int	offset = y*width + x,
		incxBuf = incx,
		incyBuf = incy*width;

	if(dx==0 && dy==0)
	{
		setPixel(offset, calcColor(r>>precs,g>>precs,b>>precs));
		return;
	}

	if (dx >= dy)
	{
		dr = (prec*(r2-r1))/dx;
		dg = (prec*(g2-g1))/dx;
		db = (prec*(b2-b1))/dx;
		dy <<= 1;
		balance = dy - dx;
		dx <<= 1;

		while (x != x2)
		{
			setPixel(offset, calcColor(r>>precs,g>>precs,b>>precs));
			if (balance >= 0)
			{
				y += incy;		offset += incyBuf;
				balance -= dx;
			}
			balance += dy;
			x += incx;			offset += incxBuf;
			r += dr;	g += dg;	b += db;
		}
		setPixel(offset, calcColor(r>>precs,g>>precs,b>>precs));
	}
	else
	{
		dr = (prec*(r2-r1))/dy;
		dg = (prec*(g2-g1))/dy;
		db = (prec*(b2-b1))/dy;
		dx <<= 1;
		balance = dx - dy;
		dy <<= 1;
		while (y != y2)
		{
			setPixel(offset, calcColor(r>>precs,g>>precs,b>>precs));
			if (balance >= 0)
			{
				x += incx;		offset += incxBuf;
				balance -= dy;
			}
			balance += dx;
			y += incy;			offset += incyBuf;
			r += dr;	g += dg;	b += db;
		} 
		setPixel(offset, calcColor(r>>precs,g>>precs,b>>precs));
	}
}

//
// } class klRSW565
//
