/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/RasterizerSW565/klRSW565_Internal.h,v 1.4 2004/02/10 18:19:31 drgoldie Exp $
 *
\**************************************************************************/


//
// class klRSW565 {
//

//
// Several internal methods...
//

#define RASTER_SPAN16													\
	RASTER_PIX(0)	RASTER_PIX(1)	RASTER_PIX(2)	RASTER_PIX(3)		\
	RASTER_PIX(4)	RASTER_PIX(5)	RASTER_PIX(6)	RASTER_PIX(7)		\
	RASTER_PIX(8)	RASTER_PIX(9)	RASTER_PIX(10)	RASTER_PIX(11)		\
	RASTER_PIX(12)	RASTER_PIX(13)	RASTER_PIX(14)	RASTER_PIX(15)

int
getNumPixels() const
{
	return width*height;
}


void
setPixel(int nOffset, PIXELTYPE nColor)
{
	cBuffer[nOffset] = nColor;
}


static inline PIXELTYPE calcColor(int nR, int nG, int nB)
{
	return (unsigned short)(((nR<<8)&0xF800) | ((nG<<3)&0x07E0) | ((nB>>3)&0x1F));
}


static inline PIXELTYPE calcColor(const klFloat& nR, const klFloat& nG, const klFloat& nB)
{
	return calcColor(nR.getByte(),nG.getByte(),nB.getByte());
}


static inline PIXELTYPE calcColor(const klColor3& nCol)
{
	return calcColor(nCol[0], nCol[1], nCol[2]);
}


static inline PIXELTYPE calcColor(const klColor4& nCol)
{
	return calcColor(nCol[0], nCol[1], nCol[2]);
}


static inline PIXELTYPE calcColor(unsigned int nColor)
{
	return (PIXELTYPE)(((nColor>>8)&RED_MASK) | ((nColor>>5)&GREEN_MASK) | ((nColor>>3)&BLUE_MASK));
}


static inline unsigned short blendPixel16(unsigned short nSrc, unsigned short nDst, int nOpacity)
{
	// shamelessly stolen from Thierry Tremblay's PocketFrog...
	//
	unsigned short RB1 = (unsigned short)(nDst & (RED_MASK | BLUE_MASK));
	unsigned short G1  = (unsigned short)(nDst & (GREEN_MASK ));
	unsigned short RB2 = (unsigned short)(nSrc & (RED_MASK | BLUE_MASK));
	unsigned short G2  = (unsigned short)(nSrc & (GREEN_MASK));
	unsigned short RB = (unsigned short)(RB1 + (((RB2-RB1) * (nOpacity>>3)) >> 5));
	unsigned short G  = (unsigned short)(G1 + (((G2-G1)*(nOpacity>>2))>>6));

	RB &= (RED_MASK | BLUE_MASK);
	G  &= (GREEN_MASK);

	return (unsigned short)(RB | G);
}


static inline unsigned short blendPixel16_6(unsigned short nSrc, unsigned short nDst, int nOpacity)
{
	// shamelessly stolen from Thierry Tremblay's PocketFrog...
	// modified to use 6-bit opacity values
	//
	unsigned short RB1 = (unsigned short)(nDst & (RED_MASK | BLUE_MASK));
	unsigned short G1  = (unsigned short)(nDst & (GREEN_MASK ));
	unsigned short RB2 = (unsigned short)(nSrc & (RED_MASK | BLUE_MASK));
	unsigned short G2  = (unsigned short)(nSrc & (GREEN_MASK));
	unsigned short RB = (unsigned short)(RB1 + (((RB2-RB1) * (nOpacity>>1)) >> 5));
	unsigned short G  = (unsigned short)(G1 + (((G2-G1)*nOpacity)>>6));

	RB &= (RED_MASK | BLUE_MASK);
	G  &= (GREEN_MASK);

	return (unsigned short)(RB | G);
}


static inline unsigned short convertPixel_RGBX32toRGB16(unsigned int nPixel)
{
	return (unsigned short)(((nPixel<<8)&RED_MASK) | ((nPixel>>5)&GREEN_MASK) | ((nPixel>>19)&BLUE_MASK));
}


static inline void convertRGBX32toRGB16(unsigned short* nDst, unsigned char* nSrc, int nNumPixels)
{
	unsigned int *src = reinterpret_cast<unsigned int*>(nSrc);

	while(nNumPixels--)
		*(nDst++) = convertPixel_RGBX32toRGB16(*(src++));
}


static inline void convertRGBX32toRGB16(unsigned int* nDst, unsigned char* nSrc, int nNumPixels)
{
	unsigned int *src = reinterpret_cast<unsigned int*>(nSrc);

	while(nNumPixels--)
		*(nDst++) = convertPixel_RGBX32toRGB16(*(src++));
}


int
getMipMapLevel(const Texture* nTexture, DeviceVertex* nV, int nPrimLen)
{
	if(!nTexture)
		return 0;

	if(nPrimLen>=3)
	{
		int i;

		klFloat v[16][2];

		// create vertices scaled by 1/256
		// (otherwise the area can become to large to fit into fixed point)
		for(i=0; i<nPrimLen; i++)
		{
			v[i][0] = nV[i].pos[0];		v[i][0]>>=4;
			v[i][1] = nV[i].pos[1];		v[i][1]>>=4;
		}

		klFloat screenArea = v[nPrimLen-1][0]*v[0][1] - v[nPrimLen-1][1]*v[0][0];
		for(i=0; i<nPrimLen-1; i++)
			screenArea += v[i][0]*v[i+1][1] - v[i][1]*v[i+1][0];
		klFloat screenAreaI = (screenArea<0 ? -screenArea : screenArea);

		if(screenAreaI==0)		// area zero? so there's nothing to render
			return -1;

		klFloat texArea = nV[nPrimLen-1].tex[0]*nV[0].tex[1] - nV[nPrimLen-1].tex[1]*nV[0].tex[0];
		for(i=0; i<nPrimLen-1; i++)
			texArea += nV[i].tex[0]*nV[i+1].tex[1] - nV[i].tex[1]*nV[i+1].tex[0];
		klFloat texAreaI = (texArea<0 ? -texArea : texArea), w,h;
		w.setInt(nTexture->mmLevels[0]->width>>4);
		h.setInt(nTexture->mmLevels[0]->height>>4);
		texAreaI *= w*h;

		klFloat factor = texAreaI / screenAreaI;
		int mipmapLevel;

		if(factor<5)
			mipmapLevel = 0;
		else if(factor<20)
			mipmapLevel = 1;
		else if(factor<80)
			mipmapLevel = 2;
		else if(factor<300)
			mipmapLevel = 3;
		else if(factor<800)
			mipmapLevel = 4;
		else
			mipmapLevel = 5;

		while(nTexture->mmLevels[mipmapLevel]==NULL && mipmapLevel>=0)
			mipmapLevel--;

		return mipmapLevel;
	}
	else
		return 0;
}

//
// } class klRSW565
//
