
 .align

 .data
 storage:
 .string	"0123012301230123012301230123012301230123"
 storage2:
 .string	"01230123012301230123"

 .text
.align

 
 .global blitKeyedAligned				// standard blit
 .global blitKeyedBlend50Aligned
 .global blitKeyedBlend 
 .global fillKeyedAligned   
 .global fillKeyedBlend50Aligned 
 
 /*
 .type	memc,function
 */

//----------------------------------------------------------------------------
/*
*
*	Standard memory to memory blit with color keying.
*	
*	void blitKeyedNonAligned(void *str);
*	
*	str{	
*		*void =destination
*		r1=source
*		r2=width of the source rectangle to be transfered
*		r3=height of the source rectangle to be transfered
*		r4=source step  (SourceTotalWidth- transferWidth) in bytes
*		r5=destination step (DestTotalWidth -transferWidth) in bytes   
*	}
*	
*/
//----------------------------------------------------------------------------

blitKeyedAligned:
        stmdb   sp!, { r4 - r12, lr }
	
	mov 	r11,r0
	ldr	r0,[r11],#4		
	ldr	r1,[r11],#4
	
	ldr	r2,[r11],#4
	ldr	r3,[r11],#4
	ldr	r4,[r11],#4
	ldr	r5,[r11],#4
	ldr	r10,[r11],#4  		// key transparency color to be compared to 	
	orr	r10,r10,r10, lsl #16
	
	ldr	r9,=0x0000FFFF 		// mask
	
	
	mov	r12,r2
	
	ands	r11,r1,#3
	beq	blitKeyedAligned_TestDest
	ands	r11,r0,#3
	beq	blitKeyedDestAligned_CheckCopyWords
	b       blitKeyedAligned_line

blitKeyedAligned_TestDest:
	ands	r11,r0,#3
	bne	blitKeyedSourceAligned_CheckCopyWords



blitKeyedAligned_line:

	ands	r6,r0,#3
	beq     blitKeyedAligned_CheckCopyWords
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	blitKeyedAligned_SkipFirstPixel
	strh	r6,[r0],#2
	
blitKeyedAligned_SkipFirstPixel:
	addeq	r0,r0,#2

	sub	r2,r2,#1

blitKeyedAligned_CheckCopyWords:
	movs	lr,r2,lsr #1					// number of words
	beq	blitKeyedAligned_PixelCopy

blitKeyedAligned_CopyWords:
	
	ldr	r6, [r1],#4
	cmp	r6,r10
	bne	blitKeyedAligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	blitKeyedAligned_CopyWords			// horizontal loop	
	b       blitKeyedAligned_PixelCopy 
       
blitKeyedAligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	blitKeyedAligned_CheckBottom
	
        add	r0,r0, #2
	mov	r7,r6,lsr #16
	strh	r7,[r0],#2
	

	
	subs	lr,lr,#1
	bne	blitKeyedAligned_CopyWords			// horizontal loop
	b       blitKeyedAligned_PixelCopy 

blitKeyedAligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	blitKeyedAligned_CopyWord		

	and	r7,r6,r9 
	strh	r7,[r0],#2
	add	r0,r0, #2
	
	subs	lr,lr,#1
	bne	blitKeyedAligned_CopyWords			// horizontal loop
	b       blitKeyedAligned_PixelCopy 
	
blitKeyedAligned_CopyWord:
	str	r6,[r0],#4
	subs	lr,lr,#1
	bne	blitKeyedAligned_CopyWords			// horizontal loop	



blitKeyedAligned_PixelCopy:

	ands	r2,r2,#1
	beq     blitKeyedAligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	blitKeyedAligned_SkipLastPixel
	strh	r6,[r0],#2
	
blitKeyedAligned_SkipLastPixel:
	addeq	r0,r0,#2
	


blitKeyedAligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5
	mov	r2,r12
	
	subs	r3,r3,#1
	bne	blitKeyedAligned_line			// vertical loop

	ldmia   sp!, { r4 - r12, pc }


// Source only aligned version




blitKeyedSourceAligned_CheckCopyWords:
	movs	lr,r2,lsr #1					// number of words
	beq	blitKeyedSourceAligned_PixelCopy

blitKeyedSourceAligned_CopyWords:
	
	ldr	r6, [r1],#4
	cmp	r6,r10
	bne	blitKeyedSourceAligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	blitKeyedSourceAligned_CopyWords			// horizontal loop	
	b       blitKeyedSourceAligned_PixelCopy 
       
blitKeyedSourceAligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	blitKeyedSourceAligned_CheckBottom
	
        add	r0,r0, #2
	mov	r7,r6,lsr #16
	strh	r7,[r0],#2
		
	subs	lr,lr,#1
	bne	blitKeyedSourceAligned_CopyWords			// horizontal loop
	b       blitKeyedSourceAligned_PixelCopy 

blitKeyedSourceAligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	blitKeyedSourceAligned_CopyWord		

	and	r7,r6,r9 
	strh	r7,[r0],#2
	add	r0,r0, #2
	
	subs	lr,lr,#1
	bne	blitKeyedSourceAligned_CopyWords			// horizontal loop
	b       blitKeyedSourceAligned_PixelCopy 
	
blitKeyedSourceAligned_CopyWord:
	strh	r6,[r0],#2
	mov	r6,r6,lsr #16
	strh    r6,[r0],#2
	subs	lr,lr,#1
	bne	blitKeyedSourceAligned_CopyWords			// horizontal loop	

blitKeyedSourceAligned_PixelCopy:

	ands	r2,r2,#1
	beq     blitKeyedSourceAligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	blitKeyedSourceAligned_SkipLastPixel
	strh	r6,[r0],#2
	
blitKeyedSourceAligned_SkipLastPixel:
	addeq	r0,r0,#2
	


blitKeyedSourceAligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5
	mov	r2,r12
	
	subs	r3,r3,#1
	bne	blitKeyedSourceAligned_CheckCopyWords			// vertical loop

	ldmia   sp!, { r4 - r12, pc }

 

// Destination only aligned version

blitKeyedDestAligned_CheckCopyWords:
	movs	lr,r2,lsr #1					// number of words
	beq	blitKeyedDestAligned_PixelCopy

blitKeyedDestAligned_CopyWords:
	
	ldrh	r6, [r1],#2
	ldrh	r11,[r1],#2
	orr	r6,r6,r11,lsl #16
	cmp	r6,r10
	bne	blitKeyedDestAligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	blitKeyedDestAligned_CopyWords			// horizontal loop	
	b       blitKeyedDestAligned_PixelCopy 
       
blitKeyedDestAligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	blitKeyedDestAligned_CheckBottom
	
        add	r0,r0, #2
	mov	r7,r6,lsr #16
	strh	r7,[r0],#2
		
	subs	lr,lr,#1
	bne	blitKeyedDestAligned_CopyWords			// horizontal loop
	b       blitKeyedDestAligned_PixelCopy 

blitKeyedDestAligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	blitKeyedDestAligned_CopyWord		

	and	r7,r6,r9 
	strh	r7,[r0],#2
	add	r0,r0, #2
	
	subs	lr,lr,#1
	bne	blitKeyedDestAligned_CopyWords			// horizontal loop
	b       blitKeyedDestAligned_PixelCopy 
	
blitKeyedDestAligned_CopyWord:
	str	r6,[r0],#4
	subs	lr,lr,#1	
	bne	blitKeyedDestAligned_CopyWords			// horizontal loop	

blitKeyedDestAligned_PixelCopy:

	ands	r2,r2,#1
	beq     blitKeyedDestAligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	blitKeyedDestAligned_SkipLastPixel
	strh	r6,[r0],#2
	
blitKeyedDestAligned_SkipLastPixel:
	addeq	r0,r0,#2
	


blitKeyedDestAligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5
	mov	r2,r12
	
	subs	r3,r3,#1
	bne	blitKeyedDestAligned_CheckCopyWords			// vertical loop

	ldmia   sp!, { r4 - r12, pc }

 
//----------------------------------------------------------------------------
/*
*
*	Standard memory to memory blit with color keying.
*	
*	void blitKeyedBlend50Aligned(void *str);
*	
*	str{	
*		*void =destination
*		r1=source
*		r2=width of the source rectangle to be transfered
*		r3=height of the source rectangle to be transfered
*		r4=source step  (SourceTotalWidth- transferWidth) in bytes
*		r5=destination step (DestTotalWidth -transferWidth) in bytes   
*	}
*	
*/
//----------------------------------------------------------------------------

blitKeyedBlend50Aligned:
        stmdb   sp!, { r4 - r12, lr }
	

	mov 	r11,r0
	ldr	r0,[r11],#4		
	ldr	r1,[r11],#4
	
	ldr	r2,[r11],#4
	ldr	r3,[r11],#4
	ldr	r4,[r11],#4
	ldr	r5,[r11],#4
	ldr	r10,[r11],#4  		// key transparency color to be compared to 	
	orr	r10,r10,r10, lsl #16
	
	ldr	r9,=0x0000FFFF 		// mask
	
	ldr	r11,=0xF7DEF7DE
	mov	r11,r11,lsr #1


	
	mov	r12,r2
	
	ands	r8,r1,#3
	beq	blitKeyedBlend50Aligned_TestDest
	ands	r8,r0,#3
	beq	blitKeyedBlend50DestAligned_CheckCopyWords
	b       blitKeyedBlend50Aligned_Start

blitKeyedBlend50Aligned_TestDest:


	ands	r8,r0,#3
	bne	blitKeyedBlend50SourceAligned_CheckCopyWords

blitKeyedBlend50Aligned_Start:


blitKeyedBlend50Aligned_line:

	ands	r6,r0,#3
	beq     blitKeyedBlend50Aligned_CheckCopyWords
	ldrh	r6,[r1],#2	
	cmp	r6,r10,lsr #16
	beq	blitKeyedBlend50Aligned_SkipFirstPixel
	ldrh	r7,[r0]
	and	r7,r11,r7,lsr #1
	and	r6,r11,r6,lsr #1
	add	r6,r7,r6
	strh	r6,[r0],#2
	
blitKeyedBlend50Aligned_SkipFirstPixel:
	addeq	r0,r0,#2

	sub	r2,r2,#1

blitKeyedBlend50Aligned_CheckCopyWords:
	movs	lr,r2,lsr #1					// number of words
	beq	blitKeyedBlend50Aligned_PixelCopy

blitKeyedBlend50Aligned_CopyWords:
	
	ldr	r6, [r1],#4
	cmp	r6,r10
	bne	blitKeyedBlend50Aligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	blitKeyedBlend50Aligned_CopyWords			// horizontal loop	
	b       blitKeyedBlend50Aligned_PixelCopy 
       
blitKeyedBlend50Aligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	blitKeyedBlend50Aligned_CheckBottom
	
        add	r0,r0, #2
	mov	r7,r6,lsr #16
	ldrh	r8,[r0]
	and	r7,r11,r7,lsr #1
	and	r8,r11,r8,lsr #1
	add	r7,r8,r7	
	strh	r7,[r0],#2
	
	
	subs	lr,lr,#1
	bne	blitKeyedBlend50Aligned_CopyWords			// horizontal loop
	b       blitKeyedBlend50Aligned_PixelCopy 

blitKeyedBlend50Aligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	blitKeyedBlend50Aligned_CopyWord		

	and	r7,r6,r9 
	ldrh	r8,[r0]
	and	r7,r11,r7,lsr #1
	and	r8,r11,r8,lsr #1
	add	r7,r8,r7	
	strh	r7,[r0],#2
	add	r0,r0, #2
	
	subs	lr,lr,#1
	bne	blitKeyedBlend50Aligned_CopyWords			// horizontal loop
	b       blitKeyedBlend50Aligned_PixelCopy 
	
blitKeyedBlend50Aligned_CopyWord:
	ldr	r8,[r0]
	and	r6,r11,r6,lsr #1
	and	r8,r11,r8,lsr #1
	add	r6,r8,r6	
	str	r6,[r0],#4

	subs	lr,lr,#1
	bne	blitKeyedBlend50Aligned_CopyWords			// horizontal loop	



blitKeyedBlend50Aligned_PixelCopy:

	ands	r2,r2,#1
	beq     blitKeyedBlend50Aligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	blitKeyedBlend50Aligned_SkipLastPixel
	ldrh	r8,[r0]
	and	r6,r11,r6,lsr #1
	and	r8,r11,r8,lsr #1
	add	r6,r8,r6	
	strh	r6,[r0],#2
	
blitKeyedBlend50Aligned_SkipLastPixel:
	addeq	r0,r0,#2
	


blitKeyedBlend50Aligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5
	mov	r2,r12
	
	subs	r3,r3,#1
	bne	blitKeyedBlend50Aligned_line			// vertical loop

       
        ldmia   sp!, { r4 - r12, pc }


// Source only aligned version




blitKeyedBlend50SourceAligned_CheckCopyWords:
	movs	lr,r2,lsr #1					// number of words
	beq	blitKeyedBlend50SourceAligned_PixelCopy

blitKeyedBlend50SourceAligned_CopyWords:
	
	ldr	r6, [r1],#4
	cmp	r6,r10
	bne	blitKeyedBlend50SourceAligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	blitKeyedBlend50SourceAligned_CopyWords			// horizontal loop	
	b       blitKeyedBlend50SourceAligned_PixelCopy 
       
blitKeyedBlend50SourceAligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	blitKeyedBlend50SourceAligned_CheckBottom
	
        add	r0,r0, #2
	ldrh	r8,[r0]
	and	r7,r11,r7,lsr #17
	and	r8,r11,r8,lsr #1
	add	r7,r8,r7  
	strh	r7,[r0],#2
		
	subs	lr,lr,#1
	bne	blitKeyedBlend50SourceAligned_CopyWords			// horizontal loop
	b       blitKeyedBlend50SourceAligned_PixelCopy 

blitKeyedBlend50SourceAligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	blitKeyedBlend50SourceAligned_CopyWord		

	and	r7,r6,r9 
	ldrh	r8,[r0]
	and	r7,r11,r7,lsr #1
	and	r8,r11,r8,lsr #1
	add	r7,r8,r7 	
	strh	r7,[r0],#2
	add	r0,r0, #2
	
	subs	lr,lr,#1
	bne	blitKeyedBlend50SourceAligned_CopyWords			// horizontal loop
	b       blitKeyedBlend50SourceAligned_PixelCopy 
	
blitKeyedBlend50SourceAligned_CopyWord:
	ldrh	r8,[r0]
	ldrh	r9,[r0,#2]
	orr	r8,r8,r9,lsl #16		
	and	r6,r11,r6,lsr #1
	and	r8,r11,r8,lsr #1	
	add	r6,r8,r6 	
	strh	r6,[r0],#2
	mov	r6,r6,lsr #16
	strh    r6,[r0],#2
	subs	lr,lr,#1
	bne	blitKeyedBlend50SourceAligned_CopyWords			// horizontal loop	

blitKeyedBlend50SourceAligned_PixelCopy:

	ands	r2,r2,#1
	beq     blitKeyedBlend50SourceAligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	blitKeyedBlend50SourceAligned_SkipLastPixel
	ldrh	r8,[r0]	
	and	r6,r11,r6,lsr #1
	and	r8,r11,r8,lsr #1	
	add	r6,r8,r6
	strh	r6,[r0],#2
	
blitKeyedBlend50SourceAligned_SkipLastPixel:
	addeq	r0,r0,#2
	


blitKeyedBlend50SourceAligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5
	mov	r2,r12
	
	subs	r3,r3,#1
	bne	blitKeyedBlend50SourceAligned_CheckCopyWords			// vertical loop

	ldmia   sp!, { r4 - r12, pc }

// Destination only aligned version

blitKeyedBlend50DestAligned_CheckCopyWords:

	movs	lr,r2,lsr #1					// number of words
	beq	blitKeyedBlend50DestAligned_PixelCopy

blitKeyedBlend50DestAligned_CopyWords:
	
	ldrh	r6, [r1],#2
	ldrh	r7,[r1],#2
	orr	r6,r6,r7,lsl #16
	cmp	r6,r10
	bne	blitKeyedBlend50DestAligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	blitKeyedBlend50DestAligned_CopyWords			// horizontal loop	
	b       blitKeyedBlend50DestAligned_PixelCopy 
       
blitKeyedBlend50DestAligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	blitKeyedBlend50DestAligned_CheckBottom
	
        add	r0,r0, #2	
	ldrh	r8,[r0]	
	and	r7,r11,r6,lsr #17
	and	r8,r11,r8,lsr #1	
	add	r7,r8,r7
	
	strh	r7,[r0],#2
		
	subs	lr,lr,#1
	bne	blitKeyedBlend50DestAligned_CopyWords			// horizontal loop
	b       blitKeyedBlend50DestAligned_PixelCopy 

blitKeyedBlend50DestAligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	blitKeyedBlend50DestAligned_CopyWord		

	and	r7,r6,r9 
	ldrh	r8,[r0]	
	and	r7,r11,r6,lsr #1
	and	r8,r11,r8,lsr #1	
	add	r7,r8,r7
	
	strh	r7,[r0],#2
	add	r0,r0, #2
	
	subs	lr,lr,#1
	bne	blitKeyedBlend50DestAligned_CopyWords			// horizontal loop
	b       blitKeyedBlend50DestAligned_PixelCopy 
	
blitKeyedBlend50DestAligned_CopyWord:
	ldr	r8,[r0]	
	and	r7,r11,r6,lsr #1
	and	r8,r11,r8,lsr #1	
	add	r7,r8,r7	
	str	r7,[r0],#4
	subs	lr,lr,#1	
	bne	blitKeyedBlend50DestAligned_CopyWords			// horizontal loop	

blitKeyedBlend50DestAligned_PixelCopy:

	ands	r2,r2,#1
	beq     blitKeyedBlend50DestAligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	blitKeyedBlend50DestAligned_SkipLastPixel
	ldrh	r8,[r0]	
	and	r6,r11,r6,lsr #1
	and	r8,r11,r8,lsr #1	
	add	r6,r8,r6
	
	strh	r6,[r0],#2
	
blitKeyedBlend50DestAligned_SkipLastPixel:
	addeq	r0,r0,#2
	


blitKeyedBlend50DestAligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5
	mov	r2,r12
	
	subs	r3,r3,#1
	bne	blitKeyedBlend50DestAligned_CheckCopyWords			// vertical loop

	ldmia   sp!, { r4 - r12, pc }






//----------------------------------------------------------------------------
/*
*
*	Standard memory to memory blit with color keying using set color instead of source image.
*	
*	void fillKeyedNonAligned(void *str);
*	
*	str{	
*		*void =destination
*		r1=source
*		r2=width of the source rectangle to be transfered
*		r3=height of the source rectangle to be transfered
*		r4=source step  (SourceTotalWidth- transferWidth) in bytes
*		r5=destination step (DestTotalWidth -transferWidth) in bytes   
*	}
*	
*/
//----------------------------------------------------------------------------

fillKeyedAligned:

	stmdb   sp!, { r4 - r12, lr }



	mov 	r11,r0
	ldr	r0,[r11],#4		
	ldr	r1,[r11],#4
	
	ldr	r2,[r11],#4
	ldr	r3,[r11],#4
	ldr	r4,[r11],#4
	ldr	r5,[r11],#4
	ldr	r10,[r11],#4  		// key transparency color to be compared to 	
	orr	r10,r10,r10, lsl #16
	
	ldr	r11,[r11]		// load fill color
	orr	r11,r11,r11, lsl #16
	
	ldr	r9,=0x0000FFFF 		// mask
		
	mov	r12,r2
	
	ands	lr,r1,#3
	beq	fillKeyedAligned_TestDest
	ands	lr,r0,#3
	beq	fillKeyedDestAligned_CheckCopyWords
	b       fillKeyedAligned_line

fillKeyedAligned_TestDest:
	ands	lr,r0,#3
	bne	fillKeyedSourceAligned_CheckCopyWords



fillKeyedAligned_line:

	ands	r6,r0,#3
	beq     fillKeyedAligned_CheckCopyWords
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	fillKeyedAligned_SkipFirstPixel
	strh	r11,[r0],#2
	
fillKeyedAligned_SkipFirstPixel:
	addeq	r0,r0,#2

	sub	r2,r2,#1

fillKeyedAligned_CheckCopyWords:
	movs	lr,r2,lsr #1					// number of words
	beq	fillKeyedAligned_PixelCopy

fillKeyedAligned_CopyWords:
	
	ldr	r6, [r1],#4
	cmp	r6,r10
	bne	fillKeyedAligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	fillKeyedAligned_CopyWords			// horizontal loop	
	b       fillKeyedAligned_PixelCopy 
       
fillKeyedAligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	fillKeyedAligned_CheckBottom
	
        add	r0,r0, #2	
	strh	r11,[r0],#2
	

	
	subs	lr,lr,#1
	bne	fillKeyedAligned_CopyWords			// horizontal loop
	b       fillKeyedAligned_PixelCopy 

fillKeyedAligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	fillKeyedAligned_CopyWord		
	
	strh	r11,[r0],#2
	add	r0,r0, #2
	
	subs	lr,lr,#1
	bne	fillKeyedAligned_CopyWords			// horizontal loop
	b       fillKeyedAligned_PixelCopy 
	
fillKeyedAligned_CopyWord:
	str	r11,[r0],#4
	subs	lr,lr,#1
	bne	fillKeyedAligned_CopyWords			// horizontal loop	



fillKeyedAligned_PixelCopy:

	ands	r2,r2,#1
	beq     fillKeyedAligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	fillKeyedAligned_SkipLastPixel
	strh	r11,[r0],#2
	
fillKeyedAligned_SkipLastPixel:
	addeq	r0,r0,#2
	


fillKeyedAligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5

	mov	r2,r12
	
	subs	r3,r3,#1
	bne	fillKeyedAligned_line			// vertical loop


	ldmia   sp!, { r4 - r12, pc }
 

 
// Source only aligned version


fillKeyedSourceAligned_CheckCopyWords:
	movs	lr,r2,lsr #1					// number of words
	beq	fillKeyedSourceAligned_PixelCopy

fillKeyedSourceAligned_CopyWords:
	
	ldr	r6, [r1],#4
	cmp	r6,r10
	bne	fillKeyedSourceAligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	fillKeyedSourceAligned_CopyWords			// horizontal loop	
	b       fillKeyedSourceAligned_PixelCopy 
       
fillKeyedSourceAligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	fillKeyedSourceAligned_CheckBottom
	
        add	r0,r0, #2
	strh	r11,[r0],#2
		
	subs	lr,lr,#1
	bne	fillKeyedSourceAligned_CopyWords			// horizontal loop
	b       fillKeyedSourceAligned_PixelCopy 

fillKeyedSourceAligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	fillKeyedSourceAligned_CopyWord		

	strh	r11,[r0],#2
	add	r0,r0, #2
	
	subs	lr,lr,#1
	bne	fillKeyedSourceAligned_CopyWords			// horizontal loop
	b       fillKeyedSourceAligned_PixelCopy 
	
fillKeyedSourceAligned_CopyWord:
	strh	r11,[r0],#2
	strh    r11,[r0],#2
	subs	lr,lr,#1
	bne	fillKeyedSourceAligned_CopyWords			// horizontal loop	

fillKeyedSourceAligned_PixelCopy:

	ands	r2,r2,#1
	beq     fillKeyedSourceAligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	fillKeyedSourceAligned_SkipLastPixel
	strh	r11,[r0],#2
	
fillKeyedSourceAligned_SkipLastPixel:
	addeq	r0,r0,#2
	


fillKeyedSourceAligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5
	mov	r2,r12
	
	subs	r3,r3,#1
	bne	fillKeyedSourceAligned_CheckCopyWords			// vertical loop

	ldmia   sp!, { r4 - r12, pc }


// Dest only aligned version



fillKeyedDestAligned_CheckCopyWords:
	movs	lr,r2,lsr #1					// number of words
	beq	fillKeyedDestAligned_PixelCopy

fillKeyedDestAligned_CopyWords:
	
	ldrh	r6, [r1],#2
	ldrh	r7,[r1],#2
	orr	r6,r6,r7,lsl #16
	cmp	r6,r10
	bne	fillKeyedDestAligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	fillKeyedDestAligned_CopyWords			// horizontal loop	
	b       fillKeyedDestAligned_PixelCopy 
       
fillKeyedDestAligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	fillKeyedDestAligned_CheckBottom
	
        add	r0,r0, #2	
	strh	r11,[r0],#2
		
	subs	lr,lr,#1
	bne	fillKeyedDestAligned_CopyWords			// horizontal loop
	b       fillKeyedDestAligned_PixelCopy 

fillKeyedDestAligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	fillKeyedDestAligned_CopyWord		
	
	strh	r11,[r0],#2
	add	r0,r0, #2
	
	subs	lr,lr,#1
	bne	fillKeyedDestAligned_CopyWords			// horizontal loop
	b       fillKeyedDestAligned_PixelCopy 
	
fillKeyedDestAligned_CopyWord:
	str	r11,[r0],#4
	subs	lr,lr,#1	
	bne	fillKeyedDestAligned_CopyWords			// horizontal loop	

fillKeyedDestAligned_PixelCopy:

	ands	r2,r2,#1
	beq     fillKeyedDestAligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	fillKeyedDestAligned_SkipLastPixel
	strh	r11,[r0],#2
	
fillKeyedDestAligned_SkipLastPixel:
	addeq	r0,r0,#2
	


fillKeyedDestAligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5
	mov	r2,r12
	
	subs	r3,r3,#1
	bne	fillKeyedDestAligned_CheckCopyWords			// vertical loop

	ldmia   sp!, { r4 - r12, pc }



//----------------------------------------------------------------------------
/*
*
*	Standard memory to memory blit with color keying using set color instead of source image.
*	
*	void fillKeyedBlend50Aligned(void *str);
*	
*	str{	
*		*void =destination
*		r1=source
*		r2=width of the source rectangle to be transfered
*		r3=height of the source rectangle to be transfered
*		r4=source step  (SourceTotalWidth- transferWidth) in bytes
*		r5=destination step (DestTotalWidth -transferWidth) in bytes   
*	}
*	
*/
//----------------------------------------------------------------------------

fillKeyedBlend50Aligned:

	stmdb   sp!, { r4 - r12, lr }

	mov 	r11,r0
	ldr	r0,[r11],#4		
	ldr	r1,[r11],#4
	
	ldr	r2,[r11],#4
	ldr	r3,[r11],#4
	ldr	r4,[r11],#4
	ldr	r5,[r11],#4
	ldr	r10,[r11],#4  		// key transparency color to be compared to 	
	orr	r10,r10,r10, lsl #16
	
	ldr	r11,[r11]		// load fill color
	orr	r11,r11,r11, lsl #16
	
	ldr	r9,=0x0000FFFF 		// mask
		
	
	str	r2,[sp]	

	ldr	r12,=0xF7DEF7DE
	and	r11,r12,r11
	mov	r11,r11,lsr #1



	
	ands	lr,r1,#3
	beq	fillKeyedBlend50Aligned_TestDest
	ands	lr,r0,#3
	beq	fillKeyedBlend50DestAligned_CheckCopyWords
	b       fillKeyedBlend50Aligned_line

fillKeyedBlend50Aligned_TestDest:
	ands	lr,r0,#3
	bne	fillKeyedBlend50SourceAligned_CheckCopyWords



fillKeyedBlend50Aligned_line:

	ands	r6,r0,#3
	beq     fillKeyedBlend50Aligned_CheckCopyWords
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	fillKeyedBlend50Aligned_SkipFirstPixel
	ldrh	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1
	strh	r6,[r0],#2
	
fillKeyedBlend50Aligned_SkipFirstPixel:
	addeq	r0,r0,#2

	sub	r2,r2,#1

fillKeyedBlend50Aligned_CheckCopyWords:
	movs	lr,r2,lsr #1					// number of words
	beq	fillKeyedBlend50Aligned_PixelCopy

fillKeyedBlend50Aligned_CopyWords:
	
	ldr	r6, [r1],#4
	cmp	r6,r10
	bne	fillKeyedBlend50Aligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	fillKeyedBlend50Aligned_CopyWords			// horizontal loop	
	b       fillKeyedBlend50Aligned_PixelCopy 
       
fillKeyedBlend50Aligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	fillKeyedBlend50Aligned_CheckBottom
	
        add	r0,r0, #2    
	ldrh	r6,[r0]	
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1		   
	strh	r6,[r0],#2
	

	
	subs	lr,lr,#1
	bne	fillKeyedBlend50Aligned_CopyWords			// horizontal loop
	b       fillKeyedBlend50Aligned_PixelCopy 

fillKeyedBlend50Aligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	fillKeyedBlend50Aligned_CopyWord		
	
	ldrh	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1		   
	strh	r6,[r0],#2	

	add	r0,r0, #2
	
	subs	lr,lr,#1
	bne	fillKeyedBlend50Aligned_CopyWords			// horizontal loop
	b       fillKeyedBlend50Aligned_PixelCopy 
	
fillKeyedBlend50Aligned_CopyWord:

	ldr	r6,[r0]
        and	r6,r12,r6
	add	r6,r11,r6, lsr #1

	str	r6,[r0],#4
	subs	lr,lr,#1
	bne	fillKeyedBlend50Aligned_CopyWords			// horizontal loop	



fillKeyedBlend50Aligned_PixelCopy:

	ands	r2,r2,#1
	beq     fillKeyedBlend50Aligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	fillKeyedBlend50Aligned_SkipLastPixel
	
	ldrh	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1		   
	strh	r6,[r0],#2
	
fillKeyedBlend50Aligned_SkipLastPixel:
	addeq	r0,r0,#2
	


fillKeyedBlend50Aligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5

	ldr	r2,[sp]
	
	subs	r3,r3,#1
	bne	fillKeyedBlend50Aligned_line			// vertical loop


	ldmia   sp!, { r4 - r12, pc }
 

 
// Source only aligned version


fillKeyedBlend50SourceAligned_CheckCopyWords:
	movs	lr,r2,lsr #1					// number of words
	beq	fillKeyedBlend50SourceAligned_PixelCopy

fillKeyedBlend50SourceAligned_CopyWords:
	
	ldr	r6, [r1],#4
	cmp	r6,r10
	bne	fillKeyedBlend50SourceAligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	fillKeyedBlend50SourceAligned_CopyWords			// horizontal loop	
	b       fillKeyedBlend50SourceAligned_PixelCopy 
       
fillKeyedBlend50SourceAligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	fillKeyedBlend50SourceAligned_CheckBottom
	
        add	r0,r0, #2
	ldrh	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1
	strh	r6,[r0],#2	
		
	subs	lr,lr,#1
	bne	fillKeyedBlend50SourceAligned_CopyWords			// horizontal loop
	b       fillKeyedBlend50SourceAligned_PixelCopy 

fillKeyedBlend50SourceAligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	fillKeyedBlend50SourceAligned_CopyWord		

	ldrh	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1
	strh	r6,[r0],#2
	add	r0,r0, #2
	
	subs	lr,lr,#1
	bne	fillKeyedBlend50SourceAligned_CopyWords			// horizontal loop
	b       fillKeyedBlend50SourceAligned_PixelCopy 
	
fillKeyedBlend50SourceAligned_CopyWord:
	ldrh	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1
	strh	r6,[r0],#2
	ldrh	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1
	strh	r6,[r0],#2
	
	subs	lr,lr,#1
	bne	fillKeyedBlend50SourceAligned_CopyWords			// horizontal loop	

fillKeyedBlend50SourceAligned_PixelCopy:

	ands	r2,r2,#1
	beq     fillKeyedBlend50SourceAligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	fillKeyedBlend50SourceAligned_SkipLastPixel
	ldrh	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1
	strh	r6,[r0],#2
	
	
fillKeyedBlend50SourceAligned_SkipLastPixel:
	addeq	r0,r0,#2
	


fillKeyedBlend50SourceAligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5
	ldr	r2,[sp]

	
	subs	r3,r3,#1
	bne	fillKeyedBlend50SourceAligned_CheckCopyWords			// vertical loop

	ldmia   sp!, { r4 - r12, pc }


// Dest only aligned version



fillKeyedBlend50DestAligned_CheckCopyWords:
	movs	lr,r2,lsr #1					// number of words
	beq	fillKeyedBlend50DestAligned_PixelCopy

fillKeyedBlend50DestAligned_CopyWords:
	
	ldrh	r6, [r1],#2
	ldrh	r7,[r1],#2
	orr	r6,r6,r7,lsl #16
	cmp	r6,r10
	bne	fillKeyedBlend50DestAligned_NotEmpty
	
	add	r0,r0,#4	
	subs	lr,lr,#1
	bne	fillKeyedBlend50DestAligned_CopyWords			// horizontal loop	
	b       fillKeyedBlend50DestAligned_PixelCopy 
       
fillKeyedBlend50DestAligned_NotEmpty:			
	   
	and	r7,r6,r9   
	cmp	r7,r10,lsr #16
	bne	fillKeyedBlend50DestAligned_CheckBottom
	
        add	r0,r0, #2    
	ldrh	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1
	strh	r6,[r0],#2	   
		
	subs	lr,lr,#1
	bne	fillKeyedBlend50DestAligned_CopyWords			// horizontal loop
	b       fillKeyedBlend50DestAligned_PixelCopy 

fillKeyedBlend50DestAligned_CheckBottom:

	mov	r7,r6,lsr #16  	
	cmp	r7,r10,lsr #16
	bne	fillKeyedBlend50DestAligned_CopyWord		
	
	ldrh	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1
	strh	r6,[r0],#4
	
	subs	lr,lr,#1
	bne	fillKeyedBlend50DestAligned_CopyWords			// horizontal loop
	b       fillKeyedBlend50DestAligned_PixelCopy 
	
fillKeyedBlend50DestAligned_CopyWord:

	ldr	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1
	str	r6,[r0],#4

	subs	lr,lr,#1	
	bne	fillKeyedBlend50DestAligned_CopyWords			// horizontal loop	

fillKeyedBlend50DestAligned_PixelCopy:

	ands	r2,r2,#1
	beq     fillKeyedBlend50DestAligned_EndOfLine
	ldrh	r6,[r1],#2
	cmp	r6,r10,lsr #16
	beq	fillKeyedBlend50DestAligned_SkipLastPixel
	ldrh	r6,[r0]
	and	r6,r12,r6
	add	r6,r11,r6, lsr #1
	strh	r6,[r0],#2	
	
fillKeyedBlend50DestAligned_SkipLastPixel:
	addeq	r0,r0,#2
	


fillKeyedBlend50DestAligned_EndOfLine: 	
	add	r1,r1,r4
	add	r0,r0,r5
	ldr	r2,[sp]

	
	subs	r3,r3,#1
	bne	fillKeyedBlend50DestAligned_CheckCopyWords			// vertical loop

	ldmia   sp!, { r4 - r12, pc }



//----------------------------------------------------------------------------
/*
*
*	Standard memory to memory blit with color keying.
*	
*	void blitKeyedBlend(void *str);
*	
*	str{	
*		*void =destination
*		r1=source
*		r2=width of the source rectangle to be transfered
*		r3=height of the source rectangle to be transfered
*		r4=source step  (SourceTotalWidth- transferWidth) in bytes
*		r5=destination step (DestTotalWidth -transferWidth) in bytes   
*	}
*	
*/
//----------------------------------------------------------------------------

blitKeyedBlend:
        stmdb   sp!, { r4 - r12, lr }
	
	
	mov 	r11,r0      
	ldr	r0,[r11]			// destination
	ldr	r1,[r11,#4]			// source
	ldr	r2,[r11,#8]			// source width
	ldr	r3,[r11,#12]			// source height
	ldr	r4,[r11,#16]			// source step	
	ldr	r5,[r11,#20]			// destination step

	ldr	r12,[r11,#32]			// alpha
	
	mov	r12,r12,lsl #1
 	
	str	r2,[sp]
	str	r4,[sp,#-4]
	str	r5,[sp,#-8]
	str	r3,[sp,#-12]
	


	ldr	r10,[r11,#24]
	orr	r10,r10,r10, lsl #16		// r10 = key color
	
	ldr	r9,=0xf81f
	ldr	r7,=0x07e0
	
	
	ands	r6,r1,#3
	beq	blitKeyedBlend_TestDest
	ands	r6,r0,#3
	beq	blitKeyedBlendDesAligned_CheckCopyWords
	b       blitKeyedBlend_StartLine

blitKeyedBlend_TestDest:
	ands	r11,r0,#3
	bne	blitKeyedBlendSourceAligned_CheckCopyWords


blitKeyedBlend_StartLine:   

	ands	r6,r0,#3
	beq     blitKeyedBlend_CheckCopyWords
	ldrh	r5,[r1],#2
	cmp	r5,r10,lsr #16
	beq	blitKeyedBlend_SkipFirstPixel
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  	
	strh	r6,[r0],#2
     
blitKeyedBlend_SkipFirstPixel:

	addeq	r0,r0,#2
	sub	r2,r2,#1

blitKeyedBlend_CheckCopyWords:

	movs	r3,r2,lsr #1					// number of words
	beq	blitKeyedBlend_CopyLastPixel

blitKeyedBlend_CopyWord:

	
	ldr	r8,[r1],#4
       	cmp	r8,r10
        beq	blitKeyedBlend_SkipPixel	

	ldr	r4,=0x0000FFFF 
	ldr	r11,[r0]
	and	r5,r8,r4   
	cmp	r5,r10,lsr #16
	beq	blitKeyedBlend_SecondPixel

        
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  

	strh	r6,[r0]

 
blitKeyedBlend_SecondPixel:

	mov	r5,r8,lsr #16  
	cmp	r5,r10,lsr #16
 	beq	blitKeyedBlend_SkipPixel


	mov	r5,r11,lsr #16
	
	and	r6,r5,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r9,r8,lsr #16
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r5,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r7,r8,lsr #16
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r8,r5,lr   	
	      
	strh	r8,[r0,#2]  
	         

blitKeyedBlend_SkipPixel:   
	
	add 	r0,r0,#4
	subs	r3,r3,#1
	bne	blitKeyedBlend_CopyWord 	



blitKeyedBlend_CopyLastPixel:   

	ands	r2,r2,#1
	beq     blitKeyedBlend_NextLine

	ldrh	r5,[r1],#2
	cmp	r5,r10,lsr #16
	beq	blitKeyedBlend_SkipLastPixel
	
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  	
	strh	r6,[r0]
     
	
blitKeyedBlend_SkipLastPixel:
	add	r0,r0,#2

blitKeyedBlend_NextLine:

	ldr	r2,[sp]
	ldr	r4,[sp,#-4]
	ldr	r5,[sp,#-8]
	ldr	r3,[sp,#-12]

	add	r1,r1,r4
	add	r0,r0,r5

	

	subs	r3,r3,#1
	str	r3,[sp,#-12]
	bne	blitKeyedBlend_StartLine			// vertical loop

	ldr	r0,=0

	ldmia   sp!, { r4 - r12, pc }



// Source only aligned version


blitKeyedBlendSourceAligned_CheckCopyWords:

	movs	r3,r2,lsr #1					// number of words
	beq	blitKeyedBlendSourceAligned_CopyLastPixel

blitKeyedBlendSourceAligned_CopyWord:

	
	ldr	r8,[r1],#4
       	cmp	r8,r10
        beq	blitKeyedBlendSourceAligned_SkipPixel	

	ldr	r4,=0x0000FFFF 
	ldrh	r11,[r0]
	and	r5,r8,r4   
	cmp	r5,r10,lsr #16
	beq	blitKeyedBlendSourceAligned_SecondPixel

        
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  

	strh	r6,[r0]

 
blitKeyedBlendSourceAligned_SecondPixel:

	mov	r5,r8,lsr #16  
	cmp	r5,r10,lsr #16
 	beq	blitKeyedBlendSourceAligned_SkipPixel

	ldrh	r5,[r0,#2]	
	
	and	r6,r5,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r9,r8,lsr #16
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r5,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r7,r8,lsr #16
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r8,r5,lr   	
	      
	strh	r8,[r0,#2]  
	         

blitKeyedBlendSourceAligned_SkipPixel:   
	
	add 	r0,r0,#4
	subs	r3,r3,#1
	bne	blitKeyedBlendSourceAligned_CopyWord 	


blitKeyedBlendSourceAligned_CopyLastPixel:   

	ands	r2,r2,#1
	beq     blitKeyedBlendSourceAligned_NextLine

	ldrh	r5,[r1],#2
	cmp	r5,r10,lsr #16
	beq	blitKeyedBlendSourceAligned_SkipLastPixel
	
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  	
	strh	r6,[r0]
     
	
blitKeyedBlendSourceAligned_SkipLastPixel:
	add	r0,r0,#2

blitKeyedBlendSourceAligned_NextLine:

	ldr	r2,[sp]
	ldr	r4,[sp,#-4]
	ldr	r5,[sp,#-8]
	ldr	r3,[sp,#-12]

	add	r1,r1,r4
	add	r0,r0,r5

	

	subs	r3,r3,#1
	str	r3,[sp,#-12]
	bne	blitKeyedBlendSourceAligned_CheckCopyWords			// vertical loop

	ldr	r0,=1

	ldmia   sp!, { r4 - r12, pc }


// Destination aligned only



blitKeyedBlendDesAligned_CheckCopyWords:

	movs	r3,r2,lsr #1					// number of words
	beq	blitKeyedBlendDesAligned_CopyLastPixel

blitKeyedBlendDesAligned_CopyWord:
     

	ldr	r11,[r0]
	ldrh	r5,[r1],#2
	cmp	r5,r10,lsr #16
	beq	blitKeyedBlendDesAligned_SecondPixel

        
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  

	strh	r6,[r0]

 
blitKeyedBlendDesAligned_SecondPixel:

	ldrh	r8,[r1],#2	 
	cmp	r8,r10,lsr #16
 	beq	blitKeyedBlendDesAligned_SkipPixel


	mov	r5,r11,lsr #16
	
	and	r6,r5,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r9,r8
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r5,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r7,r8
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r8,r5,lr   	
	      
	strh	r8,[r0,#2]  
	         

blitKeyedBlendDesAligned_SkipPixel:   
	
	add 	r0,r0,#4
	subs	r3,r3,#1
	bne	blitKeyedBlendDesAligned_CopyWord 	



blitKeyedBlendDesAligned_CopyLastPixel:   

	ands	r2,r2,#1
	beq     blitKeyedBlendDesAligned_NextLine

	ldrh	r5,[r1],#2
	cmp	r5,r10,lsr #16
	beq	blitKeyedBlendDesAligned_SkipLastPixel
	
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  	
	strh	r6,[r0]
     
	
blitKeyedBlendDesAligned_SkipLastPixel:
	add	r0,r0,#2

blitKeyedBlendDesAligned_NextLine:

	ldr	r2,[sp]
	ldr	r4,[sp,#-4]
	ldr	r5,[sp,#-8]
	ldr	r3,[sp,#-12]

	add	r1,r1,r4
	add	r0,r0,r5

	

	subs	r3,r3,#1
	str	r3,[sp,#-12]
	bne	blitKeyedBlendDesAligned_CheckCopyWords			// vertical loop

	ldr	r0,=2


	ldmia   sp!, { r4 - r12, pc }

