
 .align

 .data
 

 .text
.align
  
 .global blitAlpha 
 .global fillKeyedBlend

/*
 .type	memc,function
*/ 

//----------------------------------------------------------------------------
/*
*
*	Standard memory to memory blit with color keying.
*	
*	void blitAlpha(void *str);
*	
*	str{	
*		*void =destination
*		r1=source
*		r2=width of the source rectangle to be transfered
*		r3=height of the source rectangle to be transfered
*		r4=source step  (SourceTotalWidth- transferWidth) in bytes
*		r5=destination step (DestTotalWidth -transferWidth) in bytes   
*	}
*	
*/
//----------------------------------------------------------------------------


blitAlpha:
        stmdb   sp!, { r4 - r12, lr }
	
	
	mov 	r11,r0      
	ldr	r0,[r11]			// destination
	ldr	r1,[r11,#4]			// source
	ldr	r2,[r11,#8]			// source width
	ldr	r3,[r11,#12]			// source height
	ldr	r4,[r11,#16]			// source step	
	ldr	r5,[r11,#20]			// destination step
 	
	str	r2,[sp]
	str	r4,[sp,#-4]
	str	r5,[sp,#-8]
	str	r3,[sp,#-12]
	
	ldr	r10,[r11,#36]			// alpha source address
	
	ldr	r9,=0xf81f
	ldr	r7,=0x07e0
	
	
	ands	r6,r1,#3
	beq	blitAlpha_TestDest
	ands	r6,r0,#3
	beq	blitAlphaDesAligned_CheckCopyWords
	b       blitAlpha_StartLine

blitAlpha_TestDest:
	ands	r11,r0,#3
	bne	blitAlphaSourceAligned_CheckCopyWords


blitAlpha_StartLine:   

	ands	r6,r0,#3
	beq     blitAlpha_CheckCopyWords
	ldrh	r5,[r1],#2
	ldrh	r12,[r10],#2				// alpha value
	cmp	r12,#0
	beq	blitAlpha_SkipFirstPixel
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  	
	strh	r6,[r0],#2
     
blitAlpha_SkipFirstPixel:

	addeq	r0,r0,#2
	sub	r2,r2,#1

blitAlpha_CheckCopyWords:

	movs	r3,r2,lsr #1					// number of words
	beq	blitAlpha_CopyLastPixel

blitAlpha_CopyWord:
	
	ldr	r12,[r10],#4  
	cmp	r12,#0
        bne	blitAlpha_Check255 

	add 	r0,r0,#4 
	add	r1,r1,#4
	subs	r3,r3,#1
	bne	blitAlpha_CopyWord 		
        b	blitAlpha_CopyLastPixel
	
blitAlpha_Check255:

	ldr	r8,[r1],#4      
        ldr	r6,=0x003F003F
	cmp	r12,r6
	bne     blitAlpha_ContinueCopyWord

	str	r8,[r0],#4
	subs	r3,r3,#1
	bne	blitAlpha_CopyWord 
	b	blitAlpha_CopyLastPixel
    
blitAlpha_ContinueCopyWord:

	ldr	r4,=0x0000FFFF 
	ldr	r11,[r0]
	ands	r5,r12,r4   
	beq	blitAlpha_SecondPixel

	and	r5,r8,r4 	
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	and	r4,r12,r4
	mul	lr,r4,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  

	strh	r6,[r0]

 
blitAlpha_SecondPixel:

	movs	r5,r12,lsr #16  
 	beq	blitAlpha_SkipPixel


	mov	r5,r11,lsr #16
	
	and	r6,r5,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r9,r8,lsr #16
	sub	lr,lr,r6
	mov	r12,r12,lsr #16	
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r5,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r7,r8,lsr #16
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r8,r5,lr   	
	      
	strh	r8,[r0,#2]  
	         

blitAlpha_SkipPixel:   
	
	add 	r0,r0,#4 
	subs	r3,r3,#1
	bne	blitAlpha_CopyWord 	



blitAlpha_CopyLastPixel:   

	ands	r2,r2,#1
	beq     blitAlpha_NextLine

	ldrh	r12,[r10],#2 
	ldrh	r5,[r1],#2	
	cmp	r12,#0
	beq	blitAlpha_SkipLastPixel
	
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  	
	strh	r6,[r0]
     
	
blitAlpha_SkipLastPixel:
	add	r0,r0,#2

blitAlpha_NextLine:

	ldr	r2,[sp]
	ldr	r4,[sp,#-4]
	ldr	r5,[sp,#-8]
	ldr	r3,[sp,#-12]

	add	r1,r1,r4
	add	r10,r10,r4
	add	r0,r0,r5

	

	subs	r3,r3,#1
	str	r3,[sp,#-12]
	bne	blitAlpha_StartLine			// vertical loop

	ldr	r0,=0

	ldmia   sp!, { r4 - r12, pc }



// Source only aligned version



blitAlphaSourceAligned_CheckCopyWords:


	movs	r3,r2,lsr #1					// number of words
	beq	blitAlphaSourceAligned_CopyLastPixel

blitAlphaSourceAligned_CopyWord:
	
	ldr	r12,[r10],#4	
	cmp	r12,#0
        bne	blitAlphaSourceAligned_Check255 

	add 	r0,r0,#4 
	add	r1,r1,#4
	subs	r3,r3,#1
	bne	blitAlphaSourceAligned_CopyWord 		
        b	blitAlphaSourceAligned_CopyLastPixel
	
blitAlphaSourceAligned_Check255:

	ldr	r8,[r1],#4      
        ldr	r6,=0x003F003F
	cmp	r12,r6
	bne     blitAlphaSourceAligned_ContinueCopyWord

	strh	r8,[r0],#2
	mov	r6,r8,lsr #16
	strh	r6,[r0],#2
	subs	r3,r3,#1
	bne	blitAlphaSourceAligned_CopyWord 
	b	blitAlphaSourceAligned_CopyLastPixel
    
blitAlphaSourceAligned_ContinueCopyWord:

	ldr	r4,=0x0000FFFF 
	ldrh	r11,[r0]
	ands	r5,r12,r4   
	beq	blitAlphaSourceAligned_SecondPixel

        and	r5,r8,r4 
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	and	r4,r12,r4
	mul	lr,r4,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  

	strh	r6,[r0]

 
blitAlphaSourceAligned_SecondPixel:

	mov	r5,r8,lsr #16  
	cmp	r5,r10,lsr #16
 	beq	blitAlphaSourceAligned_SkipPixel

	ldrh	r5,[r0,#2]	
	
	and	r6,r5,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r9,r8,lsr #16
	sub	lr,lr,r6
	mov	r12,r12,lsr #16		
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r5,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r7,r8,lsr #16
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r8,r5,lr   	
	      
	strh	r8,[r0,#2]  
	         

blitAlphaSourceAligned_SkipPixel:   
	
	add 	r0,r0,#4
	subs	r3,r3,#1
	bne	blitAlphaSourceAligned_CopyWord 	


blitAlphaSourceAligned_CopyLastPixel:   

	ands	r2,r2,#1
	beq     blitAlphaSourceAligned_NextLine

	ldrh	r12,[r10],#2 
	ldrh	r5,[r1],#2	
	cmp	r12,#0
	beq	blitAlphaSourceAligned_SkipLastPixel
	
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  	
	strh	r6,[r0] 
	
blitAlphaSourceAligned_SkipLastPixel:
	add	r0,r0,#2
	


blitAlphaSourceAligned_NextLine:

	ldr	r2,[sp]
	ldr	r4,[sp,#-4]
	ldr	r5,[sp,#-8]
	ldr	r3,[sp,#-12]

	add	r1,r1,r4
	add	r0,r0,r5
	add	r10,r10,r4
	

	subs	r3,r3,#1
	str	r3,[sp,#-12]
	bne	blitAlphaSourceAligned_CheckCopyWords			// vertical loop


	ldmia   sp!, { r4 - r12, pc }


// Destination aligned only



blitAlphaDesAligned_CheckCopyWords:
	movs	r3,r2,lsr #1					// number of words
	beq	blitAlphaDesAligned_CopyLastPixel


blitAlphaDesAligned_CopyWord:
	
	ldrh	r6,[r10],#2
	ldrh	r12,[r10],#2	
	orrs	r12,r6,r12,lsl #16
        bne	blitAlphaDesAligned_Check255 

	add 	r0,r0,#4 
	add	r1,r1,#4
	subs	r3,r3,#1
	bne	blitAlphaDesAligned_CopyWord 		
        b	blitAlphaDesAligned_CopyLastPixel
	
blitAlphaDesAligned_Check255:

	ldrh	r6,[r1],#2
	ldrh	r8,[r1],#2	
	orr	r8,r6,r8,lsl #16
        ldr	r6,=0x003F003F
	cmp	r12,r6
	bne     blitAlphaDesAligned_ContinueCopyWord

	str	r8,[r0],#4
	subs	r3,r3,#1
	bne	blitAlphaDesAligned_CopyWord 
	b	blitAlphaDesAligned_CopyLastPixel

blitAlphaDesAligned_ContinueCopyWord:

	ldr	r4,=0x0000FFFF 
	ldr	r11,[r0]
	ands	r5,r12,r4   
	beq	blitAlphaDesAligned_SecondPixel

	and	r5,r8,r4 	
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	and	r4,r12,r4
	mul	lr,r4,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  

	strh	r6,[r0]

 
blitAlphaDesAligned_SecondPixel:

	movs	r5,r12,lsr #16  
 	beq	blitAlphaDesAligned_SkipPixel


	mov	r5,r11,lsr #16
	
	and	r6,r5,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r9,r8,lsr #16
	sub	lr,lr,r6
	mov	r12,r12,lsr #16	
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r5,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r7,r8,lsr #16
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r8,r5,lr   	
	      
	strh	r8,[r0,#2]  

	         

blitAlphaDesAligned_SkipPixel:   
	
	add 	r0,r0,#4
	subs	r3,r3,#1
	bne	blitAlphaDesAligned_CopyWord 	


blitAlphaDesAligned_CopyLastPixel:   

	ands	r2,r2,#1
	beq     blitAlphaDesAligned_NextLine

	ldrh	r12,[r10],#2 
	ldrh	r5,[r1],#2	
	cmp	r12,#0
	beq	blitAlphaDesAligned_SkipLastPixel
	
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r5,r5,r7
	sub	r5,r5,r6
	mul	r5,r12,r5
	add	r5,r6,r5,lsr #6
	and	r5,r5,r7
	
	orr  	r6,r5,lr  	
	strh	r6,[r0]      
	
blitAlphaDesAligned_SkipLastPixel:
	add	r0,r0,#2

blitAlphaDesAligned_NextLine:

	ldr	r2,[sp]
	ldr	r4,[sp,#-4]
	ldr	r5,[sp,#-8]
	ldr	r3,[sp,#-12]

	add	r1,r1,r4
	add	r0,r0,r5 
	add	r10,r10,r4

	

	subs	r3,r3,#1
	str	r3,[sp,#-12]
	bne	blitAlphaDesAligned_CheckCopyWords			// vertical loop

	ldr	r0,=2


	ldmia   sp!, { r4 - r12, pc }
	

//----------------------------------------------------------------------------
/*
*
*	Standard memory to memory bl
*	
*	void fillKeyedBlend(void *str);
*	
*	str{	
*		*void =destination
*		r1=source
*		r2=width of the source rectangle to be transfered
*		r3=height of the source rectangle to be transfered
*		r4=source step  (SourceTotalWidth- transferWidth) in bytes
*		r5=destination step (DestTotalWidth -transferWidth) in bytes   
*	}
*	
*/
//----------------------------------------------------------------------------

fillKeyedBlend:
        stmdb   sp!, { r4 - r12, lr }
	
	
	mov 	r11,r0      
	ldr	r0,[r11]			// destination
	ldr	r1,[r11,#4]			// source
	ldr	r2,[r11,#8]			// source width
	ldr	r3,[r11,#12]			// source height
	ldr	r4,[r11,#16]			// source step	
	ldr	r5,[r11,#20]			// destination step

	ldr	r12,[r11,#32]			// alpha
	
	mov	r12,r12,lsl #1
 	
	str	r2,[sp]
	str	r4,[sp,#-4]
	str	r5,[sp,#-8]
	str	r3,[sp,#-12]
	


	ldr	r10,[r11,#24]
	orr	r10,r10,r10, lsl #16		// r10 = key color
	
	ldr	r9,=0xf81f
	ldr	r7,=0x07e0
	
	ldr	r5,[r11,#28]			// load fill color
	
	ands	r6,r1,#3
	beq	fillKeyedBlend_TestDest
	ands	r6,r0,#3
	beq	fillKeyedBlendDesAligned_CheckCopyWords
	b       fillKeyedBlend_StartLine

fillKeyedBlend_TestDest:
	ands	r11,r0,#3
	bne	fillKeyedBlendSourceAligned_CheckCopyWords


fillKeyedBlend_StartLine:   

	ands	r6,r0,#3
	beq     fillKeyedBlend_CheckCopyWords
	ldrh	r4,[r1],#2
	cmp	r4,r10,lsr #16
	beq	fillKeyedBlend_SkipFirstPixel
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r4,r5,r7
	sub	r4,r4,r6
	mul	r4,r12,r4
	add	r4,r6,r4,lsr #6
	and	r4,r4,r7
	
	orr  	r6,r4,lr  	
	strh	r6,[r0],#2
     
fillKeyedBlend_SkipFirstPixel:

	addeq	r0,r0,#2
	sub	r2,r2,#1

fillKeyedBlend_CheckCopyWords:

	movs	r3,r2,lsr #1					// number of words
	beq	fillKeyedBlend_CopyLastPixel

fillKeyedBlend_CopyWord:

	
	ldr	r8,[r1],#4
       	cmp	r8,r10
        beq	fillKeyedBlend_SkipPixel	

	ldr	r4,=0x0000FFFF 
	ldr	r11,[r0]
	and	r4,r8,r4   
	cmp	r4,r10,lsr #16
	beq	fillKeyedBlend_SecondPixel

        
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r4,r5,r7
	sub	r4,r4,r6
	mul	r4,r12,r4
	add	r4,r6,r4,lsr #6
	and	r4,r4,r7
	
	orr  	r6,r4,lr  

	strh	r6,[r0]

 
fillKeyedBlend_SecondPixel:

	mov	r4,r8,lsr #16  
	cmp	r4,r10,lsr #16
 	beq	fillKeyedBlend_SkipPixel


	mov	r4,r11,lsr #16
	
	and	r6,r4,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r9,r5
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r4,r7 				// r6  = dwAlphaGtemp		
	
       	and	r4,r7,r5
	sub	r4,r4,r6
	mul	r4,r12,r4
	add	r4,r6,r4,lsr #6
	and	r4,r4,r7
	
	orr  	r8,r4,lr   	
	      
	strh	r8,[r0,#2]  
	         

fillKeyedBlend_SkipPixel:   
	
	add 	r0,r0,#4
	subs	r3,r3,#1
	bne	fillKeyedBlend_CopyWord 	



fillKeyedBlend_CopyLastPixel:   

	ands	r2,r2,#1
	beq     fillKeyedBlend_NextLine

	ldrh	r4,[r1],#2
	cmp	r4,r10,lsr #16
	beq	fillKeyedBlend_SkipLastPixel
	
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r4,r5,r7
	sub	r4,r4,r6
	mul	r4,r12,r4
	add	r4,r6,r4,lsr #6
	and	r4,r4,r7
	
	orr  	r6,r4,lr  	
	strh	r6,[r0]
     
	
fillKeyedBlend_SkipLastPixel:
	add	r0,r0,#2

fillKeyedBlend_NextLine:

	ldr	r2,[sp]
	ldr	r4,[sp,#-4]
	ldr	r6,[sp,#-8]
	ldr	r3,[sp,#-12]

	add	r1,r1,r4
	add	r0,r0,r6

	

	subs	r3,r3,#1
	str	r3,[sp,#-12]
	bne	fillKeyedBlend_StartLine			// vertical loop

	ldr	r0,=0

	ldmia   sp!, { r4 - r12, pc }



// Source only aligned version


fillKeyedBlendSourceAligned_CheckCopyWords:

	movs	r3,r2,lsr #1					// number of words
	beq	fillKeyedBlendSourceAligned_CopyLastPixel

fillKeyedBlendSourceAligned_CopyWord:

	
	ldr	r8,[r1],#4
       	cmp	r8,r10
        beq	fillKeyedBlendSourceAligned_SkipPixel	

	ldr	r4,=0x0000FFFF 
	ldrh	r11,[r0]
	and	r4,r8,r4   
	cmp	r4,r10,lsr #16
	beq	fillKeyedBlendSourceAligned_SecondPixel

        
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r4,r5,r7
	sub	r4,r4,r6
	mul	r4,r12,r4
	add	r4,r6,r4,lsr #6
	and	r4,r4,r7
	
	orr  	r6,r4,lr  

	strh	r6,[r0]

 
fillKeyedBlendSourceAligned_SecondPixel:

	mov	r4,r8,lsr #16  
	cmp	r4,r10,lsr #16
 	beq	fillKeyedBlendSourceAligned_SkipPixel
	
	ldrh	r11,[r0,#2] 
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r4,r5,r7
	sub	r4,r4,r6
	mul	r4,r12,r4
	add	r4,r6,r4,lsr #6
	and	r4,r4,r7
	
	orr  	r8,r4,lr   	
	      
	strh	r8,[r0,#2]  
	         

fillKeyedBlendSourceAligned_SkipPixel:   
	
	add 	r0,r0,#4
	subs	r3,r3,#1
	bne	fillKeyedBlendSourceAligned_CopyWord 	


fillKeyedBlendSourceAligned_CopyLastPixel:   

	ands	r2,r2,#1
	beq     fillKeyedBlendSourceAligned_NextLine

	ldrh	r4,[r1],#2
	cmp	r4,r10,lsr #16
	beq	fillKeyedBlendSourceAligned_SkipLastPixel
	
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r4,r5,r7
	sub	r4,r4,r6
	mul	r4,r12,r4
	add	r4,r6,r4,lsr #6
	and	r4,r4,r7
	
	orr  	r6,r4,lr  	
	strh	r6,[r0]
     
	
fillKeyedBlendSourceAligned_SkipLastPixel:
	add	r0,r0,#2

fillKeyedBlendSourceAligned_NextLine:

	ldr	r2,[sp]
	ldr	r4,[sp,#-4]
	ldr	r6,[sp,#-8]
	ldr	r3,[sp,#-12]

	add	r1,r1,r4
	add	r0,r0,r6

	

	subs	r3,r3,#1
	str	r3,[sp,#-12]
	bne	fillKeyedBlendSourceAligned_CheckCopyWords			// vertical loop

	ldr	r0,=1

	ldmia   sp!, { r4 - r12, pc }


// Destination aligned only



fillKeyedBlendDesAligned_CheckCopyWords:

	movs	r3,r2,lsr #1					// number of words
	beq	fillKeyedBlendDesAligned_CopyLastPixel

fillKeyedBlendDesAligned_CopyWord:
     

	ldr	r11,[r0]
	ldrh	r4,[r1],#2
	cmp	r4,r10,lsr #16
	beq	fillKeyedBlendDesAligned_SecondPixel

        
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r4,r5,r7
	sub	r4,r4,r6
	mul	r4,r12,r4
	add	r4,r6,r4,lsr #6
	and	r4,r4,r7
	
	orr  	r6,r4,lr  

	strh	r6,[r0]

 
fillKeyedBlendDesAligned_SecondPixel:

	ldrh	r8,[r1],#2	 
	cmp	r8,r10,lsr #16
 	beq	fillKeyedBlendDesAligned_SkipPixel


	mov	r4,r11,lsr #16
	
	and	r6,r4,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r4,r7 				// r6  = dwAlphaGtemp		
	
       	and	r4,r5,r7
	sub	r4,r4,r6
	mul	r4,r12,r4
	add	r4,r6,r4,lsr #6
	and	r4,r4,r7
	
	orr  	r8,r4,lr   	
	      
	strh	r8,[r0,#2]  
	         

fillKeyedBlendDesAligned_SkipPixel:   
	
	add 	r0,r0,#4
	subs	r3,r3,#1
	bne	fillKeyedBlendDesAligned_CopyWord 	



fillKeyedBlendDesAligned_CopyLastPixel:   

	ands	r2,r2,#1
	beq     fillKeyedBlendDesAligned_NextLine

	ldrh	r4,[r1],#2
	cmp	r4,r10,lsr #16
	beq	fillKeyedBlendDesAligned_SkipLastPixel
	
	ldrh	r11,[r0]
	and	r6,r11,r9				// r6  = dwAlphaRBtemp
	
	and	lr,r5,r9
	sub	lr,lr,r6
	mul	lr,r12,lr	
	add	lr,r6,lr,lsr #6
	and	lr,lr,r9
	
	and	r6,r11,r7 				// r6  = dwAlphaGtemp		
	
       	and	r4,r5,r7
	sub	r4,r4,r6
	mul	r4,r12,r4
	add	r4,r6,r4,lsr #6
	and	r4,r4,r7
	
	orr  	r6,r4,lr  	
	strh	r6,[r0]
     
	
fillKeyedBlendDesAligned_SkipLastPixel:
	add	r0,r0,#2

fillKeyedBlendDesAligned_NextLine:

	ldr	r2,[sp]
	ldr	r4,[sp,#-4]
	ldr	r6,[sp,#-8]
	ldr	r3,[sp,#-12]

	add	r1,r1,r4
	add	r0,r0,r6

	

	subs	r3,r3,#1
	str	r3,[sp,#-12]
	bne	fillKeyedBlendDesAligned_CheckCopyWords			// vertical loop

	ldr	r0,=2


	ldmia   sp!, { r4 - r12, pc }

