/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@ims.tuwien.ac.at>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klEGLSurfaceSDL.h,v 1.2 2004/01/13 14:40:28 tuhtah Exp $
 *
 *  This code was contributed by Ryan Rusaw of Cacko (cacko.biz)
 *
\**************************************************************************/


#ifndef __KLEGLSURFACE_SDL_HEADERFILE__
#define __KLEGLSURFACE_SDL_HEADERFILE__

#include <SDL/SDL_video.h>
#include "../klEGLSurface.h"

class Display;

class klEGLSurfaceSDL : public klEGLSurface
{
public:
	klEGLSurfaceSDL();
	~klEGLSurfaceSDL();
	
	virtual bool setNativeWindow(NativeWindowType nHWnd);
	virtual bool setNativeDisplay(NativeDisplayType nDisp);
	virtual bool destroy();
	virtual bool flip();

	virtual NativeWindowType getNativeWindow();
	virtual NativeDisplayType getNativeDisplay();

private:
	void setSize(int nWidth, int nHeight);
	SDL_Surface	*surface;
	bool		displayOpened;
};


#endif //__KLEGLSURFACE_SDL_HEADERFILE__
