/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/Base/klStack.h,v 1.2 2004/01/13 11:20:09 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __KLSTACK_HEADERFILE__
#define __KLSTACK_HEADERFILE__


// Implements a simple stack template class
// (especially for creating opengl matrix stacks)
//
template <class TYPE>
class klStack
{
public:
	klStack()
		{
			items = 0;  size = top = 0;
		}

	~klStack()
		{
			if(items)
				delete items;
		}

	inline void init(int nSize);

	void push(const TYPE& nItem)
		{
			items[++top] = nItem;
		}

	void pushCurrent()
		{
			items[top+1] = items[top];
			top++;
		}

	void pop()
		{
			top--;
		}

	void grow()
		{
			top++;
		}

	const TYPE& getTop() const
		{
			return items[top];
		}

	TYPE& getTop()
		{
			return items[top];
		}

	int getCurrentSize()
		{
			return top;
		}

	int getMaximumSize()
		{
			return size;
		}

protected:
	int		size, top;
	TYPE	*items;
};


template <class TYPE> inline void
klStack<TYPE>::init(int nSize)
{
	size = nSize;
	top = 0;

	if(items)
		delete [] items;
	items = new TYPE[size];
}


#endif //__KLSTACK_HEADERFILE__
