/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/Base/klMath.h,v 1.2 2004/01/13 11:20:09 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __KLMATH_HEADERFILE__
#define __KLMATH_HEADERFILE__

#ifdef _IS_LINUX_
  #include <asm/types.h>
  #ifndef __int32
    #define __int32 __s32
  #endif
  #ifndef __int64
    #define __int64 __s64
  #endif
#endif //_IS_LINUX_

// this block defines the basic data type
// which can be floating point or fixed point...
//
#if defined(_USE_REALFLOAT_)			// real (maybe emulated) floating point - should run almost everywhere, but SLOW!

  #include "klFloat_float.h"
  typedef klFloat_float klFloat;

#elif defined(_USE_FIXED_GPP_)			// fixed point with usage of the Intel GPP

  #include "klFloat_fixed.h"
  #include "klFixedBase_gpp.h"
  typedef klFloat_fixed<klFixedBase_gpp> klFloat;

#else									// generic fixed point - should run almost everywhere (needs __int64)
  #ifndef _USE_FIXED_GENERIC_
    #define _USE_FIXED_GENERIC_
  #endif //_USE_FIXED_GENERIC_

  #include "klFloat_fixed.h"
  #include "klFixedBase_generic.h"
  typedef klFloat_fixed<klFixedBase_generic> klFloat;

#endif


// define some more advanced data types
// on top of klFloat
//
#include "klMatrix.h"
#include "klVec4.h"
#include "klVec3.h"

typedef klMatrixT<klFloat> klMatrix;
typedef klVec4T<klFloat> klVec4;
typedef klVec3T<klFloat> klVec3;

typedef klVec3 klColor3;
typedef klVec4 klColor4;

#include "klVertex.h"


#endif //__KLMATH_HEADERFILE__
