/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/Base/klFixedBase_generic.h,v 1.1.1.1 2003/12/10 17:07:29 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __KLFIXEDBASE_GENERIC_HEADERFILE__
#define __KLFIXEDBASE_GENERIC_HEADERFILE__


// Genreic MATHBASE implementation for all
// platforms. This implementation is totally
// unoptimized.
// (e.g. using the sin() function from math.h)
//
class klFixedBase_generic
{
public:
	enum {
		PBITS = 16
	};

	static float floatFromFixed(int nFixed)
	{
		return nFixed/(float)(1 << PBITS);
	}

	static double doubleFromFixed(int nFixed)
	{
		return nFixed/(double)(1 << PBITS);
	}

	static int fixedFromInt(int nV)
	{
		return nV<<PBITS;
	}

	static int fixedFromFloat(float nV)
	{
		return (int)(nV *  (float)(1 << PBITS) + 0.5f);
	}

	static int fixedFromDouble(double nV)
	{
		return (int)(nV * (double)(1 << PBITS) + 0.5f);
	}

	static int inverse(int nFixed)
	{
		return (__int32)(((__int64)1<<(2*PBITS))/nFixed);
	}

	static int multiply(int nLeftFixed, int nRightFixed)
	{
		return (__int32)(((__int64)nLeftFixed * (__int64)nRightFixed) >> PBITS);
	}

	static int divide(int nLeftFixed, int nRightFixed)
	{
		return (__int32)(((__int64)nLeftFixed << PBITS) / nRightFixed);
	}

	static int cos(int nFixed)
	{
		return fixedFromDouble(::cos(floatFromFixed(nFixed)));
	}

	static int sin(int nFixed)
	{
		return fixedFromDouble(::sin(floatFromFixed(nFixed)));
	}

	static int fabs(int nFixed)
	{
		return nFixed<0 ? -nFixed : nFixed;
	}

	static int sqrt(int nFixed)
	{
		return fixedFromDouble(::sqrt(floatFromFixed(nFixed)));
	}

	static int inverseSqrt(int nFixed)
	{
		return inverse(sqrt(nFixed));
	}

	static int ceil(int nFixed)
	{
		int ret = (nFixed>>PBITS)<<PBITS;

		if(nFixed>=0 && ret<nFixed)
			ret += fixedFromInt(1);

		return ret;
	}

};


#endif //__KLFIXEDBASE_GENERIC_HEADERFILE__
