/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klChunkedMemory.cpp,v 1.2 2004/01/13 15:40:57 drgoldie Exp $
 *
\**************************************************************************/


#ifdef _IS_WINDOWS_
#pragma warning (disable: 4514)
#endif //_IS_WINDOWS

#include "klChunkedMemory.h"


klChunkedMemory::klChunkedMemory(int nChunkSize)
{
	chunkSizeMax = nChunkSize;
}


void*
klChunkedMemory::getNewMemory(int nSize)
{
	int curUsed = chunkSizes.getSize()>0 ? chunkSizes.getTail() : chunkSizeMax;

	// is there enough memory left in the current block?
	//
	if(curUsed+nSize<=chunkSizeMax)
	{
		void* mem = chunks.getTail() + curUsed;
		chunkSizes.getTail() += nSize;
		return mem;
	}

	// otherwise we need to allocate a new block and
	// return its start address
	//
	unsigned char* newChunk = new unsigned char[chunkSizeMax];
	chunks.addTail(newChunk);
	chunkSizes.addTail(nSize);
	return newChunk;
}


void
klChunkedMemory::cleanup()
{
	int i,num=chunks.getSize();

	for(i=0; i<num; i++)
		delete chunks[i];

	chunks.removeAll();
	chunkSizes.removeAll();
}
