/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klAttributes.h,v 1.1 2004/01/13 11:20:09 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __ATTRIBUTES_HEADERFILE__
#define __ATTRIBUTES_HEADERFILE__


struct klAttributes
{
	GLbitfield mask;

	// GL_CURRENT_BIT
	//
	klColor4			currentColor;
	klVec3				currentNormal;
	klVec4				currentTexCoord;

	// GL_POLYGON_BIT
	//
	bool				cullingEnabled;
	GLenum				cullMode,
						frontPolyMode, backPolyMode,
						frontFace;

	// GL_LIGHTING_BIT
	//
	bool				colorMaterialEnabled;
	MATERIAL			materialFront, materialBack;
	LIGHTMODEL			lightModel;
	LIGHT				lights[MAX_LIGHTS];

	// GL_FOG_BIT
	FOG					fog;

	// GL_DEPTH_BUFFER_BIT
	bool				depthTestEnabled,
						depthWriteEnabled;
	RASTER_MODE_ZTEST	depthFunc;
	klFloat				clearDepth;

	// GL_TRANSFORM_BIT 
	klStack<klMatrix>*	curStack;
	bool				normalizeNormalsEnabled;

	// GL_ENABLE_BIT
	bool				lightingEnabled,
						texturingEnabled;

	// GL_COLOR_BUFFER_BIT
	BLEND				blend;

	// GL_SCISSOR_BIT
	SCISSOR				scissor;
};


struct klClientAttributes
{
	GLbitfield mask;

	// GL_CLIENT_VERTEX_ARRAY_BIT
	klArray	arrayVertex,
			arrayNormal,
			arrayColor,
			arrayTexCoord;
};


#endif //__ATTRIBUTES_HEADERFILE__
