/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/include/egl_definitions.h,v 1.3 2004/01/14 10:01:50 drgoldie Exp $
 *
\**************************************************************************/

#include "klMain.h"

/*
** Versioning and extensions
*/
#define EGL_VERSION_1_0                1

/*
** Boolean
*/
#ifndef EGL_FALSE
#define EGL_FALSE                      0
#endif

#ifndef EGL_TRUE
#define EGL_TRUE                       1
#endif

#define EGL_DRAW                       0x3059
#define EGL_READ                       0x305A

typedef void *	EGLDisplay;
typedef void *	EGLConfig;
typedef void *	EGLSurface;
typedef void *	EGLContext;

typedef int				EGLBoolean;
typedef unsigned int	EGLint;


#define EGL_DEFAULT_DISPLAY ((NativeDisplayType)0)
#define EGL_NO_CONTEXT ((EGLContext)0)
#define EGL_NO_DISPLAY ((EGLDisplay)0)
#define EGL_NO_SURFACE ((EGLSurface)0)


#ifdef _IS_WINDOWS_

  #include <windows.h>
  typedef HDC		NativeDisplayType;
  typedef HWND		NativeWindowType;
  typedef HBITMAP	NativePixmapType;

#endif //_IS_WINDOWS_

#ifdef _IS_LINUX_

  #ifndef NULL
  	#define NULL 0L
  #endif

  #ifdef _IS_QTEMBEDDED_
    	#include <qwidget.h>
	typedef void*		NativeDisplayType;
	typedef QWidget*	NativeWindowType;
	typedef void*		NativePixmapType;	
  #endif //_IS_QTEMBEDDED_

  #ifdef _IS_SDL_
    typedef void*		NativeDisplayType;
    typedef void*		NativeWindowType;
    typedef void*		NativePixmapType;
  #endif //_IS_SDL_
  
#endif //_IS_LINUX_
