/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-6 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#ifndef __JUCE_THREADPOOL_JUCEHEADER__
#define __JUCE_THREADPOOL_JUCEHEADER__

#include "juce_Thread.h"
#include "juce_ScopedLock.h"
#include "../text/juce_StringArray.h"
#include "../containers/juce_VoidArray.h"
class ThreadPool;
class ThreadPoolThread;


//==============================================================================
/**
    A task that is executed by a ThreadPool object.

    A ThreadPool keeps a list of ThreadPoolJob objects which are executed by
    its threads.

    The run() method needs to be implemented to do the task in hand, and the
    code in here should keep repeatedly checking the jobShouldExit() method to
    see if something is trying to interrupt the job.

    xxx TODO This class isn't finished!

    @see ThreadPool, Thread
*/
class JUCE_API  ThreadPoolJob
{
public:
    //==============================================================================
    ThreadPoolJob (const String& name);
    virtual ~ThreadPoolJob();

    //==============================================================================
    const String getJobName() const;
    void setJobName (const String& newName);

    //==============================================================================
    enum JobStatus
    {
        jobHasFinished = 0,
        jobNeedsRunningAgain
    };

    virtual JobStatus runJob() = 0;

    virtual void removedFromQueue() = 0;

    //==============================================================================
    bool isRunning() const throw()       { return isActive; }
    bool shouldExit() const throw()      { return shouldStop; }

    void signalJobShouldExit();


    //==============================================================================
    juce_UseDebuggingNewOperator

private:
    friend class ThreadPool;
    friend class ThreadPoolThread;
    String jobName;
    ThreadPool* pool;
    bool shouldStop, isActive;
};


//==============================================================================
/**
    A set of threads that will run a list of queued jobs in order.

    When a ThreadPoolJob object is added to the ThreadPool's list, its run() method
    will be called by the next pooled thread that becomes free.

    xxx TODO This class isn't finished!

    @see ThreadPoolJob, Thread
*/
class JUCE_API  ThreadPool
{
public:
    //==============================================================================
    ThreadPool (const int numberOfThreads,
                const bool startThreadsOnlyWhenNeeded = true,
                const int stopThreadsWhenNotUsedTimeoutMs = 5000);

    ~ThreadPool();

    //==============================================================================
    void addJob (ThreadPoolJob* const job);

    bool isJobQueuedOrRunning (const ThreadPoolJob* const job) const;
    bool isJobRunning (const ThreadPoolJob* const job) const;

    bool waitForJobToFinish (const ThreadPoolJob* const job,
                             const int timeOutMs) const;

    bool removeJob (ThreadPoolJob* const job,
                    const bool interruptIfRunning,
                    const int timeOutMs);

    bool removeAllJobs (const bool interruptRunningJobs,
                        const int timeOutMs);

    int getNumQueuedOrActiveJobs() const;

    const StringArray getNamesOfActiveJobs() const;

    void setThreadPriorities (int priority);


    //==============================================================================
    juce_UseDebuggingNewOperator

private:
    int numThreads;
    Thread** threads;
    VoidArray queuedJobs;

    CriticalSection lock;
    int priority, threadStopTimeout;
    uint32 lastJobEndTime;

    friend class ThreadPoolThread;
    bool runNextJob();

    ThreadPool (const ThreadPool&);
    const ThreadPool& operator= (const ThreadPool&);
};


#endif   // __JUCE_THREADPOOL_JUCEHEADER__
