/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-6 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#include "../basics/juce_StandardHeader.h"

BEGIN_JUCE_NAMESPACE


#include "juce_InterProcessLock.h"


//==============================================================================
void* juce_getGlobalLock (const String& lockName, int timeoutMillis);
void juce_releaseGlobalLock (void* handle);


//==============================================================================
InterProcessLock::InterProcessLock (const String& name_)
    : internal (0),
      name (name_),
      reentrancyLevel (0)
{
}

InterProcessLock::~InterProcessLock()
{
    exit();
}

bool InterProcessLock::enter (int timeOutMillisecs)
{
    if (reentrancyLevel++ == 0)
        internal = juce_getGlobalLock (name, timeOutMillisecs);

    return (internal != 0);
}

void InterProcessLock::exit()
{
    if (--reentrancyLevel == 0 && internal != 0)
    {
        juce_releaseGlobalLock (internal);
        internal = 0;
    }
}

END_JUCE_NAMESPACE
