/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-6 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#include "../../../../juce_core/basics/juce_StandardHeader.h"

BEGIN_JUCE_NAMESPACE


#include "juce_Drawable.h"


//==============================================================================
Drawable::Drawable()
{
}

Drawable::~Drawable()
{
}

void Drawable::drawAt (Graphics& g, const float x, const float y) const
{
    draw (g, AffineTransform::identity.translated (x, y));
}

void Drawable::drawWithin (Graphics& g,
                           const int destX,
                           const int destY,
                           const int destW,
                           const int destH,
                           const Justification& justification,
                           const bool onlyReduceInSize) const
{
    float x, y, w, h;
    getBounds (x, y, w, h);

    if (w > 0 && h > 0 && destW > 0 && destH > 0)
    {
        float newW, newH;

        if (onlyReduceInSize && w <= destW && h <= destH)
        {
            newW = w;
            newH = h;
        }
        else
        {
            const float imageRatio = h / w;
            const float targetRatio = destH / (float) destW;

            if (imageRatio <= targetRatio)
            {
                newW = (float) destW;
                newH = newW * imageRatio;
            }
            else
            {
                newH = (float) destH;
                newW = newH / imageRatio;
            }
        }

        if (newW > 0 && newH > 0)
        {
            int newX = 0, newY = 0;

            justification.applyToRectangle (newX, newY,
                                            roundFloatToInt (newW),
                                            roundFloatToInt (newH),
                                            destX, destY,
                                            destW, destH);

            draw (g, AffineTransform::identity
                        .translated (-x, -y)
                        .scaled (newW / w, newH / h)
                        .translated ((float) newX, (float) newY));
        }
    }
}

END_JUCE_NAMESPACE
