/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-6 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#ifndef __JUCE_MESSAGE_JUCEHEADER__
#define __JUCE_MESSAGE_JUCEHEADER__

class MessageListener;


//==============================================================================
/** The base class for objects that can be delivered to a MessageListener.

    The simplest Message object contains a few integer and pointer parameters
    that the user can set, and this is enough for a lot of purposes. For passing more
    complex data, subclasses of Message can also be used.

    @see MessageListener, MessageManager, ActionListener, ChangeListener
*/
class JUCE_API  Message
{
public:
    //==============================================================================
    /** Creates an uninitialised message.

        The class's variables will also be left uninitialised.
    */
    Message() throw();

    /** Creates a message object, filling in the member variables.

        The corresponding public member variables will be set from the parameters
        passed in.
    */
    Message (const int intParameter1,
             const int intParameter2,
             const int intParameter3,
             void* const pointerParameter) throw();

    /** Destructor. */
    virtual ~Message() throw();

    //==============================================================================
    // These values can be used for carrying simple data that the application needs to
    // pass around. For more complex messages, just create a subclass.

    int intParameter1;          /**< user-defined integer value. */
    int intParameter2;          /**< user-defined integer value. */
    int intParameter3;          /**< user-defined integer value. */
    void* pointerParameter;     /**< user-defined pointer value. */


    //==============================================================================
    juce_UseDebuggingNewOperator

private:
    friend class MessageListener;
    friend class MessageManager;
    MessageListener* messageRecipient;

    Message (const Message&);
    const Message& operator= (const Message&);
};


#endif   // __JUCE_MESSAGE_JUCEHEADER__
