/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-6 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#ifndef __JUCE_JUCE_APP_INCLUDES_INCLUDEFILES__
#define __JUCE_JUCE_APP_INCLUDES_INCLUDEFILES__

#include "juce_appframework/application/juce_Application.h"
#include "juce_appframework/application/juce_DeletedAtShutdown.h"
#include "juce_appframework/application/juce_PropertiesFile.h"
#include "juce_appframework/application/juce_SystemClipboard.h"
#include "juce_appframework/audio/juce_AudioDataConverters.h"
#include "juce_appframework/audio/juce_AudioSampleBuffer.h"
#include "juce_appframework/audio/juce_Synthesiser.h"
#include "juce_appframework/audio/midi/juce_MidiBuffer.h"
#include "juce_appframework/audio/midi/juce_MidiFile.h"
#include "juce_appframework/audio/midi/juce_MidiKeyboardState.h"
#include "juce_appframework/audio/midi/juce_MidiMessage.h"
#include "juce_appframework/audio/midi/juce_MidiMessageCollector.h"
#include "juce_appframework/audio/midi/juce_MidiMessageSequence.h"
#include "juce_appframework/audio/audio_sources/juce_AudioFormatReaderSource.h"
#include "juce_appframework/audio/audio_sources/juce_AudioSource.h"
#include "juce_appframework/audio/audio_sources/juce_AudioSourcePlayer.h"
#include "juce_appframework/audio/audio_sources/juce_AudioTransportSource.h"
#include "juce_appframework/audio/audio_sources/juce_BufferingAudioSource.h"
#include "juce_appframework/audio/audio_sources/juce_MixerAudioSource.h"
#include "juce_appframework/audio/audio_sources/juce_PositionableAudioSource.h"
#include "juce_appframework/audio/audio_sources/juce_ResamplingAudioSource.h"
#include "juce_appframework/audio/audio_sources/juce_ToneGeneratorAudioSource.h"
#include "juce_appframework/audio/devices/juce_AudioDeviceManager.h"
#include "juce_appframework/audio/devices/juce_AudioIODevice.h"
#include "juce_appframework/audio/devices/juce_AudioIODeviceType.h"
#include "juce_appframework/audio/devices/juce_MidiInput.h"
#include "juce_appframework/audio/devices/juce_MidiOutput.h"
#include "juce_appframework/audio/audio_file_formats/juce_AiffAudioFormat.h"
#include "juce_appframework/audio/audio_file_formats/juce_AudioCDReader.h"
#include "juce_appframework/audio/audio_file_formats/juce_AudioFormat.h"
#include "juce_appframework/audio/audio_file_formats/juce_AudioFormatManager.h"
#include "juce_appframework/audio/audio_file_formats/juce_AudioFormatReader.h"
#include "juce_appframework/audio/audio_file_formats/juce_AudioFormatWriter.h"
#include "juce_appframework/audio/audio_file_formats/juce_AudioSubsectionReader.h"
#include "juce_appframework/audio/audio_file_formats/juce_FlacAudioFormat.h"
#include "juce_appframework/audio/audio_file_formats/juce_OggVorbisAudioFormat.h"
#include "juce_appframework/audio/audio_file_formats/juce_WavAudioFormat.h"
#include "juce_appframework/events/juce_ActionBroadcaster.h"
#include "juce_appframework/events/juce_ActionListener.h"
#include "juce_appframework/events/juce_ActionListenerList.h"
#include "juce_appframework/events/juce_AsyncUpdater.h"
#include "juce_appframework/events/juce_ChangeBroadcaster.h"
#include "juce_appframework/events/juce_ChangeListener.h"
#include "juce_appframework/events/juce_ChangeListenerList.h"
#include "juce_appframework/events/juce_InterprocessConnection.h"
#include "juce_appframework/events/juce_InterprocessConnectionServer.h"
#include "juce_appframework/events/juce_Message.h"
#include "juce_appframework/events/juce_MessageListener.h"
#include "juce_appframework/events/juce_MessageManager.h"
#include "juce_appframework/events/juce_Timer.h"
#include "juce_appframework/gui/graphics/brushes/juce_Brush.h"
#include "juce_appframework/gui/graphics/brushes/juce_GradientBrush.h"
#include "juce_appframework/gui/graphics/brushes/juce_ImageBrush.h"
#include "juce_appframework/gui/graphics/brushes/juce_SolidColourBrush.h"
#include "juce_appframework/gui/graphics/colour/juce_Colour.h"
#include "juce_appframework/gui/graphics/colour/juce_ColourGradient.h"
#include "juce_appframework/gui/graphics/colour/juce_Colours.h"
#include "juce_appframework/gui/graphics/colour/juce_PixelFormats.h"
#include "juce_appframework/gui/graphics/fonts/juce_Font.h"
#include "juce_appframework/gui/graphics/fonts/juce_GlyphArrangement.h"
#include "juce_appframework/gui/graphics/fonts/juce_TextLayout.h"
#include "juce_appframework/gui/graphics/fonts/juce_Typeface.h"
#include "juce_appframework/gui/graphics/contexts/juce_EdgeTable.h"
#include "juce_appframework/gui/graphics/contexts/juce_Graphics.h"
#include "juce_appframework/gui/graphics/contexts/juce_Justification.h"
#include "juce_appframework/gui/graphics/contexts/juce_LowLevelGraphicsContext.h"
#include "juce_appframework/gui/graphics/contexts/juce_LowLevelGraphicsSoftwareRenderer.h"
#include "juce_appframework/gui/graphics/geometry/juce_AffineTransform.h"
#include "juce_appframework/gui/graphics/geometry/juce_BorderSize.h"
#include "juce_appframework/gui/graphics/geometry/juce_Line.h"
#include "juce_appframework/gui/graphics/geometry/juce_Path.h"
#include "juce_appframework/gui/graphics/geometry/juce_PathIterator.h"
#include "juce_appframework/gui/graphics/geometry/juce_PathStrokeType.h"
#include "juce_appframework/gui/graphics/geometry/juce_Point.h"
#include "juce_appframework/gui/graphics/geometry/juce_Rectangle.h"
#include "juce_appframework/gui/graphics/geometry/juce_RectangleList.h"
#include "juce_appframework/gui/graphics/imaging/juce_Image.h"
#include "juce_appframework/gui/graphics/imaging/juce_ImageCache.h"
#include "juce_appframework/gui/graphics/imaging/juce_ImageConvolutionKernel.h"
#include "juce_appframework/gui/graphics/imaging/juce_ImageFileFormat.h"
#include "juce_appframework/gui/graphics/drawables/juce_Drawable.h"
#include "juce_appframework/gui/graphics/drawables/juce_DrawableComposite.h"
#include "juce_appframework/gui/graphics/drawables/juce_DrawableImage.h"
#include "juce_appframework/gui/graphics/drawables/juce_DrawablePath.h"
#include "juce_appframework/gui/graphics/drawables/juce_DrawableText.h"
#include "juce_appframework/gui/components/juce_Component.h"
#include "juce_appframework/gui/components/juce_ComponentDeletionWatcher.h"
#include "juce_appframework/gui/components/juce_ComponentListener.h"
#include "juce_appframework/gui/components/juce_Desktop.h"
#include "juce_appframework/gui/components/juce_RepaintManager.h"
#include "juce_appframework/gui/components/buttons/juce_ArrowButton.h"
#include "juce_appframework/gui/components/buttons/juce_Button.h"
#include "juce_appframework/gui/components/buttons/juce_DrawableButton.h"
#include "juce_appframework/gui/components/buttons/juce_HyperlinkButton.h"
#include "juce_appframework/gui/components/buttons/juce_ImageButton.h"
#include "juce_appframework/gui/components/buttons/juce_ShapeButton.h"
#include "juce_appframework/gui/components/buttons/juce_TextButton.h"
#include "juce_appframework/gui/components/buttons/juce_ToggleButton.h"
#include "juce_appframework/gui/graphics/effects/juce_DropShadowEffect.h"
#include "juce_appframework/gui/graphics/effects/juce_GlowEffect.h"
#include "juce_appframework/gui/graphics/effects/juce_ImageEffectFilter.h"
#include "juce_appframework/gui/graphics/effects/juce_ReduceOpacityEffect.h"
#include "juce_appframework/gui/components/keyboard/juce_KeyListener.h"
#include "juce_appframework/gui/components/keyboard/juce_KeyMappingEditorComponent.h"
#include "juce_appframework/gui/components/keyboard/juce_KeyPress.h"
#include "juce_appframework/gui/components/keyboard/juce_KeyPressMappingSet.h"
#include "juce_appframework/gui/components/keyboard/juce_ModifierKeys.h"
#include "juce_appframework/gui/components/menus/juce_MenuBarComponent.h"
#include "juce_appframework/gui/components/menus/juce_MenuBarModel.h"
#include "juce_appframework/gui/components/menus/juce_PopupMenu.h"
#include "juce_appframework/gui/components/menus/juce_PopupMenuCustomComponent.h"
#include "juce_appframework/gui/components/mouse/juce_ComponentDragger.h"
#include "juce_appframework/gui/components/mouse/juce_DragAndDropContainer.h"
#include "juce_appframework/gui/components/mouse/juce_DragAndDropTarget.h"
#include "juce_appframework/gui/components/mouse/juce_LassoComponent.h"
#include "juce_appframework/gui/components/mouse/juce_MouseCursor.h"
#include "juce_appframework/gui/components/mouse/juce_MouseEvent.h"
#include "juce_appframework/gui/components/mouse/juce_MouseHoverDetector.h"
#include "juce_appframework/gui/components/mouse/juce_MouseListener.h"
#include "juce_appframework/gui/components/controls/juce_ComboBox.h"
#include "juce_appframework/gui/components/controls/juce_FilenameComponent.h"
#include "juce_appframework/gui/components/controls/juce_Label.h"
#include "juce_appframework/gui/components/controls/juce_ListBox.h"
#include "juce_appframework/gui/components/controls/juce_ProgressBar.h"
#include "juce_appframework/gui/components/controls/juce_SimpleListBox.h"
#include "juce_appframework/gui/components/controls/juce_Slider.h"
#include "juce_appframework/gui/components/controls/juce_TextEditor.h"
#include "juce_appframework/gui/components/controls/juce_TreeView.h"
#include "juce_appframework/gui/components/layout/juce_ComponentBoundsConstrainer.h"
#include "juce_appframework/gui/components/layout/juce_GroupComponent.h"
#include "juce_appframework/gui/components/layout/juce_ResizableBorderComponent.h"
#include "juce_appframework/gui/components/layout/juce_ResizableCornerComponent.h"
#include "juce_appframework/gui/components/layout/juce_ScrollBar.h"
#include "juce_appframework/gui/components/layout/juce_StretchableLayoutManager.h"
#include "juce_appframework/gui/components/layout/juce_StretchableLayoutResizerBar.h"
#include "juce_appframework/gui/components/layout/juce_TabbedButtonBar.h"
#include "juce_appframework/gui/components/layout/juce_TabbedComponent.h"
#include "juce_appframework/gui/components/layout/juce_Viewport.h"
#include "juce_appframework/gui/components/filebrowser/juce_DirectoryContentsList.h"
#include "juce_appframework/gui/components/filebrowser/juce_FileBrowserComponent.h"
#include "juce_appframework/gui/components/filebrowser/juce_FileBrowserListener.h"
#include "juce_appframework/gui/components/filebrowser/juce_FileChooser.h"
#include "juce_appframework/gui/components/filebrowser/juce_FileChooserDialogBox.h"
#include "juce_appframework/gui/components/filebrowser/juce_FileFilter.h"
#include "juce_appframework/gui/components/filebrowser/juce_FileListComponent.h"
#include "juce_appframework/gui/components/filebrowser/juce_FilePreviewComponent.h"
#include "juce_appframework/gui/components/filebrowser/juce_ImagePreviewComponent.h"
#include "juce_appframework/gui/components/filebrowser/juce_WildcardFileFilter.h"
#include "juce_appframework/gui/components/windows/juce_AlertWindow.h"
#include "juce_appframework/gui/components/windows/juce_ComponentPeer.h"
#include "juce_appframework/gui/components/windows/juce_DialogWindow.h"
#include "juce_appframework/gui/components/windows/juce_DocumentWindow.h"
#include "juce_appframework/gui/components/windows/juce_ResizableWindow.h"
#include "juce_appframework/gui/components/windows/juce_SplashScreen.h"
#include "juce_appframework/gui/components/windows/juce_ThreadWithProgressWindow.h"
#include "juce_appframework/gui/components/windows/juce_ToolTipWindow.h"
#include "juce_appframework/gui/components/windows/juce_TopLevelWindow.h"
#include "juce_appframework/gui/components/special/juce_AudioDeviceSelectorComponent.h"
#include "juce_appframework/gui/components/special/juce_BubbleComponent.h"
#include "juce_appframework/gui/components/special/juce_BubbleMessageComponent.h"
#include "juce_appframework/gui/components/special/juce_ColourSelector.h"
#include "juce_appframework/gui/components/special/juce_DropShadower.h"
#include "juce_appframework/gui/components/special/juce_MidiKeyboardComponent.h"
#include "juce_appframework/gui/components/special/juce_OpenGLComponent.h"
#include "juce_appframework/gui/components/special/juce_PreferencesPanel.h"
#include "juce_appframework/gui/components/special/juce_QuickTimeMovieComponent.h"
#include "juce_appframework/gui/components/lookandfeel/juce_LookAndFeel.h"
#include "juce_appframework/gui/components/lookandfeel/juce_ShinyLookAndFeel.h"
#include "juce_appframework/documents/juce_FileBasedDocument.h"
#include "juce_appframework/documents/juce_RecentlyOpenedFilesList.h"
#include "juce_appframework/documents/juce_SelectedItemSet.h"
#include "juce_appframework/documents/juce_UndoableAction.h"
#include "juce_appframework/documents/juce_UndoManager.h"

#endif
