#include "zeesearchdialog.h"

#include "zeeutil.h"

#include <qpe/resource.h>

#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>

ZeeSearchDialog::ZeeSearchDialog(QWidget* parent, const char* name)
    : QDialog(parent, name, true)
{
    setCaption(tr("Zee Cookbook - Search Recipe"));
    
    QLabel* searchLabel = new QLabel(tr("Search For:"), this);

    searchLineEdit = new QLineEdit(this);
    connect(searchLineEdit, SIGNAL(returnPressed()), this, SLOT(accept()));

    advancedPushButton = new QPushButton(Resource::loadIconSet("zeecookbook/down"), tr("Advanced Search"), this);
    connect(advancedPushButton, SIGNAL(clicked()), this, SLOT(advancedSearch()));

    simplePushButton = new QPushButton(Resource::loadIconSet("zeecookbook/up"), tr("Simple Search"), this);
    connect(simplePushButton, SIGNAL(clicked()), this, SLOT(simpleSearch()));
    
    nameCheckBox = new QCheckBox(tr("In name"), this);
    categoryCheckBox = new QCheckBox(tr("In categories"), this);
    ingredientCheckBox = new QCheckBox(tr("In ingredients"), this);
    directionCheckBox = new QCheckBox(tr("In directions"), this);

    QVBoxLayout* mainLayout = new QVBoxLayout(this, 4, 4);
    QHBoxLayout* searchLayout = new QHBoxLayout();
    QGridLayout* advancedLayout = new QGridLayout(2, 2, 4);

    searchLayout->addWidget(searchLabel);
    searchLayout->addWidget(searchLineEdit);

    advancedLayout->addWidget(nameCheckBox, 0, 0);
    advancedLayout->addWidget(categoryCheckBox, 0, 1);
    advancedLayout->addWidget(ingredientCheckBox, 1, 0);
    advancedLayout->addWidget(directionCheckBox, 1, 1);

    mainLayout->addLayout(searchLayout);
    mainLayout->addWidget(advancedPushButton);
    mainLayout->addLayout(advancedLayout);
    mainLayout->addWidget(simplePushButton);
    mainLayout->addStretch();

    simpleSearch();
}

ZeeSearchDialog::~ZeeSearchDialog()
{
}

QString ZeeSearchDialog::selected() const
{
    QString searchString = zeeFormatString("%" + searchLineEdit->text() + "%");
    QStringList filters;

    if (nameCheckBox->isChecked()) {
        filters.append("name LIKE " + searchString);
    }

    if (categoryCheckBox->isChecked()) {
        filters.append("id IN (SELECT recipe_id FROM recipe_category, category WHERE category_id = category.id AND name LIKE " + searchString + ")");
    }

    if (ingredientCheckBox->isChecked()) {
        filters.append("id IN (SELECT recipe_id FROM recipe_ingredient, ingredient WHERE ingredient_id = ingredient.id AND name LIKE " + searchString + ")");
    }

    if (directionCheckBox->isChecked()) {
        filters.append("direction LIKE " + searchString);
    }

    QString filter;
    int count = filters.count();

    if (count > 0) {
        filter += filters[0];
        
        for (int i = 1; i < count; i++) {
            filter += " OR " + filters[i];
        }
    }

    return filter;
}

void ZeeSearchDialog::advancedSearch()
{
    advancedPushButton->hide();
    nameCheckBox->show();
    categoryCheckBox->show();
    ingredientCheckBox->show();
    directionCheckBox->show();
    simplePushButton->show();
}

void ZeeSearchDialog::simpleSearch()
{
    advancedPushButton->show();
    nameCheckBox->hide();
    categoryCheckBox->hide();
    ingredientCheckBox->hide();
    directionCheckBox->hide();
    simplePushButton->hide();

    nameCheckBox->setChecked(true);
    categoryCheckBox->setChecked(true);
    ingredientCheckBox->setChecked(true);
    directionCheckBox->setChecked(true);
}
